/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.alpha;

import android.support.annotation.NonNull;
import android.view.View;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIResHelper;
import java.lang.ref.WeakReference;

public class QMUIAlphaViewHelper {
    private WeakReference<View> mTarget;
    private boolean mChangeAlphaWhenPress = true;
    private boolean mChangeAlphaWhenDisable = true;
    private float mNormalAlpha = 1.0f;
    private float mPressedAlpha = 0.5f;
    private float mDisabledAlpha = 0.5f;

    public QMUIAlphaViewHelper(@NonNull View target) {
        this.mTarget = new WeakReference<View>(target);
        this.mPressedAlpha = QMUIResHelper.getAttrFloatValue(target.getContext(), R.attr.qmui_alpha_pressed);
        this.mDisabledAlpha = QMUIResHelper.getAttrFloatValue(target.getContext(), R.attr.qmui_alpha_disabled);
    }

    public QMUIAlphaViewHelper(@NonNull View target, float pressedAlpha, float disabledAlpha) {
        this.mTarget = new WeakReference<View>(target);
        this.mPressedAlpha = pressedAlpha;
        this.mDisabledAlpha = disabledAlpha;
    }

    public void onPressedChanged(View current, boolean pressed) {
        View target = (View)this.mTarget.get();
        if (target == null) {
            return;
        }
        if (current.isEnabled()) {
            target.setAlpha(this.mChangeAlphaWhenPress && pressed && current.isClickable() ? this.mPressedAlpha : this.mNormalAlpha);
        } else if (this.mChangeAlphaWhenDisable) {
            target.setAlpha(this.mDisabledAlpha);
        }
    }

    public void onEnabledChanged(View current, boolean enabled) {
        View target = (View)this.mTarget.get();
        if (target == null) {
            return;
        }
        float alphaForIsEnable = this.mChangeAlphaWhenDisable ? (enabled ? this.mNormalAlpha : this.mDisabledAlpha) : this.mNormalAlpha;
        if (current != target && target.isEnabled() != enabled) {
            target.setEnabled(enabled);
        }
        target.setAlpha(alphaForIsEnable);
    }

    public void setChangeAlphaWhenPress(boolean changeAlphaWhenPress) {
        this.mChangeAlphaWhenPress = changeAlphaWhenPress;
    }

    public void setChangeAlphaWhenDisable(boolean changeAlphaWhenDisable) {
        this.mChangeAlphaWhenDisable = changeAlphaWhenDisable;
        View target = (View)this.mTarget.get();
        if (target != null) {
            this.onEnabledChanged(target, target.isEnabled());
        }
    }
}

