/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.link;

import android.content.res.ColorStateList;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.util.Patterns;
import android.view.View;
import android.webkit.WebView;
import android.widget.TextView;
import com.qmuiteam.qmui.link.ITouchableSpan;
import com.qmuiteam.qmui.span.QMUIOnSpanClickListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QMUILinkify {
    public static final Pattern WECHAT_PHONE = Pattern.compile("\\+?(\\d{2,8}([- ]?\\d{3,8}){2,6}|\\d{5,20})");
    public static final Pattern NOT_PHONE = Pattern.compile("^\\d+(\\.\\d+)+(-\\d+)*$");
    private static final String UrlEndAppendNextChars = "[$]";
    public static final int WEB_URLS = 1;
    public static final int EMAIL_ADDRESSES = 2;
    public static final int PHONE_NUMBERS = 4;
    public static final int MAP_ADDRESSES = 8;
    public static final int ALL = 15;
    private static final int PHONE_NUMBER_MINIMUM_DIGITS = 7;
    public static final MatchFilter sUrlMatchFilter = new MatchFilter(){

        @Override
        public final boolean acceptMatch(CharSequence s, int start, int end) {
            try {
                for (int i = start; i < end; ++i) {
                    if (s.charAt(i) <= '\u0100') continue;
                    return false;
                }
                try {
                    char nextChar = s.charAt(end);
                    if (nextChar < '\u0100' && 0 > QMUILinkify.UrlEndAppendNextChars.indexOf(nextChar) && !Character.isWhitespace(nextChar)) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (start == 0) {
                    return true;
                }
                if (s.charAt(start - 1) == '@') {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
    };
    public static final MatchFilter sPhoneNumberMatchFilter = new MatchFilter(){

        @Override
        public final boolean acceptMatch(CharSequence s, int start, int end) {
            int digitCount = 0;
            for (int i = start; i < end; ++i) {
                if (!Character.isDigit(s.charAt(i)) || ++digitCount < 7) continue;
                return true;
            }
            return false;
        }
    };
    public static final TransformFilter sPhoneNumberTransformFilter = new TransformFilter(){

        @Override
        public final String transformUrl(Matcher match, String url) {
            return Patterns.digitsAndPlusOnly((Matcher)match);
        }
    };
    private static final int MAX_NUMBER = 21;

    public static boolean addLinks(Spannable text, int mask, ColorStateList linkColor, ColorStateList bgColor, QMUIOnSpanClickListener l) {
        if (mask == 0) {
            return false;
        }
        URLSpan[] old = (URLSpan[])text.getSpans(0, text.length(), URLSpan.class);
        for (int i = old.length - 1; i >= 0; --i) {
            text.removeSpan((Object)old[i]);
        }
        ArrayList<LinkSpec> links = new ArrayList<LinkSpec>();
        if ((mask & 1) != 0) {
            QMUILinkify.gatherLinks(links, text, Patterns.WEB_URL, new String[]{"http://", "https://", "rtsp://"}, sUrlMatchFilter, null);
        }
        if ((mask & 2) != 0) {
            QMUILinkify.gatherLinks(links, text, Patterns.EMAIL_ADDRESS, new String[]{"mailto:"}, null, null);
        }
        if ((mask & 4) != 0) {
            QMUILinkify.gatherPhoneLinks(links, text, WECHAT_PHONE, new Pattern[]{NOT_PHONE}, new String[]{"tel:"}, sPhoneNumberMatchFilter, sPhoneNumberTransformFilter);
        }
        if ((mask & 8) != 0) {
            QMUILinkify.gatherMapLinks(links, text);
        }
        QMUILinkify.pruneOverlaps(links);
        if (links.size() == 0) {
            return false;
        }
        for (LinkSpec link : links) {
            QMUILinkify.applyLink(link.url, link.start, link.end, text, linkColor, bgColor, l);
        }
        return true;
    }

    public static boolean addLinks(TextView text, int mask, ColorStateList linkColor, ColorStateList bgColor, QMUIOnSpanClickListener l) {
        if (mask == 0) {
            return false;
        }
        CharSequence t = text.getText();
        if (t instanceof Spannable) {
            if (QMUILinkify.addLinks((Spannable)t, mask, linkColor, bgColor, l)) {
                QMUILinkify.addLinkMovementMethod(text);
                return true;
            }
            return false;
        }
        SpannableString s = SpannableString.valueOf((CharSequence)t);
        if (QMUILinkify.addLinks((Spannable)s, mask, linkColor, bgColor, l)) {
            QMUILinkify.addLinkMovementMethod(text);
            text.setText((CharSequence)s);
            return true;
        }
        return false;
    }

    private static void addLinkMovementMethod(TextView t) {
        MovementMethod m = t.getMovementMethod();
        if ((m == null || !(m instanceof LinkMovementMethod)) && t.getLinksClickable()) {
            t.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    public static void addLinks(TextView text, Pattern pattern, String scheme) {
        QMUILinkify.addLinks(text, pattern, scheme, null, null);
    }

    public static void addLinks(TextView text, Pattern p, String scheme, MatchFilter matchFilter, TransformFilter transformFilter) {
        SpannableString s = SpannableString.valueOf((CharSequence)text.getText());
        if (QMUILinkify.addLinks((Spannable)s, p, scheme, matchFilter, transformFilter)) {
            text.setText((CharSequence)s);
            QMUILinkify.addLinkMovementMethod(text);
        }
    }

    public static boolean addLinks(Spannable text, Pattern pattern, String scheme) {
        return QMUILinkify.addLinks(text, pattern, scheme, null, null);
    }

    public static boolean addLinks(Spannable s, Pattern p, String scheme, MatchFilter matchFilter, TransformFilter transformFilter) {
        boolean hasMatches = false;
        String prefix = scheme == null ? "" : scheme.toLowerCase(Locale.ROOT);
        Matcher m = p.matcher((CharSequence)s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            boolean allowed = true;
            if (matchFilter != null) {
                allowed = matchFilter.acceptMatch((CharSequence)s, start, end);
            }
            if (!allowed) continue;
            String url = QMUILinkify.makeUrl(m.group(0), new String[]{prefix}, m, transformFilter);
            QMUILinkify.applyLink(url, start, end, s, null, null, null);
            hasMatches = true;
        }
        return hasMatches;
    }

    private static void applyLink(String url, int start, int end, Spannable text, final ColorStateList linkColor, final ColorStateList bgColor, QMUIOnSpanClickListener l) {
        text.setSpan((Object)new StyleableURLSpan(url, l){

            public void updateDrawState(TextPaint ds) {
                if (linkColor != null) {
                    int normalLinkColor = linkColor.getColorForState(new int[]{16842910, -16842919}, 0);
                    int pressedLinkColor = linkColor.getColorForState(new int[]{16842919}, normalLinkColor);
                    int n = ds.linkColor = this.mPressed ? pressedLinkColor : normalLinkColor;
                }
                if (bgColor != null) {
                    int normalBgColor = bgColor.getColorForState(new int[]{16842910, -16842919}, 0);
                    int pressedBgColor = bgColor.getColorForState(new int[]{16842919}, normalBgColor);
                    ds.bgColor = this.mPressed ? pressedBgColor : normalBgColor;
                }
                super.updateDrawState(ds);
                ds.setUnderlineText(false);
            }
        }, start, end, 33);
    }

    private static String makeUrl(String url, String[] prefixes, Matcher m, TransformFilter filter) {
        if (filter != null) {
            url = filter.transformUrl(m, url);
        }
        boolean hasPrefix = false;
        for (String prefixe : prefixes) {
            if (!url.regionMatches(true, 0, prefixe, 0, prefixe.length())) continue;
            hasPrefix = true;
            if (url.regionMatches(false, 0, prefixe, 0, prefixe.length())) break;
            url = prefixe + url.substring(prefixe.length());
            break;
        }
        if (!hasPrefix) {
            url = prefixes[0] + url;
        }
        return url;
    }

    private static void gatherLinks(ArrayList<LinkSpec> links, Spannable s, Pattern pattern, String[] schemes, MatchFilter matchFilter, TransformFilter transformFilter) {
        Matcher m = pattern.matcher((CharSequence)s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            if (matchFilter != null && !matchFilter.acceptMatch((CharSequence)s, start, end)) continue;
            LinkSpec spec = new LinkSpec();
            spec.url = QMUILinkify.makeUrl(m.group(0), schemes, m, transformFilter);
            spec.start = start;
            spec.end = end;
            links.add(spec);
        }
    }

    private static void gatherPhoneLinks(ArrayList<LinkSpec> links, Spannable s, Pattern pattern, Pattern[] excepts, String[] schemes, MatchFilter matchFilter, TransformFilter transformFilter) {
        Matcher m = pattern.matcher((CharSequence)s);
        while (m.find()) {
            if (QMUILinkify.isInExcepts(m.group(), excepts)) continue;
            int start = m.start();
            int end = m.end();
            if (matchFilter != null && !matchFilter.acceptMatch((CharSequence)s, start, end)) continue;
            LinkSpec spec = new LinkSpec();
            spec.url = QMUILinkify.makeUrl(m.group(0), schemes, m, transformFilter);
            spec.start = start;
            spec.end = end;
            links.add(spec);
        }
    }

    private static boolean isInExcepts(CharSequence data, Pattern[] excepts) {
        for (Pattern except : excepts) {
            Matcher m = except.matcher(data);
            if (!m.find()) continue;
            return true;
        }
        return QMUILinkify.isTooLarge(data);
    }

    private static boolean isTooLarge(CharSequence data) {
        if (data.length() <= 21) {
            return false;
        }
        int count = data.length();
        int digitCount = 0;
        for (int i = 0; i < count; ++i) {
            if (!Character.isDigit(data.charAt(i)) || ++digitCount <= 21) continue;
            return true;
        }
        return false;
    }

    private static void gatherMapLinks(ArrayList<LinkSpec> links, Spannable s) {
        String string = s.toString();
        int base = 0;
        try {
            int start;
            String address;
            while ((address = WebView.findAddress((String)string)) != null && (start = string.indexOf(address)) >= 0) {
                String encodedAddress;
                LinkSpec spec = new LinkSpec();
                int length = address.length();
                int end = start + length;
                spec.start = base + start;
                spec.end = base + end;
                string = string.substring(end);
                base += end;
                try {
                    encodedAddress = URLEncoder.encode(address, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    continue;
                }
                spec.url = "geo:0,0?q=" + encodedAddress;
                links.add(spec);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static void pruneOverlaps(ArrayList<LinkSpec> links) {
        Comparator<LinkSpec> c = new Comparator<LinkSpec>(){

            @Override
            public final int compare(LinkSpec a, LinkSpec b) {
                if (a.start < b.start) {
                    return -1;
                }
                if (a.start > b.start) {
                    return 1;
                }
                if (a.end < b.end) {
                    return 1;
                }
                if (a.end > b.end) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(links, c);
        int len = links.size();
        int i = 0;
        while (i < len - 1) {
            LinkSpec a = links.get(i);
            LinkSpec b = links.get(i + 1);
            int remove = -1;
            if (a.start <= b.start && a.end > b.start) {
                if (b.end <= a.end) {
                    remove = i + 1;
                } else if (a.end - a.start > b.end - b.start) {
                    remove = i + 1;
                } else if (a.end - a.start < b.end - b.start) {
                    remove = i;
                }
                if (remove != -1) {
                    links.remove(remove);
                    --len;
                    continue;
                }
            }
            ++i;
        }
    }

    private static class LinkSpec {
        String url;
        int start;
        int end;

        private LinkSpec() {
        }
    }

    private static abstract class StyleableURLSpan
    extends URLSpan
    implements ITouchableSpan {
        protected boolean mPressed = false;
        protected String mUrl;
        protected QMUIOnSpanClickListener mOnSpanClickListener;

        public StyleableURLSpan(String url, QMUIOnSpanClickListener l) {
            super(url);
            this.mUrl = url;
            this.mOnSpanClickListener = l;
        }

        @Override
        public void setPressed(boolean pressed) {
            this.mPressed = pressed;
        }

        @Override
        public void onClick(View widget) {
            if (this.mOnSpanClickListener.onSpanClick(this.mUrl)) {
                return;
            }
            super.onClick(widget);
        }
    }

    public static interface TransformFilter {
        public String transformUrl(Matcher var1, String var2);
    }

    public static interface MatchFilter {
        public boolean acceptMatch(CharSequence var1, int var2, int var3);
    }
}

