/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.qqface;

import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.util.LruCache;
import com.qmuiteam.qmui.qqface.IQMUIQQFaceManager;
import com.qmuiteam.qmui.span.QMUITouchableSpan;
import com.qmuiteam.qmui.util.QMUILangHelper;
import java.util.ArrayList;
import java.util.List;

public class QMUIQQFaceCompiler {
    private static final int SPAN_COLUMN = 2;
    private static volatile QMUIQQFaceCompiler sInstance;
    private LruCache<CharSequence, ElementList> mCache = new LruCache(30);
    private IQMUIQQFaceManager mQQFaceManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QMUIQQFaceCompiler getInstance(IQMUIQQFaceManager manager) {
        if (sInstance != null) return sInstance;
        Class<QMUIQQFaceCompiler> clazz = QMUIQQFaceCompiler.class;
        synchronized (QMUIQQFaceCompiler.class) {
            if (sInstance != null) return sInstance;
            sInstance = new QMUIQQFaceCompiler(manager);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private QMUIQQFaceCompiler(IQMUIQQFaceManager manager) {
        this.mQQFaceManager = manager;
    }

    public int getSpecialBoundsMaxHeight() {
        return this.mQQFaceManager.getSpecialDrawableMaxHeight();
    }

    public ElementList compile(CharSequence text) {
        if (QMUILangHelper.isNullOrEmpty(text)) {
            return null;
        }
        return this.compile(text, 0, text.length());
    }

    public ElementList compile(CharSequence text, int start, int end) {
        return this.compile(text, start, end, false);
    }

    private ElementList compile(CharSequence text, int start, int end, boolean inSpan) {
        if (QMUILangHelper.isNullOrEmpty(text)) {
            return null;
        }
        if (start < 0 || start >= text.length()) {
            throw new IllegalArgumentException("start must >= 0 and < text.length");
        }
        if (end <= start) {
            throw new IllegalArgumentException("end must > start");
        }
        int size = text.length();
        if (end > size) {
            end = size;
        }
        boolean hasClickableSpans = false;
        QMUITouchableSpan[] spans = null;
        int[] spanInfo = null;
        if (!inSpan && text instanceof Spannable) {
            spans = (QMUITouchableSpan[])((Spannable)text).getSpans(0, text.length() - 1, QMUITouchableSpan.class);
            boolean bl = hasClickableSpans = spans.length > 0;
            if (hasClickableSpans) {
                spanInfo = new int[spans.length * 2];
                for (int i = 0; i < spans.length; ++i) {
                    spanInfo[i * 2] = ((Spannable)text).getSpanStart((Object)spans[i]);
                    spanInfo[i * 2 + 1] = ((Spannable)text).getSpanEnd((Object)spans[i]);
                }
            }
        }
        ElementList elementList = (ElementList)this.mCache.get((Object)text);
        if (!hasClickableSpans && elementList != null && start == elementList.getStart() && end == elementList.getEnd()) {
            return elementList;
        }
        elementList = this.realCompile(text, start, end, spans, spanInfo);
        this.mCache.put((Object)text, (Object)elementList);
        return elementList;
    }

    public void setCache(LruCache<CharSequence, ElementList> cache) {
        this.mCache = cache;
    }

    private ElementList realCompile(CharSequence text, int start, int end, QMUITouchableSpan[] spans, int[] spanInfo) {
        int nearSpanStart;
        int size = text.length();
        int nearSpanIndex = -1;
        int nearSpanEnd = nearSpanStart = Integer.MAX_VALUE;
        if (spans != null && spans.length > 0) {
            nearSpanIndex = 0;
            nearSpanStart = spanInfo[0];
            nearSpanEnd = spanInfo[1];
        }
        ElementList elementList = new ElementList(start, end);
        if (start > 0) {
            elementList.add(Element.createTextElement(text.subSequence(0, start)));
        }
        int index = start;
        int last = start;
        boolean inParentheses = false;
        while (index < end) {
            if (index == nearSpanStart) {
                if (index - last > 0) {
                    if (inParentheses) {
                        inParentheses = false;
                        --last;
                    }
                    elementList.add(Element.createTextElement(text.subSequence(last, index)));
                }
                elementList.add(Element.createTouchSpanElement(text.subSequence(nearSpanStart, nearSpanEnd), spans[nearSpanIndex], this));
                index = last = nearSpanEnd;
                if (++nearSpanIndex >= spans.length) {
                    nearSpanEnd = Integer.MAX_VALUE;
                    nearSpanStart = Integer.MAX_VALUE;
                    continue;
                }
                nearSpanStart = spanInfo[nearSpanIndex * 2];
                nearSpanEnd = spanInfo[nearSpanIndex * 2 + 1];
                continue;
            }
            char c = text.charAt(index);
            if (c == '[') {
                if (index - last > 0) {
                    elementList.add(Element.createTextElement(text.subSequence(last, index)));
                }
                inParentheses = true;
                last = index++;
                continue;
            }
            if (c == ']' && inParentheses) {
                inParentheses = false;
                if (++index - last <= 0) continue;
                String label = text.subSequence(last, index).toString();
                Drawable specialDrawable = this.mQQFaceManager.getSpecialBoundsDrawable(label);
                if (specialDrawable != null) {
                    elementList.add(Element.createSpeaicalBoundsDrawableElement(specialDrawable));
                    last = index;
                    continue;
                }
                int res = this.mQQFaceManager.getQQfaceResource(label);
                if (res == 0) continue;
                elementList.add(Element.createDrawableElement(res));
                last = index;
                continue;
            }
            if (c == '\n') {
                if (inParentheses) {
                    inParentheses = false;
                }
                if (index - last > 0) {
                    elementList.add(Element.createTextElement(text.subSequence(last, index)));
                }
                elementList.add(Element.createNextLineElement());
                last = ++index;
                continue;
            }
            if (inParentheses) {
                if (index - last > 8) {
                    inParentheses = false;
                } else {
                    ++index;
                    continue;
                }
            }
            int skip = 0;
            int icon = 0;
            if (this.mQQFaceManager.maybeSoftBankEmoji(c)) {
                icon = this.mQQFaceManager.getSoftbankEmojiResource(c);
                int n = skip = icon == 0 ? 0 : 1;
            }
            if (icon == 0) {
                int nextUnicode;
                int unicode = Character.codePointAt(text, index);
                skip = Character.charCount(unicode);
                if (this.mQQFaceManager.maybeEmoji(unicode)) {
                    icon = this.mQQFaceManager.getEmojiResource(unicode);
                }
                if (icon == 0 && start + skip < end && (icon = this.mQQFaceManager.getDoubleUnicodeEmoji(unicode, nextUnicode = Character.codePointAt(text, start + skip))) != 0) {
                    skip += Character.charCount(nextUnicode);
                }
            }
            if (icon != 0) {
                if (last != index) {
                    elementList.add(Element.createTextElement(text.subSequence(last, index)));
                }
                elementList.add(Element.createDrawableElement(icon));
                last = index += skip;
                continue;
            }
            ++index;
        }
        if (last < end) {
            elementList.add(Element.createTextElement(text.subSequence(last, size)));
        }
        return elementList;
    }

    public static class ElementList {
        private int mStart;
        private int mEnd;
        private int mQQFaceCount = 0;
        private int mNewLineCount = 0;
        private List<Element> mElements;

        public ElementList(int start, int end) {
            this.mStart = start;
            this.mEnd = end;
            this.mElements = new ArrayList<Element>();
        }

        public int getStart() {
            return this.mStart;
        }

        public int getEnd() {
            return this.mEnd;
        }

        public int getNewLineCount() {
            return this.mNewLineCount;
        }

        public int getQQFaceCount() {
            return this.mQQFaceCount;
        }

        public void add(Element element) {
            if (element.getType() == ElementType.DRAWABLE) {
                ++this.mQQFaceCount;
            } else if (element.getType() == ElementType.NEXTLINE) {
                ++this.mNewLineCount;
            } else if (element.getType() == ElementType.SPAN) {
                this.mQQFaceCount += element.getChildList().getQQFaceCount();
                this.mNewLineCount += element.getChildList().getNewLineCount();
            }
            this.mElements.add(element);
        }

        public List<Element> getElements() {
            return this.mElements;
        }
    }

    public static class Element {
        private ElementType mType;
        private CharSequence mText;
        private int mDrawableRes;
        private Drawable mSpecialBoundsDrawable;
        private ElementList mChildList;
        private QMUITouchableSpan mTouchableSpan;

        public ElementType getType() {
            return this.mType;
        }

        public CharSequence getText() {
            return this.mText;
        }

        public int getDrawableRes() {
            return this.mDrawableRes;
        }

        public ElementList getChildList() {
            return this.mChildList;
        }

        public QMUITouchableSpan getTouchableSpan() {
            return this.mTouchableSpan;
        }

        public Drawable getSpecialBoundsDrawable() {
            return this.mSpecialBoundsDrawable;
        }

        public static Element createTextElement(CharSequence text) {
            Element element = new Element();
            element.mType = ElementType.TEXT;
            element.mText = text;
            return element;
        }

        public static Element createDrawableElement(int drawableRes) {
            Element element = new Element();
            element.mType = ElementType.DRAWABLE;
            element.mDrawableRes = drawableRes;
            return element;
        }

        public static Element createSpeaicalBoundsDrawableElement(Drawable specialBoundsDrawable) {
            Element element = new Element();
            element.mType = ElementType.SPECIAL_BOUNDS_DRAWABLE;
            element.mSpecialBoundsDrawable = specialBoundsDrawable;
            return element;
        }

        public static Element createTouchSpanElement(CharSequence text, QMUITouchableSpan touchableSpan, QMUIQQFaceCompiler compiler) {
            Element element = new Element();
            element.mType = ElementType.SPAN;
            element.mChildList = compiler.compile(text, 0, text.length(), true);
            element.mTouchableSpan = touchableSpan;
            return element;
        }

        public static Element createNextLineElement() {
            Element element = new Element();
            element.mType = ElementType.NEXTLINE;
            return element;
        }
    }

    public static enum ElementType {
        TEXT,
        DRAWABLE,
        SPECIAL_BOUNDS_DRAWABLE,
        SPAN,
        NEXTLINE;

    }
}

