/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.text.style.ReplacementSpan;

public class QMUITextSizeSpan
extends ReplacementSpan {
    private int mTextSize;
    private int mVerticalOffset;
    private Paint mPaint;

    public QMUITextSizeSpan(int textSize, int verticalOffset) {
        this.mTextSize = textSize;
        this.mVerticalOffset = verticalOffset;
    }

    public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        this.mPaint = new Paint(paint);
        this.mPaint.setTextSize((float)this.mTextSize);
        if ((float)this.mTextSize > paint.getTextSize() && fm != null) {
            Paint.FontMetricsInt newFm = this.mPaint.getFontMetricsInt();
            fm.descent = newFm.descent;
            fm.ascent = newFm.ascent;
            fm.top = newFm.top;
            fm.bottom = newFm.bottom;
        }
        return (int)this.mPaint.measureText(text, start, end);
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        int baseline = y + this.mVerticalOffset;
        canvas.drawText(text, start, end, x, (float)baseline, this.mPaint);
    }
}

