/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.qmuiteam.qmui.util.QMUIActivityLifecycleCallbacks;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;

public class QMUIKeyboardHelper {
    public static final int SHOW_KEYBOARD_DELAY_TIME = 200;
    private static final String TAG = "QMUIKeyboardHelper";
    public static final int KEYBOARD_VISIBLE_THRESHOLD_DP = 100;

    public static void showKeyboard(EditText editText, boolean delay) {
        QMUIKeyboardHelper.showKeyboard(editText, delay ? 200 : 0);
    }

    public static void showKeyboard(final EditText editText, int delay) {
        if (null == editText) {
            return;
        }
        if (!editText.requestFocus()) {
            Log.w((String)TAG, (String)"showSoftInput() can not get focus");
            return;
        }
        if (delay > 0) {
            editText.postDelayed(new Runnable(){

                @Override
                public void run() {
                    InputMethodManager imm = (InputMethodManager)editText.getContext().getApplicationContext().getSystemService("input_method");
                    imm.showSoftInput((View)editText, 1);
                }
            }, (long)delay);
        } else {
            InputMethodManager imm = (InputMethodManager)editText.getContext().getApplicationContext().getSystemService("input_method");
            imm.showSoftInput((View)editText, 1);
        }
    }

    public static boolean hideKeyboard(View view) {
        if (null == view) {
            return false;
        }
        InputMethodManager inputManager = (InputMethodManager)view.getContext().getApplicationContext().getSystemService("input_method");
        return inputManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
    }

    public static void setVisibilityEventListener(final Activity activity, final KeyboardVisibilityEventListener listener) {
        if (activity == null) {
            throw new NullPointerException("Parameter:activity must not be null");
        }
        if (listener == null) {
            throw new NullPointerException("Parameter:listener must not be null");
        }
        final View activityRoot = QMUIViewHelper.getActivityRoot(activity);
        final ViewTreeObserver.OnGlobalLayoutListener layoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){
            private final Rect r = new Rect();
            private final int visibleThreshold = Math.round(QMUIDisplayHelper.dp2px((Context)activity, 100));
            private boolean wasOpened = false;

            public void onGlobalLayout() {
                boolean isOpen;
                activityRoot.getWindowVisibleDisplayFrame(this.r);
                int heightDiff = activityRoot.getRootView().getHeight() - this.r.height();
                boolean bl = isOpen = heightDiff > this.visibleThreshold;
                if (isOpen == this.wasOpened) {
                    return;
                }
                this.wasOpened = isOpen;
                boolean removeListener = listener.onVisibilityChanged(isOpen, heightDiff);
                if (removeListener) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        activityRoot.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        activityRoot.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
        };
        activityRoot.getViewTreeObserver().addOnGlobalLayoutListener(layoutListener);
        activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new QMUIActivityLifecycleCallbacks(activity){

            @Override
            protected void onTargetActivityDestroyed() {
                if (Build.VERSION.SDK_INT >= 16) {
                    activityRoot.getViewTreeObserver().removeOnGlobalLayoutListener(layoutListener);
                } else {
                    activityRoot.getViewTreeObserver().removeGlobalOnLayoutListener(layoutListener);
                }
            }
        });
    }

    public static boolean isKeyboardVisible(Activity activity) {
        Rect r = new Rect();
        View activityRoot = QMUIViewHelper.getActivityRoot(activity);
        int visibleThreshold = Math.round(QMUIDisplayHelper.dp2px((Context)activity, 100));
        activityRoot.getWindowVisibleDisplayFrame(r);
        int heightDiff = activityRoot.getRootView().getHeight() - r.height();
        return heightDiff > visibleThreshold;
    }

    public static interface KeyboardVisibilityEventListener {
        public boolean onVisibilityChanged(boolean var1, int var2);
    }
}

