/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIDrawableHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;

public class QMUIResHelper {
    public static float getAttrFloatValue(Context context, int attrRes) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrRes, typedValue, true);
        return typedValue.getFloat();
    }

    public static int getAttrColor(Context context, int attrRes) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrRes, typedValue, true);
        return typedValue.data;
    }

    public static ColorStateList getAttrColorStateList(Context context, int attrRes) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrRes, typedValue, true);
        return ContextCompat.getColorStateList((Context)context, (int)typedValue.resourceId);
    }

    public static Drawable getAttrDrawable(Context context, int attrRes) {
        int[] attrs = new int[]{attrRes};
        TypedArray ta = context.obtainStyledAttributes(attrs);
        Drawable drawable = QMUIResHelper.getAttrDrawable(context, ta, 0);
        ta.recycle();
        return drawable;
    }

    public static Drawable getAttrDrawable(Context context, TypedArray typedArray, int index) {
        TypedValue value = typedArray.peekValue(index);
        if (value != null && value.type != 2 && value.resourceId != 0) {
            return QMUIDrawableHelper.getVectorDrawable(context, value.resourceId);
        }
        return null;
    }

    public static int getAttrDimen(Context context, int attrRes) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrRes, typedValue, true);
        return TypedValue.complexToDimensionPixelSize((int)typedValue.data, (DisplayMetrics)QMUIDisplayHelper.getDisplayMetrics(context));
    }

    public static void assignTextViewWithAttr(TextView textView, int attrRes) {
        TypedArray a = textView.getContext().obtainStyledAttributes(null, R.styleable.QMUITextCommonStyleDef, attrRes, 0);
        int count = a.getIndexCount();
        int paddingLeft = textView.getPaddingLeft();
        int paddingRight = textView.getPaddingRight();
        int paddingTop = textView.getPaddingTop();
        int paddingBottom = textView.getPaddingBottom();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_gravity) {
                textView.setGravity(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_textColor) {
                textView.setTextColor(a.getColorStateList(attr2));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_textSize) {
                textView.setTextSize(0, (float)a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_paddingLeft) {
                paddingLeft = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_paddingRight) {
                paddingRight = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_paddingTop) {
                paddingTop = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_paddingBottom) {
                paddingBottom = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_singleLine) {
                textView.setSingleLine(a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_ellipsize) {
                int ellipsize = a.getInt(attr2, 3);
                switch (ellipsize) {
                    case 1: {
                        textView.setEllipsize(TextUtils.TruncateAt.START);
                        break;
                    }
                    case 2: {
                        textView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                        break;
                    }
                    case 3: {
                        textView.setEllipsize(TextUtils.TruncateAt.END);
                        break;
                    }
                    case 4: {
                        textView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
                    }
                }
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_maxLines) {
                textView.setMaxLines(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_background) {
                QMUIViewHelper.setBackgroundKeepingPadding((View)textView, a.getDrawable(attr2));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_lineSpacingExtra) {
                textView.setLineSpacing((float)a.getDimensionPixelSize(attr2, 0), 1.0f);
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_drawablePadding) {
                textView.setCompoundDrawablePadding(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_textColorHint) {
                textView.setHintTextColor(a.getColor(attr2, 0));
                continue;
            }
            if (attr2 != R.styleable.QMUITextCommonStyleDef_android_textStyle) continue;
            int styleIndex = a.getInt(attr2, -1);
            textView.setTypeface(null, styleIndex);
        }
        textView.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        a.recycle();
    }
}

