/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.os.SystemClock;
import android.support.v4.util.LongSparseArray;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QMUIAnimationListView
extends ListView {
    private static final String TAG = "QMUIAnimationListView";
    private static final long DURATION_ALPHA = 300L;
    private static final long DURATION_OFFSET_MIN = 0L;
    private static final long DURATION_OFFSET_MAX = 1000L;
    private static final float DEFAULT_OFFSET_DURATION_UNIT = 0.5f;
    protected final LongSparseArray<Integer> mTopMap = new LongSparseArray();
    protected final LongSparseArray<Integer> mPositionMap = new LongSparseArray();
    protected final LongSparseArray<View> mDetachViewsMap = new LongSparseArray();
    protected final Set<Long> mBeforeVisible = new HashSet<Long>();
    protected final Set<Long> mAfterVisible = new HashSet<Long>();
    private final List<Manipulator> mPendingManipulations = new ArrayList<Manipulator>();
    private final List<Manipulator> mPendingManipulationsWithoutAnimation = new ArrayList<Manipulator>();
    private long mChangeDisappearPlayTime = 0L;
    private ValueAnimator mChangeDisappearAnimator;
    private ListAdapter mRealAdapter;
    private WrapperAdapter mWrapperAdapter;
    private boolean mIsAnimating = false;
    private int mAnimationManipulateDurationLimit = 0;
    private long mLastManipulateTime = 0L;
    private float mOffsetDurationUnit = 0.5f;
    private Interpolator mOffsetInterpolator = new LinearInterpolator();
    private boolean mOpenChangeDisappearAnimation = false;

    public QMUIAnimationListView(Context context) {
        this(context, null);
    }

    public QMUIAnimationListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public QMUIAnimationListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public QMUIAnimationListView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
    }

    public ListAdapter getRealAdapter() {
        return this.mRealAdapter;
    }

    public void setAdapter(ListAdapter adapter) {
        this.mRealAdapter = adapter;
        this.mWrapperAdapter = new WrapperAdapter(this.mRealAdapter);
        super.setAdapter((ListAdapter)this.mWrapperAdapter);
    }

    public void setAnimationManipulateDurationLimit(int animationManipulateDurationLimit) {
        this.mAnimationManipulateDurationLimit = animationManipulateDurationLimit;
    }

    public <T extends ListAdapter> void manipulate(Manipulator<T> manipulator) {
        Log.i((String)TAG, (String)"manipulate");
        if (!this.mWrapperAdapter.isAnimationEnabled()) {
            this.manipulateWithoutAnimation(manipulator);
            return;
        }
        long now = SystemClock.uptimeMillis();
        boolean notLimitedAnimation = now - this.mLastManipulateTime > (long)this.mAnimationManipulateDurationLimit;
        this.mLastManipulateTime = now;
        if (!this.mIsAnimating) {
            if (notLimitedAnimation) {
                this.mIsAnimating = true;
                this.prepareAnimation();
                manipulator.manipulate(this.mRealAdapter);
                this.doAnimation();
            } else {
                manipulator.manipulate(this.mRealAdapter);
                this.mWrapperAdapter.notifyDataSetChanged();
            }
        } else if (notLimitedAnimation) {
            this.mPendingManipulations.add(manipulator);
        } else {
            this.mPendingManipulationsWithoutAnimation.add(manipulator);
        }
    }

    public <T extends ListAdapter> void manipulateWithoutAnimation(Manipulator<T> manipulator) {
        Log.i((String)TAG, (String)"manipulateWithoutAnimation");
        if (!this.mIsAnimating) {
            manipulator.manipulate(this.mRealAdapter);
            this.mWrapperAdapter.notifyDataSetChanged();
        } else {
            this.mPendingManipulationsWithoutAnimation.add(manipulator);
        }
    }

    public float getOffsetDurationUnit() {
        return this.mOffsetDurationUnit;
    }

    public void setOffsetDurationUnit(float offsetDurationUnit) {
        this.mOffsetDurationUnit = offsetDurationUnit;
    }

    private long getOffsetDuration(int start, int end) {
        long duration = (long)((float)Math.abs(start - end) * this.mOffsetDurationUnit);
        return Math.max(0L, Math.min(duration, 1000L));
    }

    public void setOpenChangeDisappearAnimation(boolean openChangeDisappearAnimation) {
        this.mOpenChangeDisappearAnimation = openChangeDisappearAnimation;
    }

    public void setOffsetInterpolator(Interpolator offsetInterpolator) {
        this.mOffsetInterpolator = offsetInterpolator;
    }

    private void prepareAnimation() {
        long id;
        int i;
        this.mTopMap.clear();
        this.mPositionMap.clear();
        this.mBeforeVisible.clear();
        this.mAfterVisible.clear();
        this.mDetachViewsMap.clear();
        this.mWrapperAdapter.setShouldNotifyChange(false);
        int childCount = this.getChildCount();
        int firstVisiblePos = this.getFirstVisiblePosition();
        for (i = 0; i < childCount; ++i) {
            View view = this.getChildAt(i);
            id = this.mWrapperAdapter.getItemId(firstVisiblePos + i);
            this.mTopMap.put(id, (Object)view.getTop());
            this.mPositionMap.put(id, (Object)i);
        }
        for (i = 0; i < firstVisiblePos; ++i) {
            long id2 = this.mWrapperAdapter.getItemId(i);
            this.mBeforeVisible.add(id2);
        }
        int count = this.mWrapperAdapter.getCount();
        for (int i2 = firstVisiblePos + childCount; i2 < count; ++i2) {
            id = this.mWrapperAdapter.getItemId(i2);
            this.mAfterVisible.add(id);
        }
    }

    private void doAnimation() {
        this.setEnabled(false);
        this.setClickable(false);
        this.doPreLayoutAnimation(new ManipulateAnimatorListener(){

            public void onAnimationEnd(Animator animation) {
                QMUIAnimationListView.this.mWrapperAdapter.notifyDataSetChanged();
                QMUIAnimationListView.this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        QMUIAnimationListView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        QMUIAnimationListView.this.doPostLayoutAnimation();
                        return true;
                    }
                });
            }
        });
    }

    private void doPreLayoutAnimation(Animator.AnimatorListener listener) {
        int i;
        AnimatorSet animatorSet = new AnimatorSet();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (i = 0; i < this.mTopMap.size(); ++i) {
            long id = this.mTopMap.keyAt(i);
            int newPos = this.getPositionForId(id);
            if (newPos >= 0) continue;
            int oldPos = (Integer)this.mPositionMap.get(id);
            View child = this.getChildAt(oldPos);
            Animator anim = this.getDeleteAnimator(child);
            this.mPositionMap.remove(id);
            animatorSet.play(anim);
            deleteIds.add(id);
        }
        for (i = 0; i < deleteIds.size(); ++i) {
            this.mTopMap.remove(((Long)deleteIds.get(i)).longValue());
        }
        if (this.mOpenChangeDisappearAnimation) {
            for (i = 0; i < this.mPositionMap.size(); ++i) {
                View view = this.getChildAt((Integer)this.mPositionMap.valueAt(i));
                ViewCompat.setHasTransientState((View)view, (boolean)true);
                this.mDetachViewsMap.put(this.mPositionMap.keyAt(i), (Object)view);
            }
        }
        if (!animatorSet.getChildAnimations().isEmpty()) {
            animatorSet.addListener(listener);
            animatorSet.start();
        } else {
            listener.onAnimationEnd((Animator)animatorSet);
        }
    }

    private void doPostLayoutAnimation() {
        int i;
        AnimatorSet animatorSet = new AnimatorSet();
        int childCount = this.getChildCount();
        int firstVisiblePos = this.getFirstVisiblePosition();
        Animator anim = null;
        int addOccurTop = -1;
        int addOccurPosition = -1;
        if (this.mOpenChangeDisappearAnimation) {
            for (i = 0; i < this.mDetachViewsMap.size(); ++i) {
                ViewCompat.setHasTransientState((View)((View)this.mDetachViewsMap.valueAt(i)), (boolean)false);
            }
        }
        for (i = 0; i < childCount; ++i) {
            int oldTop;
            View child = this.getChildAt(i);
            child.setAlpha(1.0f);
            int newTop = child.getTop();
            int position = firstVisiblePos + i;
            long id = this.mWrapperAdapter.getItemId(position);
            if (this.mTopMap.indexOfKey(id) > -1) {
                addOccurTop = -1;
                oldTop = (Integer)this.mTopMap.get(id);
                this.mTopMap.remove(id);
                this.mPositionMap.remove(id);
                if (this.mOpenChangeDisappearAnimation) {
                    this.mDetachViewsMap.remove(id);
                }
                if (oldTop != newTop) {
                    anim = this.getOffsetAnimator(child, oldTop, newTop);
                }
            } else if (this.mBeforeVisible.contains(id)) {
                addOccurTop = -1;
                oldTop = -child.getHeight();
                anim = this.getOffsetAnimator(child, oldTop, newTop);
            } else if (this.mAfterVisible.contains(id)) {
                addOccurTop = -1;
                oldTop = this.getHeight();
                anim = this.getOffsetAnimator(child, oldTop, newTop);
            } else {
                if (addOccurTop == -1) {
                    addOccurTop = newTop;
                    addOccurPosition = position;
                }
                anim = this.getAddAnimator(child, newTop, position, addOccurTop, addOccurPosition);
            }
            if (anim == null) continue;
            animatorSet.play(anim);
        }
        if (this.mOpenChangeDisappearAnimation && this.mDetachViewsMap.size() > 0) {
            this.mChangeDisappearAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mChangeDisappearAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    QMUIAnimationListView.this.mChangeDisappearPlayTime = animation.getCurrentPlayTime();
                    QMUIAnimationListView.this.invalidate();
                }
            });
            this.mChangeDisappearAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    QMUIAnimationListView.this.mChangeDisappearPlayTime = 0L;
                }
            });
            this.mChangeDisappearAnimator.setDuration(this.getChangeDisappearDuration());
            this.mChangeDisappearAnimator.start();
        }
        animatorSet.addListener((Animator.AnimatorListener)new ManipulateAnimatorListener(){

            public void onAnimationEnd(Animator animation) {
                QMUIAnimationListView.this.finishAnimation();
            }
        });
        animatorSet.start();
    }

    protected long getChangeDisappearDuration() {
        return (long)((float)this.getHeight() * this.mOffsetDurationUnit);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mOpenChangeDisappearAnimation && this.mChangeDisappearAnimator != null && this.mChangeDisappearAnimator.isStarted() && this.mDetachViewsMap.size() > 0 && this.mIsAnimating) {
            for (int i = 0; i < this.mDetachViewsMap.size(); ++i) {
                int top;
                long id = this.mDetachViewsMap.keyAt(i);
                View view = (View)this.mDetachViewsMap.valueAt(i);
                int newPos = this.getPositionForId(id);
                int offset = (int)((float)this.mChangeDisappearPlayTime / this.mOffsetDurationUnit);
                if (newPos < this.getFirstVisiblePosition() ? (top = (Integer)this.mTopMap.get(id) - offset) < -view.getHeight() : (top = (Integer)this.mTopMap.get(id) + offset) > this.getHeight()) continue;
                view.layout(0, top, view.getWidth(), top + view.getHeight());
                view.setAlpha(1.0f - (float)this.mChangeDisappearPlayTime * 1.0f / (float)this.getChangeDisappearDuration());
                this.drawChild(canvas, view, this.getDrawingTime());
            }
        }
    }

    private void finishAnimation() {
        this.mWrapperAdapter.setShouldNotifyChange(true);
        this.mChangeDisappearAnimator = null;
        if (this.mOpenChangeDisappearAnimation) {
            for (int i = 0; i < this.mDetachViewsMap.size(); ++i) {
                ((View)this.mDetachViewsMap.valueAt(i)).setAlpha(1.0f);
            }
            this.mDetachViewsMap.clear();
        }
        this.mIsAnimating = false;
        this.setEnabled(true);
        this.setClickable(true);
        this.manipulatePending();
    }

    private void manipulatePending() {
        if (!this.mPendingManipulationsWithoutAnimation.isEmpty()) {
            this.mIsAnimating = true;
            for (Manipulator manipulator : this.mPendingManipulationsWithoutAnimation) {
                manipulator.manipulate(this.mRealAdapter);
            }
            this.mPendingManipulationsWithoutAnimation.clear();
            this.mWrapperAdapter.notifyDataSetChanged();
            this.post(new Runnable(){

                @Override
                public void run() {
                    QMUIAnimationListView.this.mIsAnimating = false;
                    QMUIAnimationListView.this.manipulatePending();
                }
            });
        } else {
            if (this.mPendingManipulations.isEmpty()) {
                return;
            }
            this.mIsAnimating = true;
            this.prepareAnimation();
            for (Manipulator manipulator : this.mPendingManipulations) {
                manipulator.manipulate(this.mRealAdapter);
            }
            this.mPendingManipulations.clear();
            this.doAnimation();
        }
    }

    protected Animator getDeleteAnimator(View view) {
        return this.alphaObjectAnimator(view, false, 300L, true);
    }

    protected Animator getOffsetAnimator(View view, int oldTop, int newTop) {
        return this.getOffsetAnimator(view, oldTop, newTop, this.getOffsetDuration(oldTop, newTop));
    }

    protected Animator getOffsetAnimator(View view, int oldTop, int newTop, long duration) {
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{oldTop - newTop, 0.0f});
        anim.setDuration(duration);
        anim.setInterpolator((TimeInterpolator)this.mOffsetInterpolator);
        return anim;
    }

    protected Animator getAddAnimator(View view, int top, int position, int addOccurTop, int addOccurPosition) {
        view.setAlpha(0.0f);
        view.clearAnimation();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)this.alphaObjectAnimator(view, true, 50L, false));
        if (addOccurTop != top) {
            animatorSet.play(this.getOffsetAnimator(view, addOccurTop, top));
        }
        animatorSet.setStartDelay((long)((float)view.getHeight() * this.mOffsetDurationUnit));
        return animatorSet;
    }

    protected ObjectAnimator alphaObjectAnimator(View view, final boolean fadeIn, long duration, boolean postBack) {
        float[] fArray;
        if (fadeIn) {
            float[] fArray2 = new float[2];
            fArray2[0] = 0.0f;
            fArray = fArray2;
            fArray2[1] = 1.0f;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = 1.0f;
            fArray = fArray3;
            fArray3[1] = 0.0f;
        }
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])fArray);
        anim.setDuration(duration);
        if (postBack) {
            final WeakReference<View> wr = new WeakReference<View>(view);
            anim.addListener((Animator.AnimatorListener)new ManipulateAnimatorListener(){

                public void onAnimationEnd(Animator animation) {
                    if (wr.get() != null) {
                        ((View)wr.get()).setAlpha(fadeIn ? 0.0f : 1.0f);
                    }
                }
            });
        }
        return anim;
    }

    protected int getPositionForId(long id) {
        for (int i = 0; i < this.mWrapperAdapter.getCount(); ++i) {
            if (this.mWrapperAdapter.getItemId(i) != id) continue;
            return i;
        }
        return -1;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        return this.isEnabled() && super.dispatchTouchEvent(ev);
    }

    private abstract class ManipulateAnimatorListener
    implements Animator.AnimatorListener {
        private ManipulateAnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    private static class WrapperAdapter
    extends BaseAdapter {
        private ListAdapter mAdapter;
        private boolean mShouldNotifyChange = true;
        private final DataSetObserver mObserver = new DataSetObserver(){

            public void onChanged() {
                if (WrapperAdapter.this.mShouldNotifyChange) {
                    WrapperAdapter.this.notifyDataSetChanged();
                }
            }

            public void onInvalidated() {
                WrapperAdapter.this.notifyDataSetInvalidated();
            }
        };
        private boolean mIsAnimationEnabled = false;

        public WrapperAdapter(ListAdapter adapter) {
            this.mAdapter = adapter;
            this.mAdapter.registerDataSetObserver(this.mObserver);
        }

        public void setShouldNotifyChange(boolean shouldNotifyChange) {
            this.mShouldNotifyChange = shouldNotifyChange;
        }

        public boolean isAnimationEnabled() {
            return this.mIsAnimationEnabled;
        }

        public int getCount() {
            return this.mAdapter.getCount();
        }

        public int getItemViewType(int position) {
            return this.mAdapter.getItemViewType(position);
        }

        public int getViewTypeCount() {
            return this.mAdapter.getViewTypeCount();
        }

        public Object getItem(int position) {
            return this.mAdapter.getItem(position);
        }

        public long getItemId(int position) {
            return this.mAdapter.getItemId(position);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            return this.mAdapter.getView(position, convertView, parent);
        }

        public boolean hasStableIds() {
            boolean stable;
            this.mIsAnimationEnabled = stable = this.mAdapter.hasStableIds();
            return stable;
        }
    }

    public static interface Manipulator<T extends ListAdapter> {
        public void manipulate(T var1);
    }
}

