/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ScrollView;
import java.util.ArrayList;
import java.util.List;

public class QMUIObservableScrollView
extends ScrollView {
    private int mScrollOffset = 0;
    private List<OnScrollChangedListener> mOnScrollChangedListeners;

    public QMUIObservableScrollView(Context context) {
        super(context);
    }

    public QMUIObservableScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public QMUIObservableScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void addOnScrollChangedListener(OnScrollChangedListener onScrollChangedListener) {
        if (this.mOnScrollChangedListeners == null) {
            this.mOnScrollChangedListeners = new ArrayList<OnScrollChangedListener>();
        }
        if (this.mOnScrollChangedListeners.contains(onScrollChangedListener)) {
            return;
        }
        this.mOnScrollChangedListeners.add(onScrollChangedListener);
    }

    public void removeOnScrollChangedListener(OnScrollChangedListener onScrollChangedListener) {
        if (this.mOnScrollChangedListeners == null) {
            return;
        }
        this.mOnScrollChangedListeners.remove(onScrollChangedListener);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.mScrollOffset = t;
        if (this.mOnScrollChangedListeners != null && !this.mOnScrollChangedListeners.isEmpty()) {
            for (OnScrollChangedListener listener : this.mOnScrollChangedListeners) {
                listener.onScrollChanged(this, l, t, oldl, oldt);
            }
        }
    }

    public int getScrollOffset() {
        return this.mScrollOffset;
    }

    public static interface OnScrollChangedListener {
        public void onScrollChanged(QMUIObservableScrollView var1, int var2, int var3, int var4, int var5);
    }
}

