/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

public class QMUIProgressBar
extends View {
    public static int TYPE_RECT = 0;
    public static int TYPE_CIRCLE = 1;
    public static int TOTAL_DURATION = 1000;
    public static int DEFAULT_PROGRESS_COLOR = -16776961;
    public static int DEFAULT_BACKGROUND_COLOR = -7829368;
    public static int DEFAULT_TEXT_SIZE = 20;
    public static int DEFAULT_TEXT_COLOR = -16777216;
    public static int DEFAULT_STROKE_WIDTH = QMUIDisplayHelper.dpToPx(40);
    QMUIProgressBarTextGenerator mQMUIProgressBarTextGenerator;
    RectF mBgRect;
    RectF mProgressRect;
    private int mWidth;
    private int mHeight;
    private int mType;
    private int mProgressColor;
    private int mBackgroundColor;
    private boolean isAnimating = false;
    private int mMaxValue;
    private int mValue;
    private ValueAnimator mAnimator;
    private Paint mBackgroundPaint = new Paint();
    private Paint mPaint = new Paint();
    private Paint mTextPaint = new Paint(1);
    private RectF mArcOval = new RectF();
    private String mText = "";
    private int mStrokeWidth;
    private int mCircleRadius;
    private Point mCenterPoint;

    public QMUIProgressBar(Context context) {
        super(context);
        this.setup(context, null);
    }

    public QMUIProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs);
    }

    public QMUIProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context, attrs);
    }

    public void setup(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUIProgressBar);
        this.mType = array.getInt(R.styleable.QMUIProgressBar_qmui_type, TYPE_RECT);
        this.mProgressColor = array.getColor(R.styleable.QMUIProgressBar_qmui_progress_color, DEFAULT_PROGRESS_COLOR);
        this.mBackgroundColor = array.getColor(R.styleable.QMUIProgressBar_qmui_background_color, DEFAULT_BACKGROUND_COLOR);
        this.mMaxValue = array.getInt(R.styleable.QMUIProgressBar_qmui_max_value, 100);
        this.mValue = array.getInt(R.styleable.QMUIProgressBar_qmui_value, 0);
        boolean isRoundCap = array.getBoolean(R.styleable.QMUIProgressBar_qmui_stroke_round_cap, false);
        int textSize = DEFAULT_TEXT_SIZE;
        if (array.hasValue(R.styleable.QMUIProgressBar_android_textSize)) {
            textSize = array.getDimensionPixelSize(R.styleable.QMUIProgressBar_android_textSize, DEFAULT_TEXT_SIZE);
        }
        int textColor = DEFAULT_TEXT_COLOR;
        if (array.hasValue(R.styleable.QMUIProgressBar_android_textColor)) {
            textColor = array.getColor(R.styleable.QMUIProgressBar_android_textColor, DEFAULT_TEXT_COLOR);
        }
        if (this.mType == TYPE_CIRCLE) {
            this.mStrokeWidth = array.getDimensionPixelSize(R.styleable.QMUIProgressBar_qmui_stroke_width, DEFAULT_STROKE_WIDTH);
        }
        array.recycle();
        this.configPaint(textColor, textSize, isRoundCap);
        this.setProgress(this.mValue);
    }

    private void configShape() {
        if (this.mType == TYPE_RECT) {
            this.mBgRect = new RectF((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.mWidth + this.getPaddingLeft()), (float)(this.mHeight + this.getPaddingTop()));
            this.mProgressRect = new RectF();
        } else {
            this.mCircleRadius = (Math.min(this.mWidth, this.mHeight) - this.mStrokeWidth) / 2;
            this.mCenterPoint = new Point(this.mWidth / 2, this.mHeight / 2);
        }
    }

    private void configPaint(int textColor, int textSize, boolean isRoundCap) {
        this.mPaint.setColor(this.mProgressColor);
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        if (this.mType == TYPE_RECT) {
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        } else {
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth((float)this.mStrokeWidth);
            this.mPaint.setAntiAlias(true);
            if (isRoundCap) {
                this.mPaint.setStrokeCap(Paint.Cap.ROUND);
            }
            this.mBackgroundPaint.setStyle(Paint.Style.STROKE);
            this.mBackgroundPaint.setStrokeWidth((float)this.mStrokeWidth);
            this.mBackgroundPaint.setAntiAlias(true);
        }
        this.mTextPaint.setColor(textColor);
        this.mTextPaint.setTextSize((float)textSize);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
    }

    public void setTextSize(int textSize) {
        this.mTextPaint.setTextSize((float)textSize);
        this.invalidate();
    }

    public void setTextColor(int textColor) {
        this.mTextPaint.setColor(textColor);
        this.invalidate();
    }

    public void setStrokeRoundCap(boolean isRoundCap) {
        this.mPaint.setStrokeCap(isRoundCap ? Paint.Cap.ROUND : Paint.Cap.BUTT);
        this.invalidate();
    }

    public void setQMUIProgressBarTextGenerator(QMUIProgressBarTextGenerator QMUIProgressBarTextGenerator2) {
        this.mQMUIProgressBarTextGenerator = QMUIProgressBarTextGenerator2;
    }

    public QMUIProgressBarTextGenerator getQMUIProgressBarTextGenerator() {
        return this.mQMUIProgressBarTextGenerator;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mQMUIProgressBarTextGenerator != null) {
            this.mText = this.mQMUIProgressBarTextGenerator.generateText(this, this.mValue, this.mMaxValue);
        }
        if (this.mType == TYPE_RECT) {
            this.drawRect(canvas);
        } else {
            this.drawCircle(canvas);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        this.mHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        this.configShape();
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    private void drawRect(Canvas canvas) {
        canvas.drawRect(this.mBgRect, this.mBackgroundPaint);
        this.mProgressRect.set((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getPaddingLeft() + this.parseValueToWidth()), (float)(this.getPaddingTop() + this.mHeight));
        canvas.drawRect(this.mProgressRect, this.mPaint);
        if (this.mText != null && this.mText.length() > 0) {
            Paint.FontMetricsInt fontMetrics = this.mTextPaint.getFontMetricsInt();
            float baseline = this.mBgRect.top + (this.mBgRect.height() - (float)fontMetrics.bottom + (float)fontMetrics.top) / 2.0f - (float)fontMetrics.top;
            canvas.drawText(this.mText, this.mBgRect.centerX(), baseline, this.mTextPaint);
        }
    }

    private void drawCircle(Canvas canvas) {
        canvas.drawCircle((float)this.mCenterPoint.x, (float)this.mCenterPoint.y, (float)this.mCircleRadius, this.mBackgroundPaint);
        this.mArcOval.left = this.mCenterPoint.x - this.mCircleRadius;
        this.mArcOval.right = this.mCenterPoint.x + this.mCircleRadius;
        this.mArcOval.top = this.mCenterPoint.y - this.mCircleRadius;
        this.mArcOval.bottom = this.mCenterPoint.y + this.mCircleRadius;
        canvas.drawArc(this.mArcOval, 270.0f, (float)(360 * this.mValue / this.mMaxValue), false, this.mPaint);
        if (this.mText != null && this.mText.length() > 0) {
            Paint.FontMetricsInt fontMetrics = this.mTextPaint.getFontMetricsInt();
            float baseline = this.mArcOval.top + (this.mArcOval.height() - (float)fontMetrics.bottom + (float)fontMetrics.top) / 2.0f - (float)fontMetrics.top;
            canvas.drawText(this.mText, (float)this.mCenterPoint.x, baseline, this.mTextPaint);
        }
    }

    private int parseValueToWidth() {
        return this.mWidth * this.mValue / this.mMaxValue;
    }

    public int getProgress() {
        return this.mValue;
    }

    public void setProgress(int progress) {
        this.setProgress(progress, true);
    }

    public void setProgress(int progress, boolean animated) {
        if (progress > this.mMaxValue && progress < 0) {
            return;
        }
        if (this.isAnimating) {
            this.isAnimating = false;
            this.mAnimator.cancel();
        }
        int oldValue = this.mValue;
        this.mValue = progress;
        if (animated) {
            this.startAnimation(oldValue, progress);
        } else {
            this.invalidate();
        }
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(int maxValue) {
        this.mMaxValue = maxValue;
    }

    private void startAnimation(int start, int end) {
        this.mAnimator = ValueAnimator.ofInt((int[])new int[]{start, end});
        int duration = Math.abs(TOTAL_DURATION * (end - start) / this.mMaxValue);
        this.mAnimator.setDuration((long)duration);
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                QMUIProgressBar.this.mValue = (Integer)animation.getAnimatedValue();
                QMUIProgressBar.this.invalidate();
            }
        });
        this.mAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                QMUIProgressBar.this.isAnimating = true;
            }

            public void onAnimationEnd(Animator animation) {
                QMUIProgressBar.this.isAnimating = false;
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.mAnimator.start();
    }

    public static interface QMUIProgressBarTextGenerator {
        public String generateText(QMUIProgressBar var1, int var2, int var3);
    }
}

