/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.alpha.QMUIAlphaImageButton;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIDrawableHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.widget.QMUICollapsingTopBarLayout;
import java.util.ArrayList;
import java.util.List;

public class QMUITopBar
extends RelativeLayout {
    private static final int DEFAULT_VIEW_ID = -1;
    private int mLeftLastViewId;
    private int mRightLastViewId;
    private View mCenterView;
    private LinearLayout mTitleContainerView;
    private TextView mTitleView;
    private TextView mSubTitleView;
    private List<View> mLeftViewList;
    private List<View> mRightViewList;
    private int mTopBarSeparatorColor;
    private int mTopBarBgColor;
    private int mTopBarSeparatorHeight;
    private Drawable mTopBarBgWithSeparatorDrawableCache;
    private int mTitleGravity;
    private int mLeftBackDrawableRes;
    private int mTitleTextSize;
    private int mTitleTextSizeWithSubTitle;
    private int mSubTitleTextSize;
    private int mTitleTextColor;
    private int mSubTitleTextColor;
    private int mTitleMarginHorWhenNoBtnAside;
    private int mTitleContainerPaddingHor;
    private int mTopBarImageBtnWidth;
    private int mTopBarImageBtnHeight;
    private int mTopBarTextBtnPaddingHor;
    private ColorStateList mTopBarTextBtnTextColor;
    private int mTopBarTextBtnTextSize;
    private int mTopbarHeight = -1;
    private Rect mTitleContainerRect;

    public QMUITopBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initVar();
        this.init(context, attrs, defStyleAttr);
    }

    public QMUITopBar(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUITopBarStyle);
    }

    public QMUITopBar(Context context) {
        this(context, null);
    }

    QMUITopBar(Context context, boolean inTopBarLayout) {
        super(context);
        this.initVar();
        if (inTopBarLayout) {
            int transparentColor;
            this.mTopBarSeparatorColor = transparentColor = ContextCompat.getColor((Context)context, (int)R.color.qmui_config_color_transparent);
            this.mTopBarSeparatorHeight = 0;
            this.mTopBarBgColor = transparentColor;
        } else {
            this.init(context, null, R.attr.QMUITopBarStyle);
        }
    }

    private void initVar() {
        this.mLeftLastViewId = -1;
        this.mRightLastViewId = -1;
        this.mLeftViewList = new ArrayList<View>();
        this.mRightViewList = new ArrayList<View>();
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.QMUITopBar, defStyleAttr, 0);
        this.mTopBarSeparatorColor = array.getColor(R.styleable.QMUITopBar_qmui_topbar_separator_color, ContextCompat.getColor((Context)context, (int)R.color.qmui_config_color_separator));
        this.mTopBarSeparatorHeight = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_separator_height, 1);
        this.mTopBarBgColor = array.getColor(R.styleable.QMUITopBar_qmui_topbar_bg_color, -1);
        this.getCommonFieldFormTypedArray(context, array);
        boolean hasSeparator = array.getBoolean(R.styleable.QMUITopBar_qmui_topbar_need_separator, true);
        array.recycle();
        this.setBackgroundDividerEnabled(hasSeparator);
    }

    void getCommonFieldFormTypedArray(Context context, TypedArray array) {
        this.mLeftBackDrawableRes = array.getResourceId(R.styleable.QMUITopBar_qmui_topbar_left_back_drawable_id, R.id.qmui_topbar_item_left_back);
        this.mTitleGravity = array.getInt(R.styleable.QMUITopBar_qmui_topbar_title_gravity, 17);
        this.mTitleTextSize = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_title_text_size, QMUIDisplayHelper.sp2px(context, 17));
        this.mTitleTextSizeWithSubTitle = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_title_text_size, QMUIDisplayHelper.sp2px(context, 16));
        this.mSubTitleTextSize = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_subtitle_text_size, QMUIDisplayHelper.sp2px(context, 11));
        this.mTitleTextColor = array.getColor(R.styleable.QMUITopBar_qmui_topbar_title_color, QMUIResHelper.getAttrColor(context, R.attr.qmui_config_color_gray_1));
        this.mSubTitleTextColor = array.getColor(R.styleable.QMUITopBar_qmui_topbar_subtitle_color, QMUIResHelper.getAttrColor(context, R.attr.qmui_config_color_gray_4));
        this.mTitleMarginHorWhenNoBtnAside = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_title_margin_horizontal_when_no_btn_aside, 0);
        this.mTitleContainerPaddingHor = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_title_container_padding_horizontal, 0);
        this.mTopBarImageBtnWidth = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_image_btn_width, QMUIDisplayHelper.dp2px(context, 48));
        this.mTopBarImageBtnHeight = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_image_btn_height, QMUIDisplayHelper.dp2px(context, 48));
        this.mTopBarTextBtnPaddingHor = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_text_btn_padding_horizontal, QMUIDisplayHelper.dp2px(context, 12));
        this.mTopBarTextBtnTextColor = array.getColorStateList(R.styleable.QMUITopBar_qmui_topbar_text_btn_color_state_list);
        this.mTopBarTextBtnTextSize = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_text_btn_text_size, QMUIDisplayHelper.sp2px(context, 16));
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        for (ViewParent parent = this.getParent(); parent != null && parent instanceof View; parent = parent.getParent()) {
            if (!(parent instanceof QMUICollapsingTopBarLayout)) continue;
            this.makeSureTitleContainerView();
            return;
        }
    }

    public void setCenterView(View view) {
        if (this.mCenterView == view) {
            return;
        }
        if (this.mCenterView != null) {
            this.removeView(this.mCenterView);
        }
        this.mCenterView = view;
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mCenterView.getLayoutParams();
        if (params == null) {
            params = new RelativeLayout.LayoutParams(-2, -2);
        }
        params.addRule(13);
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    public TextView setTitle(int resId) {
        return this.setTitle(this.getContext().getString(resId));
    }

    public TextView setTitle(String title) {
        TextView titleView = this.getTitleView(false);
        titleView.setText((CharSequence)title);
        if (QMUILangHelper.isNullOrEmpty(title)) {
            titleView.setVisibility(8);
        } else {
            titleView.setVisibility(0);
        }
        return titleView;
    }

    public CharSequence getTitle() {
        if (this.mTitleView == null) {
            return null;
        }
        return this.mTitleView.getText();
    }

    public TextView setEmojiTitle(String title) {
        TextView titleView = this.getTitleView(true);
        titleView.setText((CharSequence)title);
        if (QMUILangHelper.isNullOrEmpty(title)) {
            titleView.setVisibility(8);
        } else {
            titleView.setVisibility(0);
        }
        return titleView;
    }

    public void showTitleView(boolean toShow) {
        if (this.mTitleView != null) {
            this.mTitleView.setVisibility(toShow ? 0 : 8);
        }
    }

    private TextView getTitleView(boolean isEmoji) {
        if (this.mTitleView == null) {
            this.mTitleView = new TextView(this.getContext());
            this.mTitleView.setGravity(17);
            this.mTitleView.setSingleLine(true);
            this.mTitleView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
            this.mTitleView.setTextColor(this.mTitleTextColor);
            this.updateTitleViewStyle();
            LinearLayout.LayoutParams titleLp = this.generateTitleViewAndSubTitleViewLp();
            this.makeSureTitleContainerView().addView((View)this.mTitleView, (ViewGroup.LayoutParams)titleLp);
        }
        return this.mTitleView;
    }

    private void updateTitleViewStyle() {
        if (this.mTitleView != null) {
            if (this.mSubTitleView == null || QMUILangHelper.isNullOrEmpty(this.mSubTitleView.getText())) {
                this.mTitleView.setTextSize(0, (float)this.mTitleTextSize);
            } else {
                this.mTitleView.setTextSize(0, (float)this.mTitleTextSizeWithSubTitle);
            }
        }
    }

    public void setSubTitle(String subTitle) {
        TextView titleView = this.getSubTitleView();
        titleView.setText((CharSequence)subTitle);
        if (QMUILangHelper.isNullOrEmpty(subTitle)) {
            titleView.setVisibility(8);
        } else {
            titleView.setVisibility(0);
        }
        this.updateTitleViewStyle();
    }

    public void setSubTitle(int resId) {
        this.setSubTitle(this.getResources().getString(resId));
    }

    private TextView getSubTitleView() {
        if (this.mSubTitleView == null) {
            this.mSubTitleView = new TextView(this.getContext());
            this.mSubTitleView.setGravity(17);
            this.mSubTitleView.setSingleLine(true);
            this.mSubTitleView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
            this.mSubTitleView.setTextSize(0, (float)this.mSubTitleTextSize);
            this.mSubTitleView.setTextColor(this.mSubTitleTextColor);
            LinearLayout.LayoutParams titleLp = this.generateTitleViewAndSubTitleViewLp();
            titleLp.topMargin = QMUIDisplayHelper.dp2px(this.getContext(), 1);
            this.makeSureTitleContainerView().addView((View)this.mSubTitleView, (ViewGroup.LayoutParams)titleLp);
        }
        return this.mSubTitleView;
    }

    public void setTitleGravity(int gravity) {
        this.mTitleGravity = gravity;
        if (this.mTitleView != null) {
            ((LinearLayout.LayoutParams)this.mTitleView.getLayoutParams()).gravity = gravity;
            if (gravity == 17 || gravity == 1) {
                this.mTitleView.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingLeft(), this.getPaddingBottom());
            }
        }
        if (this.mSubTitleView != null) {
            ((LinearLayout.LayoutParams)this.mSubTitleView.getLayoutParams()).gravity = gravity;
        }
        this.requestLayout();
    }

    public Rect getTitleContainerRect() {
        if (this.mTitleContainerRect == null) {
            this.mTitleContainerRect = new Rect();
        }
        if (this.mTitleContainerView == null) {
            this.mTitleContainerRect.set(0, 0, 0, 0);
        } else {
            QMUIViewHelper.getDescendantRect((ViewGroup)this, (View)this.mTitleContainerView, this.mTitleContainerRect);
        }
        return this.mTitleContainerRect;
    }

    private LinearLayout makeSureTitleContainerView() {
        if (this.mTitleContainerView == null) {
            this.mTitleContainerView = new LinearLayout(this.getContext());
            this.mTitleContainerView.setOrientation(1);
            this.mTitleContainerView.setGravity(17);
            this.mTitleContainerView.setPadding(this.mTitleContainerPaddingHor, 0, this.mTitleContainerPaddingHor, 0);
            this.addView((View)this.mTitleContainerView, (ViewGroup.LayoutParams)this.generateTitleContainerViewLp());
        }
        return this.mTitleContainerView;
    }

    private RelativeLayout.LayoutParams generateTitleContainerViewLp() {
        return new RelativeLayout.LayoutParams(-1, QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_topbar_height));
    }

    private LinearLayout.LayoutParams generateTitleViewAndSubTitleViewLp() {
        LinearLayout.LayoutParams titleLp = new LinearLayout.LayoutParams(-2, -2);
        titleLp.gravity = this.mTitleGravity;
        return titleLp;
    }

    public void addLeftView(View view, int viewId) {
        ViewGroup.LayoutParams viewLayoutParams = view.getLayoutParams();
        RelativeLayout.LayoutParams layoutParams = viewLayoutParams != null && viewLayoutParams instanceof RelativeLayout.LayoutParams ? (RelativeLayout.LayoutParams)viewLayoutParams : new RelativeLayout.LayoutParams(-2, -2);
        this.addLeftView(view, viewId, layoutParams);
    }

    public void addLeftView(View view, int viewId, RelativeLayout.LayoutParams layoutParams) {
        if (this.mLeftLastViewId == -1) {
            layoutParams.addRule(9);
        } else {
            layoutParams.addRule(1, this.mLeftLastViewId);
        }
        layoutParams.alignWithParent = true;
        this.mLeftLastViewId = viewId;
        view.setId(viewId);
        this.mLeftViewList.add(view);
        this.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    public void addRightView(View view, int viewId) {
        ViewGroup.LayoutParams viewLayoutParams = view.getLayoutParams();
        RelativeLayout.LayoutParams layoutParams = viewLayoutParams != null && viewLayoutParams instanceof RelativeLayout.LayoutParams ? (RelativeLayout.LayoutParams)viewLayoutParams : new RelativeLayout.LayoutParams(-2, -2);
        this.addRightView(view, viewId, layoutParams);
    }

    public void addRightView(View view, int viewId, RelativeLayout.LayoutParams layoutParams) {
        if (this.mRightLastViewId == -1) {
            layoutParams.addRule(11);
        } else {
            layoutParams.addRule(0, this.mRightLastViewId);
        }
        layoutParams.alignWithParent = true;
        this.mRightLastViewId = viewId;
        view.setId(viewId);
        this.mRightViewList.add(view);
        this.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    public RelativeLayout.LayoutParams generateTopBarImageButtonLayoutParams() {
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(this.mTopBarImageBtnWidth, this.mTopBarImageBtnHeight);
        lp.topMargin = Math.max(0, (this.getTopBarHeight() - this.mTopBarImageBtnHeight) / 2);
        return lp;
    }

    public QMUIAlphaImageButton addRightImageButton(int drawableResId, int viewId) {
        QMUIAlphaImageButton rightButton = this.generateTopBarImageButton(drawableResId);
        this.addRightView((View)rightButton, viewId, this.generateTopBarImageButtonLayoutParams());
        return rightButton;
    }

    public QMUIAlphaImageButton addLeftImageButton(int drawableResId, int viewId) {
        QMUIAlphaImageButton leftButton = this.generateTopBarImageButton(drawableResId);
        this.addLeftView((View)leftButton, viewId, this.generateTopBarImageButtonLayoutParams());
        return leftButton;
    }

    public RelativeLayout.LayoutParams generateTopBarTextButtonLayoutParams() {
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, this.mTopBarImageBtnHeight);
        lp.topMargin = Math.max(0, (this.getTopBarHeight() - this.mTopBarImageBtnHeight) / 2);
        return lp;
    }

    public Button addLeftTextButton(int stringResId, int viewId) {
        return this.addLeftTextButton(this.getResources().getString(stringResId), viewId);
    }

    public Button addLeftTextButton(String buttonText, int viewId) {
        Button button = this.generateTopBarTextButton(buttonText);
        this.addLeftView((View)button, viewId, this.generateTopBarTextButtonLayoutParams());
        return button;
    }

    public Button addRightTextButton(int stringResId, int viewId) {
        return this.addRightTextButton(this.getResources().getString(stringResId), viewId);
    }

    public Button addRightTextButton(String buttonText, int viewId) {
        Button button = this.generateTopBarTextButton(buttonText);
        this.addRightView((View)button, viewId, this.generateTopBarTextButtonLayoutParams());
        return button;
    }

    private Button generateTopBarTextButton(String text) {
        Button button = new Button(this.getContext());
        button.setBackgroundResource(0);
        button.setMinWidth(0);
        button.setMinHeight(0);
        button.setMinimumWidth(0);
        button.setMinimumHeight(0);
        button.setPadding(this.mTopBarTextBtnPaddingHor, 0, this.mTopBarTextBtnPaddingHor, 0);
        button.setTextColor(this.mTopBarTextBtnTextColor);
        button.setTextSize(0, (float)this.mTopBarTextBtnTextSize);
        button.setGravity(17);
        button.setText((CharSequence)text);
        return button;
    }

    private QMUIAlphaImageButton generateTopBarImageButton(int imageResourceId) {
        QMUIAlphaImageButton backButton = new QMUIAlphaImageButton(this.getContext());
        backButton.setBackgroundColor(0);
        backButton.setImageResource(imageResourceId);
        return backButton;
    }

    public QMUIAlphaImageButton addLeftBackImageButton() {
        return this.addLeftImageButton(this.mLeftBackDrawableRes, R.id.qmui_topbar_item_left_back);
    }

    public void removeAllLeftViews() {
        for (View leftView : this.mLeftViewList) {
            this.removeView(leftView);
        }
        this.mLeftLastViewId = -1;
        this.mLeftViewList.clear();
    }

    public void removeAllRightViews() {
        for (View rightView : this.mRightViewList) {
            this.removeView(rightView);
        }
        this.mRightLastViewId = -1;
        this.mRightViewList.clear();
    }

    public void removeCenterViewAndTitleView() {
        if (this.mCenterView != null) {
            if (this.mCenterView.getParent() == this) {
                this.removeView(this.mCenterView);
            }
            this.mCenterView = null;
        }
        if (this.mTitleView != null) {
            if (this.mTitleView.getParent() == this) {
                this.removeView((View)this.mTitleView);
            }
            this.mTitleView = null;
        }
    }

    private int getTopBarHeight() {
        if (this.mTopbarHeight == -1) {
            this.mTopbarHeight = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_topbar_height);
        }
        return this.mTopbarHeight;
    }

    public void setBackgroundAlpha(int alpha) {
        this.getBackground().setAlpha(alpha);
    }

    public int computeAndSetBackgroundAlpha(int currentOffset, int alphaBeginOffset, int alphaTargetOffset) {
        double alpha = (float)(currentOffset - alphaBeginOffset) / (float)(alphaTargetOffset - alphaBeginOffset);
        alpha = Math.max(0.0, Math.min(alpha, 1.0));
        int alphaInt = (int)(alpha * 255.0);
        this.setBackgroundAlpha(alphaInt);
        return alphaInt;
    }

    public void setBackgroundDividerEnabled(boolean enabled) {
        if (enabled) {
            if (this.mTopBarBgWithSeparatorDrawableCache == null) {
                this.mTopBarBgWithSeparatorDrawableCache = QMUIDrawableHelper.createItemSeparatorBg(this.mTopBarSeparatorColor, this.mTopBarBgColor, this.mTopBarSeparatorHeight, false);
            }
            QMUIViewHelper.setBackgroundKeepingPadding((View)this, this.mTopBarBgWithSeparatorDrawableCache);
        } else {
            QMUIViewHelper.setBackgroundColorKeepPadding((View)this, this.mTopBarBgColor);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mTitleContainerView != null) {
            int titleContainerWidth;
            int leftViewWidth = 0;
            for (int leftViewIndex = 0; leftViewIndex < this.mLeftViewList.size(); ++leftViewIndex) {
                View view = this.mLeftViewList.get(leftViewIndex);
                if (view.getVisibility() == 8) continue;
                leftViewWidth += view.getMeasuredWidth();
            }
            int rightViewWidth = 0;
            for (int rightViewIndex = 0; rightViewIndex < this.mRightViewList.size(); ++rightViewIndex) {
                View view = this.mRightViewList.get(rightViewIndex);
                if (view.getVisibility() == 8) continue;
                rightViewWidth += view.getMeasuredWidth();
            }
            if ((this.mTitleGravity & 7) == 1) {
                if (leftViewWidth == 0 && rightViewWidth == 0) {
                    leftViewWidth += this.mTitleMarginHorWhenNoBtnAside;
                    rightViewWidth += this.mTitleMarginHorWhenNoBtnAside;
                }
                titleContainerWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - Math.max(leftViewWidth, rightViewWidth) * 2 - this.getPaddingLeft() - this.getPaddingRight();
            } else {
                if (leftViewWidth == 0) {
                    leftViewWidth += this.mTitleMarginHorWhenNoBtnAside;
                }
                if (rightViewWidth == 0) {
                    rightViewWidth += this.mTitleMarginHorWhenNoBtnAside;
                }
                titleContainerWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - leftViewWidth - rightViewWidth - this.getPaddingLeft() - this.getPaddingRight();
            }
            int titleContainerWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)titleContainerWidth, (int)0x40000000);
            this.mTitleContainerView.measure(titleContainerWidthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mTitleContainerView != null) {
            int titleContainerViewWidth = this.mTitleContainerView.getMeasuredWidth();
            int titleContainerViewHeight = this.mTitleContainerView.getMeasuredHeight();
            int titleContainerViewTop = (b - t - this.mTitleContainerView.getMeasuredHeight()) / 2;
            int titleContainerViewLeft = this.getPaddingLeft();
            if ((this.mTitleGravity & 7) == 1) {
                titleContainerViewLeft = (r - l - this.mTitleContainerView.getMeasuredWidth()) / 2;
            } else {
                for (int leftViewIndex = 0; leftViewIndex < this.mLeftViewList.size(); ++leftViewIndex) {
                    View view = this.mLeftViewList.get(leftViewIndex);
                    if (view.getVisibility() == 8) continue;
                    titleContainerViewLeft += view.getMeasuredWidth();
                }
                if (this.mLeftViewList.isEmpty()) {
                    titleContainerViewLeft += QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_topbar_title_margin_horizontal_when_no_btn_aside);
                }
            }
            this.mTitleContainerView.layout(titleContainerViewLeft, titleContainerViewTop, titleContainerViewLeft + titleContainerViewWidth, titleContainerViewTop + titleContainerViewHeight);
        }
    }
}

