/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

public class QMUIVerticalTextView
extends TextView {
    private boolean mIsVerticalMode = true;
    private int mLineCount;
    private float[] mLineWidths;
    private int[] mLineBreakIndex;

    public QMUIVerticalTextView(Context context) {
        super(context);
        this.init();
    }

    public QMUIVerticalTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public QMUIVerticalTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
    }

    @SuppressLint(value={"DrawAllocation"})
    @TargetApi(value=16)
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mIsVerticalMode) {
            float currentLineHeight;
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            float width = this.getPaddingLeft() + this.getPaddingRight();
            float height = this.getPaddingTop() + this.getPaddingBottom();
            char[] chars = this.getText().toString().toCharArray();
            TextPaint paint = this.getPaint();
            Paint.FontMetricsInt fontMetricsInt = paint.getFontMetricsInt();
            int lineMaxBottom = (heightMode == 0 ? Integer.MAX_VALUE : heightSize) - this.getPaddingBottom();
            float lineMaxHeight = currentLineHeight = (float)this.getPaddingTop();
            int lineIndex = 0;
            this.mLineCount = 0;
            this.mLineWidths = new float[chars.length + 1];
            this.mLineBreakIndex = new int[chars.length + 1];
            for (int i = 0; i < chars.length; ++i) {
                boolean needBreakLine;
                float charHeight;
                float charWidth;
                boolean needRotate;
                char c = chars[i];
                boolean bl = needRotate = !QMUIVerticalTextView.isCJKCharacter(c);
                if (needRotate) {
                    charWidth = fontMetricsInt.descent - fontMetricsInt.ascent;
                    charHeight = paint.measureText(chars, i, 1);
                } else {
                    charWidth = paint.measureText(chars, i, 1);
                    charHeight = fontMetricsInt.descent - fontMetricsInt.ascent;
                }
                boolean bl2 = needBreakLine = currentLineHeight + charHeight > (float)lineMaxBottom && i > 0;
                if (needBreakLine) {
                    if (lineMaxHeight < currentLineHeight) {
                        lineMaxHeight = currentLineHeight;
                    }
                    this.mLineBreakIndex[lineIndex] = i - 1;
                    width += this.mLineWidths[lineIndex];
                    ++lineIndex;
                    currentLineHeight = charHeight;
                } else if (lineMaxHeight < (currentLineHeight += charHeight)) {
                    lineMaxHeight = currentLineHeight;
                }
                if (this.mLineWidths[lineIndex] < charWidth) {
                    this.mLineWidths[lineIndex] = charWidth;
                }
                if (i != chars.length - 1) continue;
                width += this.mLineWidths[lineIndex];
                height = lineMaxHeight + (float)this.getPaddingBottom();
            }
            if (chars.length > 0) {
                this.mLineCount = lineIndex + 1;
                this.mLineBreakIndex[lineIndex] = chars.length - 1;
            }
            if (this.mLineCount > 1) {
                int lineSpacingCount = this.mLineCount - 1;
                for (int i = 0; i < lineSpacingCount; ++i) {
                    width += this.mLineWidths[i] * (this.getLineSpacingMultiplier() - 1.0f) + this.getLineSpacingExtra();
                }
            }
            if (heightMode == 0x40000000) {
                height = heightSize;
            } else if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(height, (float)heightSize);
            }
            if (widthMode == 0x40000000) {
                width = widthSize;
            } else if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(width, (float)widthSize);
            }
            this.setMeasuredDimension((int)width, (int)height);
        }
    }

    @TargetApi(value=16)
    protected void onDraw(Canvas canvas) {
        if (!this.mIsVerticalMode) {
            super.onDraw(canvas);
        } else {
            float curLineX;
            if (this.mLineCount == 0) {
                return;
            }
            TextPaint paint = this.getPaint();
            paint.setColor(this.getCurrentTextColor());
            paint.drawableState = this.getDrawableState();
            Paint.FontMetricsInt fontMetricsInt = paint.getFontMetricsInt();
            char[] chars = this.getText().toString().toCharArray();
            canvas.save();
            int curLine = 0;
            float curX = curLineX = (float)(this.getWidth() - this.getPaddingRight()) - this.mLineWidths[curLine];
            float curY = this.getPaddingTop();
            for (int i = 0; i < chars.length; ++i) {
                boolean nextCharBreakLine;
                boolean hasNextChar;
                char c = chars[i];
                boolean needRotate = !QMUIVerticalTextView.isCJKCharacter(c);
                int saveCount = canvas.save();
                if (needRotate) {
                    canvas.rotate(90.0f, curX, curY);
                }
                float textX = curX;
                float textBaseline = needRotate ? curY - (this.mLineWidths[curLine] - (float)(fontMetricsInt.bottom - fontMetricsInt.top)) / 2.0f - (float)fontMetricsInt.descent : curY - (float)fontMetricsInt.ascent;
                canvas.drawText(chars, i, 1, textX, textBaseline, (Paint)paint);
                canvas.restoreToCount(saveCount);
                boolean bl = hasNextChar = i + 1 < chars.length;
                if (!hasNextChar) continue;
                boolean bl2 = nextCharBreakLine = i + 1 > this.mLineBreakIndex[curLine];
                if (nextCharBreakLine && curLine + 1 < this.mLineWidths.length) {
                    curX = curLineX -= this.mLineWidths[++curLine] * this.getLineSpacingMultiplier() + this.getLineSpacingExtra();
                    curY = this.getPaddingTop();
                    continue;
                }
                if (needRotate) {
                    curY += paint.measureText(chars, i, 1);
                    continue;
                }
                curY += (float)(fontMetricsInt.descent - fontMetricsInt.ascent);
            }
            canvas.restore();
        }
    }

    private static boolean isCJKCharacter(char input) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(input);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.HANGUL_SYLLABLES || ub == Character.UnicodeBlock.HANGUL_JAMO || ub == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || ub == Character.UnicodeBlock.HIRAGANA || ub == Character.UnicodeBlock.KATAKANA || ub == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS;
    }

    public void setVerticalMode(boolean verticalMode) {
        this.mIsVerticalMode = verticalMode;
        this.requestLayout();
    }

    public boolean isVerticalMode() {
        return this.mIsVerticalMode;
    }
}

