/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.content.res.TypedArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.QMUIWrapContentScrollView;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogBuilder;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;

public class QMUIDialogBlockBuilder
extends QMUIDialogBuilder<QMUIDialogBlockBuilder> {
    private CharSequence mContent;

    public QMUIDialogBlockBuilder(Context context) {
        super(context);
        this.setActionDivider(1, R.color.qmui_config_color_separator, 0, 0);
    }

    public QMUIDialogBlockBuilder setContent(CharSequence content) {
        this.mContent = content;
        return this;
    }

    public QMUIDialogBlockBuilder setContent(int contentRes) {
        this.mContent = this.getBaseContext().getResources().getString(contentRes);
        return this;
    }

    @Override
    protected void onConfigTitleView(TextView titleView) {
        super.onConfigTitleView(titleView);
        if (this.mContent == null || this.mContent.length() == 0) {
            TypedArray a = titleView.getContext().obtainStyledAttributes(null, R.styleable.QMUIDialogTitleTvCustomDef, R.attr.qmui_dialog_title_style, 0);
            int count = a.getIndexCount();
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 != R.styleable.QMUIDialogTitleTvCustomDef_qmui_paddingBottomWhenNotContent) continue;
                titleView.setPadding(titleView.getPaddingLeft(), titleView.getPaddingTop(), titleView.getPaddingRight(), a.getDimensionPixelSize(attr2, titleView.getPaddingBottom()));
            }
            a.recycle();
        }
    }

    @Override
    protected void onCreateContent(QMUIDialog dialog, ViewGroup parent, Context context) {
        if (this.mContent != null && this.mContent.length() > 0) {
            QMUISpanTouchFixTextView contentTv = new QMUISpanTouchFixTextView(context);
            QMUIResHelper.assignTextViewWithAttr(contentTv, R.attr.qmui_dialog_message_content_style);
            if (!this.hasTitle()) {
                TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogMessageTvCustomDef, R.attr.qmui_dialog_message_content_style, 0);
                int count = a.getIndexCount();
                for (int i = 0; i < count; ++i) {
                    int attr2 = a.getIndex(i);
                    if (attr2 != R.styleable.QMUIDialogMessageTvCustomDef_qmui_paddingTopWhenNotTitle) continue;
                    contentTv.setPadding(contentTv.getPaddingLeft(), a.getDimensionPixelSize(attr2, contentTv.getPaddingTop()), contentTv.getPaddingRight(), contentTv.getPaddingBottom());
                }
                a.recycle();
            }
            contentTv.setText(this.mContent);
            QMUIWrapContentScrollView scrollView = new QMUIWrapContentScrollView(context);
            scrollView.setMaxHeight(this.getContentAreaMaxHeight());
            scrollView.addView((View)contentTv);
            parent.addView((View)scrollView);
        }
    }

    @Override
    public QMUIDialog create(int style2) {
        this.setActionContainerOrientation(1);
        return super.create(style2);
    }
}

