/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.Space;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIButton;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public abstract class QMUIDialogBuilder<T extends QMUIDialogBuilder> {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static OnProvideDefaultTheme sOnProvideDefaultTheme = null;
    private Context mContext;
    protected QMUIDialog mDialog;
    protected String mTitle;
    private boolean mCancelable = true;
    private boolean mCanceledOnTouchOutside = true;
    protected LinearLayout mRootView;
    protected QMUIDialogView mDialogView;
    protected View mAnchorTopView;
    protected View mAnchorBottomView;
    protected List<QMUIDialogAction> mActions = new ArrayList<QMUIDialogAction>();
    private QMUIDialogView.OnDecorationListener mOnDecorationListener;
    protected TextView mTitleView;
    protected QMUILinearLayout mActionContainer;
    private int mContentAreaMaxHeight = -1;
    private int mActionContainerOrientation = 0;
    private boolean mChangeAlphaForPressOrDisable = true;
    private int mActionDividerThickness = 0;
    private int mActionDividerColorRes = R.color.qmui_config_color_separator;
    private int mActionDividerInsetStart = 0;
    private int mActionDividerInsetEnd = 0;

    public static void setOnProvideDefaultTheme(OnProvideDefaultTheme onProvideDefaultTheme) {
        sOnProvideDefaultTheme = onProvideDefaultTheme;
    }

    public QMUIDialogBuilder(Context context) {
        this.mContext = context;
    }

    protected int getContentAreaMaxHeight() {
        if (this.mContentAreaMaxHeight == -1) {
            return (int)((double)QMUIDisplayHelper.getScreenHeight(this.mContext) * 0.85) - QMUIDisplayHelper.dp2px(this.mContext, 100);
        }
        return this.mContentAreaMaxHeight;
    }

    public Context getBaseContext() {
        return this.mContext;
    }

    public T setContentAreaMaxHeight(int contentAreaMaxHeight) {
        this.mContentAreaMaxHeight = contentAreaMaxHeight;
        return (T)this;
    }

    public T setTitle(String title) {
        if (title != null && title.length() > 0) {
            this.mTitle = title + this.mContext.getString(R.string.qmui_tool_fixellipsize);
        }
        return (T)this;
    }

    public T setTitle(int resId) {
        return this.setTitle(this.mContext.getResources().getString(resId));
    }

    public T setCancelable(boolean cancelable) {
        this.mCancelable = cancelable;
        return (T)this;
    }

    public T setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.mCanceledOnTouchOutside = canceledOnTouchOutside;
        return (T)this;
    }

    public T setOnDecorationListener(QMUIDialogView.OnDecorationListener onDecorationListener) {
        this.mOnDecorationListener = onDecorationListener;
        return (T)this;
    }

    public T setActionContainerOrientation(int actionContainerOrientation) {
        this.mActionContainerOrientation = actionContainerOrientation;
        return (T)this;
    }

    public T setChangeAlphaForPressOrDisable(boolean changeAlphaForPressOrDisable) {
        this.mChangeAlphaForPressOrDisable = changeAlphaForPressOrDisable;
        return (T)this;
    }

    public T setActionDivider(int thickness, int colorRes, int startInset, int endInset) {
        this.mActionDividerThickness = thickness;
        this.mActionDividerColorRes = colorRes;
        this.mActionDividerInsetStart = startInset;
        this.mActionDividerInsetEnd = endInset;
        return (T)this;
    }

    public T addAction(@Nullable QMUIDialogAction action) {
        if (action != null) {
            this.mActions.add(action);
        }
        return (T)this;
    }

    public T addAction(int strResId, QMUIDialogAction.ActionListener listener) {
        return this.addAction(0, strResId, listener);
    }

    public T addAction(CharSequence str, QMUIDialogAction.ActionListener listener) {
        return this.addAction(0, str, 1, listener);
    }

    public T addAction(int iconResId, int strResId, QMUIDialogAction.ActionListener listener) {
        return this.addAction(iconResId, strResId, 1, listener);
    }

    public T addAction(int iconResId, CharSequence str, QMUIDialogAction.ActionListener listener) {
        return this.addAction(iconResId, str, 1, listener);
    }

    public T addAction(int iconRes, int strRes, int prop, QMUIDialogAction.ActionListener listener) {
        return this.addAction(iconRes, this.mContext.getResources().getString(strRes), prop, listener);
    }

    public T addAction(int iconRes, CharSequence str, int prop, QMUIDialogAction.ActionListener listener) {
        QMUIDialogAction action = new QMUIDialogAction(this.mContext, iconRes, str, prop, listener);
        this.mActions.add(action);
        return (T)this;
    }

    protected boolean hasTitle() {
        return this.mTitle != null && this.mTitle.length() != 0;
    }

    public QMUIDialog show() {
        QMUIDialog dialog = this.create();
        dialog.show();
        return dialog;
    }

    public QMUIDialog create() {
        int theme;
        if (sOnProvideDefaultTheme != null && (theme = sOnProvideDefaultTheme.getThemeForBuilder(this)) > 0) {
            return this.create(theme);
        }
        return this.create(R.style.QMUI_Dialog);
    }

    @SuppressLint(value={"InflateParams"})
    public QMUIDialog create(@StyleRes int style2) {
        this.mDialog = new QMUIDialog(this.mContext, style2);
        Context dialogContext = this.mDialog.getContext();
        this.mRootView = (LinearLayout)LayoutInflater.from((Context)dialogContext).inflate(R.layout.qmui_dialog_layout, null);
        this.mDialogView = (QMUIDialogView)this.mRootView.findViewById(R.id.dialog);
        this.mDialogView.setOnDecorationListener(this.mOnDecorationListener);
        this.mAnchorTopView = this.mRootView.findViewById(R.id.anchor_top);
        this.mAnchorBottomView = this.mRootView.findViewById(R.id.anchor_bottom);
        this.onCreateTitle(this.mDialog, (ViewGroup)this.mDialogView, dialogContext);
        this.onCreateContent(this.mDialog, (ViewGroup)this.mDialogView, dialogContext);
        this.onCreateHandlerBar(this.mDialog, (ViewGroup)this.mDialogView, dialogContext);
        this.mDialog.addContentView((View)this.mRootView, new ViewGroup.LayoutParams(-1, -2));
        this.mDialog.setCancelable(this.mCancelable);
        this.mDialog.setCanceledOnTouchOutside(this.mCanceledOnTouchOutside);
        this.onAfter(this.mDialog, this.mRootView, dialogContext);
        return this.mDialog;
    }

    protected void onCreateTitle(QMUIDialog dialog, ViewGroup parent, Context context) {
        if (this.hasTitle()) {
            this.mTitleView = new TextView(context);
            this.mTitleView.setText((CharSequence)this.mTitle);
            QMUIResHelper.assignTextViewWithAttr(this.mTitleView, R.attr.qmui_dialog_title_style);
            this.onConfigTitleView(this.mTitleView);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
            this.mTitleView.setLayoutParams((ViewGroup.LayoutParams)lp);
            parent.addView((View)this.mTitleView);
        }
    }

    protected void onConfigTitleView(TextView titleView) {
    }

    public TextView getTitleView() {
        return this.mTitleView;
    }

    protected abstract void onCreateContent(QMUIDialog var1, ViewGroup var2, Context var3);

    protected void onCreateHandlerBar(QMUIDialog dialog, ViewGroup parent, Context context) {
        int size = this.mActions.size();
        if (size > 0) {
            TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogActionContainerCustomDef, R.attr.qmui_dialog_action_container_style, 0);
            int count = a.getIndexCount();
            int justifyContent = 1;
            int spaceCustomIndex = 0;
            int actionHeight = -1;
            int actionSpace = 0;
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.QMUIDialogActionContainerCustomDef_qmui_dialog_action_container_justify_content) {
                    justifyContent = a.getInteger(attr2, justifyContent);
                    continue;
                }
                if (attr2 == R.styleable.QMUIDialogActionContainerCustomDef_qmui_dialog_action_container_custom_space_index) {
                    spaceCustomIndex = a.getInteger(attr2, 0);
                    continue;
                }
                if (attr2 == R.styleable.QMUIDialogActionContainerCustomDef_qmui_dialog_action_space) {
                    actionSpace = a.getDimensionPixelSize(attr2, 0);
                    continue;
                }
                if (attr2 != R.styleable.QMUIDialogActionContainerCustomDef_qmui_dialog_action_height) continue;
                actionHeight = a.getDimensionPixelSize(attr2, 0);
            }
            a.recycle();
            int spaceInsertPos = -1;
            if (this.mActionContainerOrientation == 1) {
                spaceInsertPos = -1;
            } else if (justifyContent == 0) {
                spaceInsertPos = size;
            } else if (justifyContent == 1) {
                spaceInsertPos = 0;
            } else if (justifyContent == 3) {
                spaceInsertPos = spaceCustomIndex;
            }
            this.mActionContainer = new QMUILinearLayout(context, null, R.attr.qmui_dialog_action_container_style);
            this.mActionContainer.setOrientation(this.mActionContainerOrientation == 1 ? 1 : 0);
            this.mActionContainer.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            for (int i = 0; i < size; ++i) {
                LinearLayout.LayoutParams actionLp;
                if (spaceInsertPos == i) {
                    this.mActionContainer.addView(this.createActionContainerSpace(context));
                }
                QMUIDialogAction action = this.mActions.get(i);
                if (this.mActionContainerOrientation == 1) {
                    actionLp = new LinearLayout.LayoutParams(-1, actionHeight);
                } else {
                    actionLp = new LinearLayout.LayoutParams(-2, actionHeight);
                    if (spaceInsertPos >= 0) {
                        if (i >= spaceInsertPos) {
                            actionLp.leftMargin = actionSpace;
                        } else {
                            actionLp.rightMargin = actionSpace;
                        }
                    }
                    if (justifyContent == 2) {
                        actionLp.weight = 1.0f;
                    }
                }
                QMUIButton actionView = action.buildActionView(this.mDialog, i);
                if (this.mActionDividerThickness > 0 && i > 0 && spaceInsertPos != i) {
                    if (this.mActionContainerOrientation == 1) {
                        actionView.onlyShowTopDivider(this.mActionDividerInsetStart, this.mActionDividerInsetEnd, this.mActionDividerThickness, ContextCompat.getColor((Context)context, (int)this.mActionDividerColorRes));
                    } else {
                        actionView.onlyShowLeftDivider(this.mActionDividerInsetStart, this.mActionDividerInsetEnd, this.mActionDividerThickness, ContextCompat.getColor((Context)context, (int)this.mActionDividerColorRes));
                    }
                }
                actionView.setChangeAlphaWhenDisable(this.mChangeAlphaForPressOrDisable);
                actionView.setChangeAlphaWhenPress(this.mChangeAlphaForPressOrDisable);
                this.mActionContainer.addView((View)actionView, (ViewGroup.LayoutParams)actionLp);
            }
            if (spaceInsertPos == size) {
                this.mActionContainer.addView(this.createActionContainerSpace(context));
            }
            if (this.mActionContainerOrientation == 0) {
                this.mActionContainer.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                        View lastChild;
                        int width = right - left;
                        int childCount = QMUIDialogBuilder.this.mActionContainer.getChildCount();
                        if (childCount > 0 && (lastChild = QMUIDialogBuilder.this.mActionContainer.getChildAt(childCount - 1)).getRight() > width) {
                            int childPaddingHor = Math.max(0, lastChild.getPaddingLeft() - QMUIDisplayHelper.dp2px(QMUIDialogBuilder.this.mContext, 3));
                            for (int i = 0; i < childCount; ++i) {
                                QMUIDialogBuilder.this.mActionContainer.getChildAt(i).setPadding(childPaddingHor, 0, childPaddingHor, 0);
                            }
                        }
                    }
                });
            }
            parent.addView((View)this.mActionContainer);
        }
    }

    private View createActionContainerSpace(Context context) {
        Space space = new Space(context);
        LinearLayout.LayoutParams spaceLp = new LinearLayout.LayoutParams(0, 0);
        spaceLp.weight = 1.0f;
        space.setLayoutParams((ViewGroup.LayoutParams)spaceLp);
        return space;
    }

    protected void onAfter(QMUIDialog dialog, LinearLayout parent, Context context) {
        View.OnClickListener listener = new View.OnClickListener(){

            public void onClick(View v) {
                QMUIDialogBuilder.this.mDialog.cancelOutSide();
            }
        };
        this.mAnchorBottomView.setOnClickListener(listener);
        this.mAnchorTopView.setOnClickListener(listener);
        this.mRootView.setOnClickListener(listener);
    }

    public View getAnchorTopView() {
        return this.mAnchorTopView;
    }

    public View getAnchorBottomView() {
        return this.mAnchorBottomView;
    }

    public List<QMUIDialogAction> getPositiveAction() {
        ArrayList<QMUIDialogAction> output = new ArrayList<QMUIDialogAction>();
        for (QMUIDialogAction action : this.mActions) {
            if (action.getActionProp() != 0) continue;
            output.add(action);
        }
        return output;
    }

    public static interface OnProvideDefaultTheme {
        public int getThemeForBuilder(QMUIDialogBuilder var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

