/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.grouplist;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.widget.Space;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class QMUICommonListItemView
extends RelativeLayout {
    public static final int ACCESSORY_TYPE_NONE = 0;
    public static final int ACCESSORY_TYPE_CHEVRON = 1;
    public static final int ACCESSORY_TYPE_SWITCH = 2;
    public static final int ACCESSORY_TYPE_CUSTOM = 3;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int REDDOT_POSITION_LEFT = 0;
    public static final int REDDOT_POSITION_RIGHT = 1;
    private int mAccessoryType;
    private int mOrientation = 1;
    private int mRedDotPosition = 0;
    protected ImageView mImageView;
    private ViewGroup mAccessoryView;
    protected LinearLayout mTextContainer;
    protected TextView mTextView;
    protected TextView mDetailTextView;
    protected Space mTextDetailSpace;
    protected CheckBox mSwitch;
    private ImageView mRedDot;
    private ViewStub mNewTipViewStub;
    private View mNewTip;

    public QMUICommonListItemView(Context context) {
        this(context, null);
    }

    public QMUICommonListItemView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUICommonListItemViewStyle);
    }

    public QMUICommonListItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    protected void init(Context context, AttributeSet attrs, int defStyleAttr) {
        LayoutInflater.from((Context)context).inflate(R.layout.qmui_common_list_item, (ViewGroup)this, true);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUICommonListItemView, defStyleAttr, 0);
        int orientation = array.getInt(R.styleable.QMUICommonListItemView_qmui_orientation, 1);
        int accessoryType = array.getInt(R.styleable.QMUICommonListItemView_qmui_accessory_type, 0);
        int initTitleColor = array.getColor(R.styleable.QMUICommonListItemView_qmui_commonList_titleColor, QMUIResHelper.getAttrColor(this.getContext(), R.attr.qmui_config_color_gray_1));
        int initDetailColor = array.getColor(R.styleable.QMUICommonListItemView_qmui_commonList_detailColor, QMUIResHelper.getAttrColor(this.getContext(), R.attr.qmui_config_color_gray_5));
        array.recycle();
        this.mImageView = (ImageView)this.findViewById(R.id.group_list_item_imageView);
        this.mTextContainer = (LinearLayout)this.findViewById(R.id.group_list_item_textContainer);
        this.mTextView = (TextView)this.findViewById(R.id.group_list_item_textView);
        this.mTextView.setTextColor(initTitleColor);
        this.mRedDot = (ImageView)this.findViewById(R.id.group_list_item_tips_dot);
        this.mNewTipViewStub = (ViewStub)this.findViewById(R.id.group_list_item_tips_new);
        this.mDetailTextView = (TextView)this.findViewById(R.id.group_list_item_detailTextView);
        this.mTextDetailSpace = (Space)this.findViewById(R.id.group_list_item_space);
        this.mDetailTextView.setTextColor(initDetailColor);
        LinearLayout.LayoutParams detailTextViewLP = (LinearLayout.LayoutParams)this.mDetailTextView.getLayoutParams();
        if (QMUIViewHelper.getIsLastLineSpacingExtraError()) {
            detailTextViewLP.bottomMargin = -QMUIResHelper.getAttrDimen(context, R.attr.qmui_common_list_item_detail_line_space);
        }
        detailTextViewLP.topMargin = orientation == 0 ? QMUIDisplayHelper.dp2px(this.getContext(), 6) : 0;
        this.mAccessoryView = (ViewGroup)this.findViewById(R.id.group_list_item_accessoryView);
        this.setOrientation(orientation);
        this.setAccessoryType(accessoryType);
    }

    public void setImageDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            this.mImageView.setVisibility(8);
        } else {
            this.mImageView.setImageDrawable(drawable2);
            this.mImageView.setVisibility(0);
        }
    }

    public void setRedDotPosition(int redDotPosition) {
        this.mRedDotPosition = redDotPosition;
        this.requestLayout();
    }

    public CharSequence getText() {
        return this.mTextView.getText();
    }

    public void setText(CharSequence text) {
        this.mTextView.setText(text);
        if (QMUILangHelper.isNullOrEmpty(text)) {
            this.mTextView.setVisibility(8);
        } else {
            this.mTextView.setVisibility(0);
        }
    }

    public void showRedDot(boolean isShow) {
        this.showRedDot(isShow, true);
    }

    public void showRedDot(boolean isShow, boolean configToShow) {
        this.mRedDot.setVisibility(isShow && configToShow ? 0 : 8);
    }

    public void showNewTip(boolean isShow) {
        if (isShow) {
            if (this.mNewTip == null) {
                this.mNewTip = this.mNewTipViewStub.inflate();
            }
            this.mNewTip.setVisibility(0);
            this.mRedDot.setVisibility(8);
        } else if (this.mNewTip != null && this.mNewTip.getVisibility() == 0) {
            this.mNewTip.setVisibility(8);
        }
    }

    public CharSequence getDetailText() {
        return this.mDetailTextView.getText();
    }

    public void setDetailText(CharSequence text) {
        this.mDetailTextView.setText(text);
        if (QMUILangHelper.isNullOrEmpty(text)) {
            this.mDetailTextView.setVisibility(8);
        } else {
            this.mDetailTextView.setVisibility(0);
        }
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
        LinearLayout.LayoutParams spaceLp = (LinearLayout.LayoutParams)this.mTextDetailSpace.getLayoutParams();
        if (this.mOrientation == 0) {
            this.mTextContainer.setOrientation(1);
            this.mTextContainer.setGravity(3);
            spaceLp.width = -2;
            spaceLp.height = QMUIDisplayHelper.dp2px(this.getContext(), 4);
            spaceLp.weight = 0.0f;
            this.mTextView.setTextSize(0, (float)QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_title_v_text_size));
            this.mDetailTextView.setTextSize(0, (float)QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_detail_v_text_size));
        } else {
            this.mTextContainer.setOrientation(0);
            this.mTextContainer.setGravity(16);
            spaceLp.width = 0;
            spaceLp.height = 0;
            spaceLp.weight = 1.0f;
            this.mTextView.setTextSize(0, (float)QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_title_h_text_size));
            this.mDetailTextView.setTextSize(0, (float)QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_detail_h_text_size));
        }
    }

    public int getAccessoryType() {
        return this.mAccessoryType;
    }

    public void setAccessoryType(int type) {
        this.mAccessoryView.removeAllViews();
        this.mAccessoryType = type;
        switch (type) {
            case 1: {
                ImageView tempImageView = this.getAccessoryImageView();
                tempImageView.setImageDrawable(QMUIResHelper.getAttrDrawable(this.getContext(), R.attr.qmui_common_list_item_chevron));
                this.mAccessoryView.addView((View)tempImageView);
                this.mAccessoryView.setVisibility(0);
                break;
            }
            case 2: {
                if (this.mSwitch == null) {
                    this.mSwitch = new CheckBox(this.getContext());
                    this.mSwitch.setButtonDrawable(QMUIResHelper.getAttrDrawable(this.getContext(), R.attr.qmui_common_list_item_switch));
                    this.mSwitch.setLayoutParams(this.getAccessoryLayoutParams());
                    this.mSwitch.setClickable(false);
                    this.mSwitch.setEnabled(false);
                }
                this.mAccessoryView.addView((View)this.mSwitch);
                this.mAccessoryView.setVisibility(0);
                break;
            }
            case 3: {
                this.mAccessoryView.setVisibility(0);
                break;
            }
            case 0: {
                this.mAccessoryView.setVisibility(8);
            }
        }
    }

    private ViewGroup.LayoutParams getAccessoryLayoutParams() {
        return new ViewGroup.LayoutParams(-2, -2);
    }

    private ImageView getAccessoryImageView() {
        ImageView resultImageView = new ImageView(this.getContext());
        resultImageView.setLayoutParams(this.getAccessoryLayoutParams());
        resultImageView.setScaleType(ImageView.ScaleType.CENTER);
        return resultImageView;
    }

    public TextView getTextView() {
        return this.mTextView;
    }

    public TextView getDetailTextView() {
        return this.mDetailTextView;
    }

    public CheckBox getSwitch() {
        return this.mSwitch;
    }

    public ViewGroup getAccessoryContainerView() {
        return this.mAccessoryView;
    }

    public void addAccessoryCustomView(View view) {
        if (this.mAccessoryType == 3) {
            this.mAccessoryView.addView(view);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int left;
        super.onLayout(changed, l, t, r, b);
        if (this.mRedDot != null && this.mRedDot.getVisibility() == 0) {
            int top = this.getHeight() / 2 - this.mRedDot.getMeasuredHeight() / 2;
            int textLeft = this.mTextContainer.getLeft();
            if (this.mRedDotPosition == 0) {
                float textWidth = this.mTextView.getPaint().measureText(this.mTextView.getText().toString());
                left = (int)((float)textLeft + textWidth + (float)QMUIDisplayHelper.dp2px(this.getContext(), 4));
            } else if (this.mRedDotPosition == 1) {
                left = textLeft + this.mTextContainer.getWidth() - this.mRedDot.getMeasuredWidth();
            } else {
                return;
            }
            this.mRedDot.layout(left, top, left + this.mRedDot.getMeasuredWidth(), top + this.mRedDot.getMeasuredHeight());
        }
        if (this.mNewTip != null && this.mNewTip.getVisibility() == 0) {
            int textLeft = this.mTextContainer.getLeft();
            float textWidth = this.mTextView.getPaint().measureText(this.mTextView.getText().toString());
            left = (int)((float)textLeft + textWidth + (float)QMUIDisplayHelper.dp2px(this.getContext(), 4));
            int top = this.getHeight() / 2 - this.mNewTip.getMeasuredHeight() / 2;
            this.mNewTip.layout(left, top, left + this.mNewTip.getMeasuredWidth(), top + this.mNewTip.getMeasuredHeight());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QMUICommonListItemRedDotPosition {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QMUICommonListItemOrientation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QMUICommonListItemAccessoryType {
    }
}

