/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.popup;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.PopupWindow;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

public abstract class QMUIBasePopup {
    private static final String TAG = "QMUIBasePopup";
    protected Context mContext;
    protected PopupWindow mWindow;
    private RootView mRootViewWrapper;
    protected View mRootView;
    protected Drawable mBackground = null;
    protected WindowManager mWindowManager;
    private PopupWindow.OnDismissListener mDismissListener;
    protected Point mScreenSize = new Point();
    protected int mWindowHeight = 0;
    protected int mWindowWidth = 0;
    private boolean mNeedCacheSize = true;

    public QMUIBasePopup(Context context) {
        this.mContext = context;
        this.mWindow = new PopupWindow(context);
        this.mWindow.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 4) {
                    QMUIBasePopup.this.mWindow.dismiss();
                    return false;
                }
                return false;
            }
        });
        this.mWindowManager = (WindowManager)context.getSystemService("window");
    }

    protected void onDismiss() {
    }

    public View getDecorView() {
        View decorView = null;
        try {
            decorView = this.mWindow.getBackground() == null ? (Build.VERSION.SDK_INT >= 23 ? (View)this.mWindow.getContentView().getParent() : this.mWindow.getContentView()) : (Build.VERSION.SDK_INT >= 23 ? (View)this.mWindow.getContentView().getParent().getParent() : (View)this.mWindow.getContentView().getParent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return decorView;
    }

    public void dimBehind(float dim) {
        if (!this.isShowing()) {
            throw new RuntimeException("should call after method show() or in onShowEnd()");
        }
        View decorView = this.getDecorView();
        if (decorView != null) {
            WindowManager.LayoutParams p = (WindowManager.LayoutParams)decorView.getLayoutParams();
            p.flags |= 2;
            p.dimAmount = dim;
            this.mWindowManager.updateViewLayout(decorView, (ViewGroup.LayoutParams)p);
        }
    }

    public final void show(View view) {
        this.show(view, view);
    }

    public final void show(View parent, View anchorView) {
        if (!ViewCompat.isAttachedToWindow((View)anchorView)) {
            return;
        }
        this.onShowConfig();
        if (this.mWindowWidth == 0 || this.mWindowHeight == 0 || !this.mNeedCacheSize) {
            this.measureWindowSize();
        }
        Point point = this.onShowBegin(parent, anchorView);
        this.mWindow.showAtLocation(parent, 0, point.x, point.y);
        this.onShowEnd();
        parent.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
            }

            public void onViewDetachedFromWindow(View v) {
                if (QMUIBasePopup.this.isShowing()) {
                    QMUIBasePopup.this.dismiss();
                }
            }
        });
    }

    protected void onShowConfig() {
        if (this.mRootViewWrapper == null) {
            throw new IllegalStateException("setContentView was not called with a view to display.");
        }
        if (this.mBackground == null) {
            this.mWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        } else {
            this.mWindow.setBackgroundDrawable(this.mBackground);
        }
        this.mWindow.setWidth(-2);
        this.mWindow.setHeight(-2);
        this.mWindow.setTouchable(true);
        this.mWindow.setFocusable(true);
        this.mWindow.setOutsideTouchable(true);
        this.mWindow.setContentView((View)this.mRootViewWrapper);
        Display screenDisplay = this.mWindowManager.getDefaultDisplay();
        screenDisplay.getSize(this.mScreenSize);
    }

    protected abstract Point onShowBegin(View var1, View var2);

    protected void onShowEnd() {
    }

    public boolean isShowing() {
        return this.mWindow != null && this.mWindow.isShowing();
    }

    private void measureWindowSize() {
        int widthMeasureSpec = this.makeWidthMeasureSpec(this.mRootView);
        int heightMeasureSpec = this.makeHeightMeasureSpec(this.mRootView);
        this.mRootView.measure(widthMeasureSpec, heightMeasureSpec);
        this.mWindowWidth = this.mRootView.getMeasuredWidth();
        this.mWindowHeight = this.mRootView.getMeasuredHeight();
        Log.i((String)TAG, (String)("measureWindowSize: mWindowWidth = " + this.mWindowWidth + " ;mWindowHeight = " + this.mWindowHeight));
    }

    protected int makeWidthMeasureSpec(View view) {
        return View.MeasureSpec.makeMeasureSpec((int)QMUIDisplayHelper.getScreenWidth(this.mContext), (int)Integer.MIN_VALUE);
    }

    protected int makeHeightMeasureSpec(View view) {
        return View.MeasureSpec.makeMeasureSpec((int)QMUIDisplayHelper.getScreenHeight(this.mContext), (int)Integer.MIN_VALUE);
    }

    public void setBackgroundDrawable(Drawable background) {
        this.mBackground = background;
    }

    public void setContentView(View root) {
        if (root == null) {
            throw new IllegalStateException("setContentView was not called with a view to display.");
        }
        this.mRootViewWrapper = new RootView(this.mContext);
        this.mRootViewWrapper.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.mRootView = root;
        this.mRootViewWrapper.addView(root);
        this.mWindow.setContentView((View)this.mRootViewWrapper);
        this.mWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                QMUIBasePopup.this.onDismiss();
                if (QMUIBasePopup.this.mDismissListener != null) {
                    QMUIBasePopup.this.mDismissListener.onDismiss();
                }
            }
        });
    }

    protected abstract void onWindowSizeChange();

    public void setContentView(int layoutResID) {
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.setContentView(inflater.inflate(layoutResID, null));
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mDismissListener = listener;
    }

    public void dismiss() {
        this.mWindow.dismiss();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
    }

    public void setNeedCacheSize(boolean needCacheSize) {
        this.mNeedCacheSize = needCacheSize;
    }

    public class RootView
    extends ViewGroup {
        public RootView(Context context) {
            this(context, null);
        }

        public RootView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected void onConfigurationChanged(Configuration newConfig) {
            if (QMUIBasePopup.this.mWindow != null && QMUIBasePopup.this.mWindow.isShowing()) {
                QMUIBasePopup.this.mWindow.dismiss();
            }
            QMUIBasePopup.this.onConfigurationChanged(newConfig);
        }

        public void addView(View child) {
            if (this.getChildCount() > 0) {
                throw new RuntimeException("only support one child");
            }
            super.addView(child);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (this.getChildCount() == 0) {
                this.setMeasuredDimension(0, 0);
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            int parentWidthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int parentHeightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            widthMeasureSpec = QMUIBasePopup.this.makeWidthMeasureSpec((View)this);
            heightMeasureSpec = QMUIBasePopup.this.makeHeightMeasureSpec((View)this);
            int targetWidthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int targetWidthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int targetHeightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int targetHeightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            if (parentWidthSize < targetWidthSize) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)parentWidthSize, (int)targetWidthMode);
            }
            if (parentHeightSize < targetHeightSize) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)parentHeightSize, (int)targetHeightMode);
            }
            View child = this.getChildAt(0);
            child.measure(widthMeasureSpec, heightMeasureSpec);
            int oldWidth = QMUIBasePopup.this.mWindowWidth;
            int oldHeight = QMUIBasePopup.this.mWindowHeight;
            QMUIBasePopup.this.mWindowWidth = child.getMeasuredWidth();
            QMUIBasePopup.this.mWindowHeight = child.getMeasuredHeight();
            if (oldWidth != QMUIBasePopup.this.mWindowWidth || oldHeight != QMUIBasePopup.this.mWindowHeight && QMUIBasePopup.this.mWindow.isShowing()) {
                QMUIBasePopup.this.onWindowSizeChange();
            }
            Log.i((String)QMUIBasePopup.TAG, (String)("in measure: mWindowWidth = " + QMUIBasePopup.this.mWindowWidth + " ;mWindowHeight = " + QMUIBasePopup.this.mWindowHeight));
            this.setMeasuredDimension(QMUIBasePopup.this.mWindowWidth, QMUIBasePopup.this.mWindowHeight);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            if (this.getChildCount() == 0) {
                return;
            }
            View child = this.getChildAt(0);
            child.layout(0, 0, child.getMeasuredWidth(), child.getMeasuredHeight());
        }
    }
}

