/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.dynamic.host;

import android.text.TextUtils;
import com.tencent.shadow.core.common.InstalledApk;
import com.tencent.shadow.core.common.Logger;
import com.tencent.shadow.core.common.LoggerFactory;
import com.tencent.shadow.dynamic.host.DynamicRuntime;
import dalvik.system.BaseDexClassLoader;
import java.io.File;

public class MultiDynamicContainer {
    private static final Logger mLogger = LoggerFactory.getLogger(MultiDynamicContainer.class);

    public static boolean loadContainerApk(String containerKey, InstalledApk containerApk) {
        ContainerClassLoader containerClassLoader = MultiDynamicContainer.findContainerClassLoader(containerKey);
        if (containerClassLoader != null) {
            String apkFilePath = containerClassLoader.apkFilePath;
            if (mLogger.isInfoEnabled()) {
                mLogger.info("\u8be5containKey\u7684apk\u5df2\u7ecf\u52a0\u8f7d\u8fc7, containKey=" + containerKey + ", last apkPath=" + apkFilePath + ", new apkPath=" + containerApk.apkFilePath);
            }
            if (TextUtils.equals((CharSequence)apkFilePath, (CharSequence)containerApk.apkFilePath)) {
                if (mLogger.isInfoEnabled()) {
                    mLogger.info("\u5df2\u7ecf\u52a0\u8f7d\u76f8\u540capkPath\u7684containerApk\u4e86,\u4e0d\u9700\u8981\u52a0\u8f7d");
                }
                return false;
            }
            if (mLogger.isInfoEnabled()) {
                mLogger.info("\u52a0\u8f7d\u4e0d\u76f8\u540capkPath\u7684containerApk\u4e86,\u5148\u5c06\u8001\u7684\u79fb\u9664");
            }
            try {
                MultiDynamicContainer.removeContainerClassLoader(containerClassLoader);
            }
            catch (Exception e) {
                mLogger.error("\u79fb\u9664\u8001\u7684containerApk\u5931\u8d25", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            MultiDynamicContainer.hackContainerClassLoader(containerKey, containerApk);
            if (mLogger.isInfoEnabled()) {
                mLogger.info("containerApk\u63d2\u5165\u6210\u529f\uff0ccontainerKey=" + containerKey + ", path=" + containerApk.apkFilePath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private static ContainerClassLoader findContainerClassLoader(String containerKey) {
        ClassLoader current = MultiDynamicContainer.class.getClassLoader();
        for (ClassLoader parent = current.getParent(); parent != null; parent = parent.getParent()) {
            ContainerClassLoader item;
            if (!(parent instanceof ContainerClassLoader) || !TextUtils.equals((CharSequence)(item = (ContainerClassLoader)((Object)parent)).containerKey, (CharSequence)containerKey)) continue;
            return item;
        }
        return null;
    }

    private static void removeContainerClassLoader(ContainerClassLoader containerClassLoader) throws Exception {
        ClassLoader parent;
        ClassLoader pathClassLoader;
        ClassLoader child = pathClassLoader = MultiDynamicContainer.class.getClassLoader();
        for (parent = pathClassLoader.getParent(); parent != null && parent != containerClassLoader; parent = parent.getParent()) {
            child = parent;
        }
        if (child != null && parent == containerClassLoader) {
            DynamicRuntime.hackParentClassLoader((ClassLoader)child, (ClassLoader)containerClassLoader.getParent());
        }
    }

    private static void hackContainerClassLoader(String containerKey, InstalledApk containerApk) throws Exception {
        ClassLoader pathClassLoader = MultiDynamicContainer.class.getClassLoader();
        ContainerClassLoader containerClassLoader = new ContainerClassLoader(containerKey, containerApk, pathClassLoader.getParent());
        DynamicRuntime.hackParentClassLoader((ClassLoader)pathClassLoader, (ClassLoader)((Object)containerClassLoader));
    }

    private static class ContainerClassLoader
    extends BaseDexClassLoader {
        private String apkFilePath;
        private String containerKey;

        public ContainerClassLoader(String containerKey, InstalledApk installedApk, ClassLoader parent) {
            super(installedApk.apkFilePath, installedApk.oDexPath != null ? new File(installedApk.oDexPath) : null, installedApk.libraryPath, parent);
            this.containerKey = containerKey;
            this.apkFilePath = installedApk.apkFilePath;
        }
    }
}

