/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.dynamic.host;

import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import com.tencent.shadow.dynamic.host.BinderUuidManager;
import com.tencent.shadow.dynamic.host.FailedException;
import com.tencent.shadow.dynamic.host.MultiLoaderPluginProcessService;
import com.tencent.shadow.dynamic.host.PpsStatus;
import com.tencent.shadow.dynamic.host.UuidManager;

public class MultiLoaderPpsBinder
extends Binder {
    static final String DESCRIPTOR = MultiLoaderPpsBinder.class.getName();
    static final int TRANSACTION_CODE_NO_EXCEPTION = 0;
    static final int TRANSACTION_CODE_FAILED_EXCEPTION = 1;
    static final int TRANSACTION_loadRuntimeForPlugin = 1;
    static final int TRANSACTION_loadPluginLoaderForPlugin = 2;
    static final int TRANSACTION_setUuidManagerForPlugin = 3;
    static final int TRANSACTION_getPpsStatusForPlugin = 4;
    static final int TRANSACTION_getPluginLoaderForPlugin = 5;
    static final int TRANSACTION_exit = 6;
    private final MultiLoaderPluginProcessService mPps;

    MultiLoaderPpsBinder(MultiLoaderPluginProcessService pps) {
        this.mPps = pps;
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) {
        switch (code) {
            case 1598968902: {
                reply.writeString(DESCRIPTOR);
                return true;
            }
            case 1: {
                data.enforceInterface(DESCRIPTOR);
                String _arg0 = data.readString();
                String _arg1 = data.readString();
                try {
                    this.mPps.loadRuntimeForPlugin(_arg0, _arg1);
                    reply.writeInt(0);
                }
                catch (FailedException e) {
                    reply.writeInt(1);
                    e.writeToParcel(reply, 0);
                }
                return true;
            }
            case 2: {
                data.enforceInterface(DESCRIPTOR);
                String _arg0 = data.readString();
                String _arg1 = data.readString();
                try {
                    this.mPps.loadPluginLoaderForPlugin(_arg0, _arg1);
                    reply.writeInt(0);
                }
                catch (FailedException e) {
                    reply.writeInt(1);
                    e.writeToParcel(reply, 0);
                }
                return true;
            }
            case 3: {
                data.enforceInterface(DESCRIPTOR);
                String _arg0 = data.readString();
                IBinder iBinder = data.readStrongBinder();
                BinderUuidManager uuidManager = iBinder != null ? new BinderUuidManager(iBinder) : null;
                this.mPps.setUuidManagerForPlugin(_arg0, (UuidManager)uuidManager);
                reply.writeNoException();
                return true;
            }
            case 4: {
                data.enforceInterface(DESCRIPTOR);
                String _arg0 = data.readString();
                PpsStatus ppsStatus = this.mPps.getPpsStatusForPlugin(_arg0);
                reply.writeNoException();
                ppsStatus.writeToParcel(reply, 1);
                return true;
            }
            case 5: {
                data.enforceInterface(DESCRIPTOR);
                String _arg0 = data.readString();
                IBinder pluginLoader = this.mPps.getPluginLoaderForPlugin(_arg0);
                reply.writeNoException();
                reply.writeStrongBinder(pluginLoader);
                return true;
            }
            case 6: {
                data.enforceInterface(DESCRIPTOR);
                this.mPps.exit();
                reply.writeNoException();
                return true;
            }
        }
        return false;
    }
}

