/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.aircert.bean.UploadErrorInfo;
import com.xdja.aircert.common.R;
import com.xdja.aircert.device.CertDetailInfo;
import com.xdja.aircert.device.DeviceWrapper;
import com.xdja.aircert.device.PKCS10ForSM2Utils;
import com.xdja.aircert.invoke.Apply;
import com.xdja.aircert.net.CertService;
import com.xdja.aircert.net.ChipExecutorService;
import com.xdja.aircert.net.HttpResponseCallBack;
import com.xdja.aircert.net_bean.BaseErrorResponse;
import com.xdja.aircert.request.ApplyCertRequest;
import com.xdja.aircert.request.GetDNRequest;
import com.xdja.aircert.request.QueryStateRequest;
import com.xdja.aircert.request.UploadErrorRequest;
import com.xdja.aircert.response.ApplyCertResponse;
import com.xdja.aircert.response.GetDNResponse;
import com.xdja.aircert.response.QueryStateResponse;
import com.xdja.aircert.response.UploadErrorReponse;
import com.xdja.aircert.util.CryptoDevTypeUtil;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import okhttp3.Call;

public class MainActivity
extends Activity
implements View.OnClickListener {
    static CryptoDevType cardType = null;
    Button apply;
    Button btSync;
    TextView cardSN;
    TextView btState;
    TextView certContent;
    Button queryState;
    TextView btApplySuccess;
    TextView btSN;
    ChipExecutorService chipExecutorService = new ChipExecutorService();
    CertService service = new CertService();
    static String cardNum;
    boolean enableBT;
    private String bleP10;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_main);
        this.initView();
        this.showCurrentSN();
        this.initBTIfNeeded();
    }

    private void initBTIfNeeded() {
        if (this.enableBT) {
            // empty if block
        }
    }

    private void initView() {
        this.apply = (Button)this.findViewById(R.id.apply);
        this.apply.setOnClickListener((View.OnClickListener)this);
        this.btSync = (Button)this.findViewById(R.id.bt_sync);
        this.btSync.setOnClickListener((View.OnClickListener)this);
        this.cardSN = (TextView)this.findViewById(R.id.card_sn);
        this.btState = (TextView)this.findViewById(R.id.bt_state);
        this.certContent = (TextView)this.findViewById(R.id.cert_content);
        this.queryState = (Button)this.findViewById(R.id.query_state);
        this.queryState.setOnClickListener((View.OnClickListener)this);
        this.btApplySuccess = (TextView)this.findViewById(R.id.bt_apply_success);
        this.btSN = (TextView)this.findViewById(R.id.bt_sn);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.apply) {
            Apply.start(new Apply.ApplyResultCallback(){

                @Override
                public void result(String errorCode) {
                    if (errorCode.equals("0")) {
                        // empty if block
                    }
                }
            });
            Apply.start(new Apply.ApplyResultCallback(){

                @Override
                public void result(String errorCode) {
                }
            });
        } else if (id2 == R.id.bt_sync) {
            this.sync();
        } else if (id2 == R.id.query_state) {
            this.queryCertState();
        }
    }

    private boolean valid() {
        return cardType != null && !TextUtils.isEmpty((CharSequence)cardNum);
    }

    private List<CryptoDevInfo> getDeviceList() {
        ArrayList<CryptoDevInfo> beans = new ArrayList<CryptoDevInfo>();
        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getDevInfo();
        if (devInfoMap == null || devInfoMap.size() == 0) {
            return beans;
        }
        for (Map.Entry<Integer, CryptoDevInfo> cryptoDevInfoEntry : devInfoMap.entrySet()) {
            beans.add(cryptoDevInfoEntry.getValue());
        }
        return beans;
    }

    public void showToast(String infName, String msg) {
    }

    private void getDN(final int bleType) {
        GetDNRequest request = new GetDNRequest();
        request.setCardType(String.valueOf(CryptoDevTypeUtil.convertCardType(cardType.getType())));
        this.service.getDN(request, cardNum, new HttpResponseCallBack<GetDNResponse>(){

            @Override
            public void onOtherException(Exception e) {
                MainActivity.this.showToast("getDN", "other");
            }

            @Override
            public void onIoException(Call call, IOException e) {
                MainActivity.this.showToast("getDN", "IO E");
            }

            @Override
            public void onSuccessfulResponse(Call call, GetDNResponse getDNResponse) {
                String result = getDNResponse.getResult();
                if (result.equals("0")) {
                    String dn = getDNResponse.getMessage();
                    Log.e((String)"jff", (String)("190 MainActivity onSuccessfulResponse \u662f\u5426\u662f\u84dd\u7259\u8bbe\u5907: " + bleType));
                    Log.e((String)"jff", (String)"163 MainActivity onSuccessfulResponse : dn success");
                    if (bleType == 1) {
                        MainActivity.this.getBleSignData(dn);
                    } else {
                        MainActivity.this.apply(dn, bleType, "");
                    }
                } else if (result.equals("1")) {
                    MainActivity.this.showToast("getDN", "dn\u83b7\u53d6\u5931\u8d25");
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                MainActivity.this.showToast("getDN", "fail");
            }
        });
    }

    private void showCurrentSN() {
        List<CryptoDevInfo> list = this.getDeviceList();
        for (CryptoDevInfo info : list) {
            Log.e((String)"jff", (String)String.valueOf(info.getType().getType()));
            if (info.getType().getType() != CryptoDevType.DEV_TYPE_SimKey.getType()) continue;
            cardNum = info.getCardId();
            cardType = CryptoDevType.DEV_TYPE_SimKey;
            CertDetailInfo certDetailInfo = DeviceWrapper.readCertFromContainer(cardType, 0);
            if (certDetailInfo == null) {
                this.cardSN.setText((CharSequence)"\u5361\u5185\u65e0\u8bc1\u4e66");
                break;
            }
            String sn = certDetailInfo.sn;
            StringBuilder sb = new StringBuilder();
            sb.append("\u52a0\u5bc6\u8bbe\u5907\u7b7e\u540d\u8bc1\u4e66sn\uff1a");
            sb.append("\n");
            sb.append(sn);
            this.cardSN.setText((CharSequence)sb.toString());
            Log.e((String)"jff", (String)sn);
        }
    }

    private void getBleSignData(String dn) {
        PKCS10ForSM2Utils.getInstance().sendBleWaitSignData(dn);
    }

    private void apply(String dn, final int bleType, String p10) {
        if (bleType == 0) {
            p10 = PKCS10ForSM2Utils.getInstance().getP10RequestBC(cardType, dn, true);
        }
        ApplyCertRequest request = new ApplyCertRequest();
        request.setCardType("" + CryptoDevTypeUtil.convertCardType(cardType.getType()));
        request.setP10(p10);
        Log.e((String)"jff", (String)("219 MainActivity apply cardNum : " + cardNum));
        this.service.applyCert(request, cardNum, new HttpResponseCallBack<ApplyCertResponse>(){

            @Override
            public void onOtherException(Exception e) {
                MainActivity.this.showToast("apply", "other");
            }

            @Override
            public void onIoException(Call call, IOException e) {
                MainActivity.this.showToast("apply", "io E");
            }

            @Override
            public void onSuccessfulResponse(Call call, ApplyCertResponse applyCertResponse) {
                Toast.makeText((Context)MainActivity.this, (CharSequence)"\u7533\u8bf7\u6210\u529f", (int)0).show();
                String cert = applyCertResponse.getCert();
                Log.e((String)"jff", (String)("235 MainActivity onSuccessfulResponse : " + cert));
                if (bleType == 0) {
                    MainActivity.this.writeCert(cert);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                MainActivity.this.showToast("apply", "fail");
                Log.e((String)"jff", (String)("239 MainActivity onFailResponse : " + baseErrorResponse.getMessage()));
            }
        });
    }

    private void writeCert(final String cert) {
        if (TextUtils.isEmpty((CharSequence)cert)) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int result = DeviceWrapper.importCert(cardType, cert);
                if (result == 0) {
                    MainActivity.this.showToast("\u5199\u5361\u6210\u529f", "");
                    Log.e((String)"jff", (String)"269 MainActivity run \u5199\u5361\u6210\u529f");
                    MainActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MainActivity.this.showCurrentSN();
                        }
                    });
                } else {
                    if (result == -4) {
                        // empty if block
                    }
                    MainActivity.this.writeCertToServer(cert, "1");
                }
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private void writeCertToServer(final String cert, final String status) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                String sn = DeviceWrapper.getSn(cardType, cert);
                UploadErrorInfo info = new UploadErrorInfo();
                info.setSn(sn);
                info.setStatus(status);
                info.setTime(System.currentTimeMillis());
                String sign = DeviceWrapper.signData(cardType, info.toString());
                UploadErrorRequest request = new UploadErrorRequest();
                request.setCardType(String.valueOf(CryptoDevTypeUtil.convertCardType(cardType.getType())));
                request.setSign(sign);
                request.setInfo(info);
                MainActivity.this.uploadError(request);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private void uploadError(UploadErrorRequest request) {
        this.service.uploadError(request, cardNum, new HttpResponseCallBack<UploadErrorReponse>(){

            @Override
            public void onOtherException(Exception e) {
                MainActivity.this.showToast("upload", "other");
            }

            @Override
            public void onIoException(Call call, IOException e) {
                MainActivity.this.showToast("upload", "io E");
            }

            @Override
            public void onSuccessfulResponse(Call call, UploadErrorReponse uploadErrorReponse) {
                MainActivity.this.showToast("upload", "\u4e0a\u62a5\u6210\u529f");
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                MainActivity.this.showToast("upload", "fail");
            }
        });
    }

    private void queryCertState() {
        CertDetailInfo info;
        if (cardType == null) {
            cardType = this.getDeviceList().get(0).getType();
        }
        if (TextUtils.isEmpty((CharSequence)cardNum)) {
            cardNum = DeviceWrapper.getCardNum(cardType);
        }
        if ((info = DeviceWrapper.readCertFromContainer(cardType, 0)) == null) {
            return;
        }
        String sn = info.sn;
        QueryStateRequest request = new QueryStateRequest();
        request.setSn(sn);
        this.service.queryState(request, cardNum, new HttpResponseCallBack<QueryStateResponse>(){

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoException(Call call, IOException e) {
            }

            @Override
            public void onSuccessfulResponse(Call call, QueryStateResponse queryStateResponse) {
                String state = queryStateResponse.getResult();
                if (state.equals("1")) {
                    MainActivity.this.deleteLocalCert();
                } else {
                    Toast.makeText((Context)MainActivity.this, (CharSequence)state, (int)0).show();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
            }
        });
    }

    private void deleteLocalCert() {
        int result = DeviceWrapper.clearContainer(cardType);
        if (result == 0) {
            this.showCurrentSN();
        }
    }

    private void sync() {
    }

    private String getCardNum(CryptoDevType type) {
        return DeviceWrapper.getCardNum(type);
    }

    public void sendFirstCmd() {
        cardType = CryptoDevType.DEV_TYPE_Chip;
    }

    public void sendSecondCmd() {
    }

    public void sendThirdCmd(byte[] waitSignData) {
    }
}

