/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.device;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.aircert.config.AppConfig;
import com.xdja.aircert.device.CertDetailInfo;
import com.xdja.aircert.device.CertSKF;
import com.xdja.aircert.device.FidUtil;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.multichip.param.CertBean;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class DeviceWrapper {
    private static void scanningDevice() {
        boolean isScanningDevice = CryptoDevManager.getInstance().isScanning();
        while (isScanningDevice) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            isScanningDevice = CryptoDevManager.getInstance().isScanning();
        }
    }

    public static Map<Integer, CryptoDevInfo> getDevInfo() {
        DeviceWrapper.scanningDevice();
        HashMap<Integer, CryptoDevInfo> infoMap = new HashMap<Integer, CryptoDevInfo>();
        List<CryptoDevInfo> devList = DeviceWrapper.getDeviceList();
        if (devList == null || devList.size() <= 0) {
            return null;
        }
        for (CryptoDevInfo devInfo : devList) {
            switch (devInfo.getType()) {
                case DEV_TYPE_SdCard: {
                    CryptoDevInfo sdDev = devInfo;
                    infoMap.put(CryptoDevType.DEV_TYPE_SdCard.getType(), sdDev);
                    break;
                }
                case DEV_TYPE_Chip: {
                    CryptoDevInfo chipDev = devInfo;
                    infoMap.put(CryptoDevType.DEV_TYPE_Chip.getType(), chipDev);
                    break;
                }
                case DEV_TYPE_SimKey: {
                    CryptoDevInfo simKeyDev = devInfo;
                    infoMap.put(CryptoDevType.DEV_TYPE_SimKey.getType(), simKeyDev);
                    break;
                }
                case DEV_TYPE_Soft: {
                    CryptoDevInfo softDev = devInfo;
                    infoMap.put(CryptoDevType.DEV_TYPE_Soft.getType(), softDev);
                }
            }
        }
        return infoMap;
    }

    private static List<CryptoDevInfo> getDeviceList() {
        List devList = CryptoDevManager.getInstance().getCryptoDevInfos();
        if (devList.size() <= 0) {
            return null;
        }
        return devList;
    }

    private static CertSKF splitCertStr(CryptoDevType type, String certStr) {
        if (certStr.equals("") || certStr.length() <= 0) {
            return null;
        }
        certStr = certStr.replaceAll("\r", "");
        certStr = certStr.replaceAll("\n", "");
        certStr = certStr.replaceAll("-----BEGIN CERTIFICATE-----", "");
        certStr = certStr.replaceAll("-----END CERTIFICATE-----", "");
        String[] pieces = certStr.split("#");
        CertSKF certSKF = new CertSKF();
        switch (pieces.length) {
            case 4: {
                if (!TextUtils.isEmpty((CharSequence)pieces[0])) {
                    certSKF.setSignCert(Base64.decode((byte[])pieces[0].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[1])) {
                    certSKF.setEnCodeCert(Base64.decode((byte[])pieces[1].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[2])) {
                    certSKF.setKeyPair(Base64.decode((byte[])pieces[2].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[3])) {
                    certSKF.setProjectLabel(pieces[3]);
                }
                certSKF.setLen(4);
            }
        }
        return certSKF;
    }

    public static int importCert(CryptoDevType type, String certStr) {
        CertSKF certSKF = DeviceWrapper.splitCertStr(type, certStr);
        if (certSKF == null) {
            return -1;
        }
        if (certSKF.getErrorCode() == 4) {
            return -4;
        }
        String pin = AppConfig.getInstance().getPin();
        int role = 1;
        int containerNo = 0;
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        CertBean bean = CertBean.createDoubleSM2CertSkf((int)role, (String)pin, (int)containerNo, (byte[])certSKF.getSignCert(), (byte[])certSKF.getEnCodeCert(), (byte[])certSKF.getKeyPair());
        int importCertRet = cryptoInstance.importCert(bean);
        if (importCertRet != 0) {
            return importCertRet;
        }
        int writeProjectLabelRet = DeviceWrapper.writeProjectLabel(type, certSKF.getProjectLabel());
        if (writeProjectLabelRet != 0) {
            return writeProjectLabelRet;
        }
        return 0;
    }

    protected static CryptoInstance getCryptoInstance(CryptoDevType type) {
        CryptoInstance cryptoDev;
        DeviceWrapper.scanningDevice();
        try {
            cryptoDev = CryptoDevManager.getInstance().createInstance("ChipManager-key", type);
        }
        catch (Exception e) {
            return null;
        }
        if (cryptoDev == null) {
            return null;
        }
        int result = cryptoDev.open();
        if (result != 0) {
            return null;
        }
        return cryptoDev;
    }

    private static int writeProjectLabel(CryptoDevType type, String labStr) {
        byte[] labelFid = new byte[]{0, -97};
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        byte[] labStrBytes = labStr.getBytes();
        int writeLabel = -1;
        int createRet = DeviceWrapper.createFile(type);
        if (createRet == 0 || createRet == -23) {
            writeLabel = cryptoInstance.writeFile(labelFid, 0, 64, labStrBytes);
        }
        return writeLabel;
    }

    private static int createFile(CryptoDevType type) {
        byte[] labelFid = new byte[]{0, -97};
        XDJA_FILE file = new XDJA_FILE();
        file.read_Acl = (byte)-15;
        file.write_Acl = (byte)-15;
        file.room = (short)512;
        file.type = 1;
        file.id = labelFid;
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        int ret = cryptoInstance.createFile(file);
        return ret;
    }

    public static int verifyPin(CryptoDevType type, String pinInput) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        AppConfig module = AppConfig.getInstance();
        String pin = pinInput.isEmpty() ? module.getPin() : pinInput;
        int result = cryptoInstance.verifyPIN(pin, 1);
        return result;
    }

    public static String getSn(CryptoDevType type, String certStr) {
        int encodeCertLen;
        int[] enCodeCertLen;
        byte[] encodeCert;
        CertSKF certSKF = DeviceWrapper.splitCertStr(type, certStr);
        if (certSKF == null) {
            return "";
        }
        byte[][] fid = FidUtil.getCertFid(0);
        CertDetailInfo info = DeviceWrapper.readBytesToCert(fid[1], encodeCert, enCodeCertLen = new int[]{encodeCertLen = (encodeCert = certSKF.getEnCodeCert()) != null ? encodeCert.length : 0});
        if (info == null) {
            return "";
        }
        return info.sn;
    }

    private static CertDetailInfo readBytesToCert(byte[] fid, byte[] certBuf, int[] certLen) {
        if (fid.length == 0 || certBuf.length == 0 || certLen.length == 0) {
            return null;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd");
            SimpleDateFormat formatterValid = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
            ByteArrayInputStream bin = new ByteArrayInputStream(certBuf);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(bin);
            CertDetailInfo certDetailInfo = new CertDetailInfo();
            certDetailInfo.issuerOrg = cert.getIssuerX500Principal().getName();
            certDetailInfo.issuerCn = cert.getIssuerDN().getName();
            certDetailInfo.subjectOrg = cert.getSubjectX500Principal().getName();
            certDetailInfo.subjectCn = cert.getSubjectDN().getName();
            certDetailInfo.alg = cert.getSigAlgName();
            certDetailInfo.ver = cert.getVersion();
            System.arraycopy(fid, 0, certDetailInfo.certId, 0, 2);
            certDetailInfo.indate = formatter.format(cert.getNotBefore()) + " - " + formatter.format(cert.getNotAfter());
            certDetailInfo.notBefore = cert.getNotBefore();
            certDetailInfo.notAfter = cert.getNotAfter();
            certDetailInfo.sn = cert.getSerialNumber().toString(16);
            certDetailInfo.certLen = certLen;
            bin.close();
            return certDetailInfo;
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String signData(CryptoDevType type, String str) {
        if (str.equals("")) {
            return null;
        }
        byte[][] keyPair = FidUtil.getKeyPairFid(0);
        byte[] pubFid = keyPair[0];
        byte[] priFid = keyPair[1];
        int[] signDataLen = new int[1];
        byte[] certInfoBytes = str.getBytes();
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        AppConfig module = AppConfig.getInstance();
        int ret = DeviceWrapper.verifyPin(type, module.getPin());
        if (ret != 0) {
            return "errorCode" + CryptoDevManager.getInstance().getErrorText(ret);
        }
        byte[] signData = new byte[64];
        ret = cryptoInstance.SM2Sign(pubFid, priFid, 1, certInfoBytes, certInfoBytes.length, signData, signDataLen);
        byte[] data = new byte[signDataLen[0]];
        System.arraycopy(signData, 0, data, 0, data.length);
        if (ret == 0) {
            return new String(Base64.encode((byte[])data));
        }
        return null;
    }

    public static String getCardNum(CryptoDevType type) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        String cardId = cryptoInstance.getCardId();
        cryptoInstance.close();
        return cardId;
    }

    public static int clearContainer(CryptoDevType type) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        byte[] labelFid = new byte[]{0, -97};
        AppConfig module = AppConfig.getInstance();
        int ret = cryptoInstance.verifyPIN(module.getPin(), 1);
        if (ret == 0) {
            ret = cryptoInstance.clearContainer(1, module.getPin(), 0);
        }
        return ret;
    }

    public static CertDetailInfo readCertFromContainer(CryptoDevType type, int containerNo) {
        byte[] fid = null;
        byte[][] certFid = FidUtil.getCertFid(containerNo);
        fid = certFid[0];
        return DeviceWrapper.readCertFromFid(type, fid);
    }

    private static CertDetailInfo readCertFromFid(CryptoDevType type, byte[] fid) {
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        byte[] bytes = DeviceWrapper.readCertBytes(type, fid, certBuf, certLen);
        if (bytes == null) {
            return null;
        }
        return DeviceWrapper.readBytesToCert(fid, certBuf, certLen);
    }

    public static byte[] readCertBytes(CryptoDevType type, byte[] fid, byte[] certBuf, int[] certLen) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        int result = cryptoInstance.readCert(fid, certBuf, certLen);
        cryptoInstance.close();
        if (result != 0) {
            return null;
        }
        return certBuf;
    }

    public static boolean verifyCertByRoot(Context context, CryptoDevType type, int containerNo) {
        Principal principalSubject;
        BouncyCastleProvider provider = new BouncyCastleProvider();
        Security.removeProvider("BC");
        Security.addProvider((Provider)provider);
        X509Certificate cert = DeviceWrapper.getX509Certificate(DeviceWrapper.readCertFromType(type, containerNo), provider);
        X509Certificate root = DeviceWrapper.getX509Certificate(DeviceWrapper.readRootCertFromAssets("root.cer"), provider);
        if (cert == null || root == null) {
            return false;
        }
        Principal principalIssuer = cert.getIssuerDN();
        if (!principalIssuer.equals(principalSubject = root.getSubjectDN())) {
            return false;
        }
        try {
            cert.verify(root.getPublicKey());
            return true;
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static InputStream readCertFromType(CryptoDevType type, int containerNo) {
        byte[][] fid = FidUtil.getCertFid(containerNo);
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        int result = -1;
        result = cryptoInstance.readCert(fid[0], certBuf, certLen);
        result = cryptoInstance.readCert(fid[1], certBuf, certLen);
        cryptoInstance.close();
        if (result == 0) {
            return new ByteArrayInputStream(certBuf);
        }
        return null;
    }

    public static X509Certificate getX509Certificate(InputStream is, BouncyCastleProvider provider) {
        if (is == null) {
            return null;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", (Provider)provider);
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(is);
            is.close();
            return certificate;
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static InputStream readRootCertFromAssets(String fileName) {
        Context context = AppConfig.getInstance().getContext();
        AssetManager assetManager = context.getAssets();
        try {
            return assetManager.open(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

