/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.invoke;

import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.aircert.bean.UploadErrorInfo;
import com.xdja.aircert.device.CertDetailInfo;
import com.xdja.aircert.device.DeviceWrapper;
import com.xdja.aircert.device.PKCS10ForSM2Utils;
import com.xdja.aircert.net.CertService;
import com.xdja.aircert.net.ChipExecutorService;
import com.xdja.aircert.net.HttpResponseCallBack;
import com.xdja.aircert.net_bean.BaseErrorResponse;
import com.xdja.aircert.request.ApplyCertRequest;
import com.xdja.aircert.request.GetDNRequest;
import com.xdja.aircert.request.UploadErrorRequest;
import com.xdja.aircert.response.ApplyCertResponse;
import com.xdja.aircert.response.GetDNResponse;
import com.xdja.aircert.response.UploadErrorReponse;
import com.xdja.aircert.util.CryptoDevTypeUtil;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import okhttp3.Call;

public class Apply {
    static CryptoDevType cardType = CryptoDevType.DEV_TYPE_Chip;

    public static void start(final ApplyResultCallback callback) {
        final String cardNum = Apply.getCardNum();
        if (TextUtils.isEmpty((CharSequence)cardNum)) {
            callback.result("-2");
            return;
        }
        if (cardNum.equals("-3")) {
            callback.result("-3");
            return;
        }
        if (cardNum.equals("-4")) {
            callback.result("-4");
            return;
        }
        final CertService service = new CertService();
        GetDNRequest request = new GetDNRequest();
        request.setCardType(String.valueOf(CryptoDevTypeUtil.convertCardType(CryptoDevType.DEV_TYPE_SimKey.getType())));
        service.getDN(request, cardNum, new HttpResponseCallBack<GetDNResponse>(){

            @Override
            public void onOtherException(Exception e) {
                callback.result("-1");
            }

            @Override
            public void onIoException(Call call, IOException e) {
                callback.result("-11");
            }

            @Override
            public void onSuccessfulResponse(Call call, GetDNResponse getDNResponse) {
                String result = getDNResponse.getResult();
                if (result.equals("0")) {
                    String dn = getDNResponse.getMessage();
                    String p10 = PKCS10ForSM2Utils.getInstance().getP10RequestBC(cardType, dn, true);
                    ApplyCertRequest request = new ApplyCertRequest();
                    request.setCardType("" + CryptoDevTypeUtil.convertCardType(cardType.getType()));
                    request.setP10(p10);
                    Log.e((String)"jff", (String)("219 MainActivity apply cardNum : " + cardNum));
                    service.applyCert(request, cardNum, new HttpResponseCallBack<ApplyCertResponse>(){

                        @Override
                        public void onOtherException(Exception e) {
                            callback.result("-1");
                        }

                        @Override
                        public void onIoException(Call call, IOException e) {
                            callback.result("-21");
                        }

                        @Override
                        public void onSuccessfulResponse(Call call, ApplyCertResponse applyCertResponse) {
                            final String cert = applyCertResponse.getCert();
                            Log.e((String)"jff", (String)("235 MainActivity onSuccessfulResponse : " + cert));
                            if (TextUtils.isEmpty((CharSequence)cert)) {
                                return;
                            }
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    int result = DeviceWrapper.importCert(cardType, cert);
                                    if (result == 0) {
                                        callback.result("0");
                                        Log.e((String)"jff", (String)"269 MainActivity run \u5199\u5361\u6210\u529f");
                                    } else {
                                        if (result == -4) {
                                            // empty if block
                                        }
                                        Runnable runnable = new Runnable(){

                                            @Override
                                            public void run() {
                                                Looper.prepare();
                                                String sn = DeviceWrapper.getSn(cardType, cert);
                                                UploadErrorInfo info = new UploadErrorInfo();
                                                info.setSn(sn);
                                                info.setStatus("1");
                                                info.setTime(System.currentTimeMillis());
                                                String sign = DeviceWrapper.signData(cardType, info.toString());
                                                final UploadErrorRequest request = new UploadErrorRequest();
                                                request.setCardType(String.valueOf(CryptoDevTypeUtil.convertCardType(cardType.getType())));
                                                request.setSign(sign);
                                                request.setInfo(info);
                                                service.uploadError(request, cardNum, new HttpResponseCallBack<UploadErrorReponse>(){

                                                    @Override
                                                    public void onOtherException(Exception e) {
                                                        callback.result("-1");
                                                    }

                                                    @Override
                                                    public void onIoException(Call call, IOException e) {
                                                        callback.result("-34");
                                                    }

                                                    @Override
                                                    public void onSuccessfulResponse(Call call, UploadErrorReponse uploadErrorReponse) {
                                                        String result = uploadErrorReponse.getResult();
                                                        if (result.equals("0")) {
                                                            callback.result("-31");
                                                        } else if (((Object)((Object)request)).equals("1")) {
                                                            callback.result("-32");
                                                        }
                                                    }

                                                    @Override
                                                    public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                                                        callback.result("-33");
                                                    }
                                                });
                                            }
                                        };
                                        ChipExecutorService chipExecutorService = new ChipExecutorService();
                                        chipExecutorService.exe(runnable);
                                    }
                                }
                            };
                            ChipExecutorService service = new ChipExecutorService();
                            service.exe(runnable);
                        }

                        @Override
                        public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                            String errorCode = baseErrorResponse.getErrCode();
                            callback.result(errorCode);
                        }
                    });
                } else if (result.equals("1")) {
                    callback.result("-12");
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
            }
        });
    }

    private static String getCardNum() {
        List<CryptoDevInfo> list = Apply.getDeviceList();
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            return "-3";
        }
        for (CryptoDevInfo info : list) {
            Log.e((String)"jff", (String)String.valueOf(info.getType().getType()));
            if (info.getType().getType() != cardType.getType()) continue;
            String cardNum = info.getCardId();
            CertDetailInfo certDetailInfo = DeviceWrapper.readCertFromContainer(cardType, 0);
            if (certDetailInfo != null) {
                String certSN = certDetailInfo.sn;
                Log.e((String)"jff", (String)certSN);
                cardNum = "-4";
                break;
            }
            return cardNum;
        }
        return null;
    }

    private static List<CryptoDevInfo> getDeviceList() {
        ArrayList<CryptoDevInfo> beans = new ArrayList<CryptoDevInfo>();
        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getDevInfo();
        if (devInfoMap == null || devInfoMap.size() == 0) {
            return beans;
        }
        for (Map.Entry<Integer, CryptoDevInfo> cryptoDevInfoEntry : devInfoMap.entrySet()) {
            beans.add(cryptoDevInfoEntry.getValue());
        }
        return beans;
    }

    public static interface ApplyResultCallback {
        public void result(String var1);
    }
}

