/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.net;

import android.os.Message;
import com.alibaba.fastjson.JSON;
import com.xdja.aircert.common.R;
import com.xdja.aircert.config.AppConfig;
import com.xdja.aircert.exception.CardNotExistException;
import com.xdja.aircert.net.ChipExecutorService;
import com.xdja.aircert.net.HttpClientHelper;
import com.xdja.aircert.net.RequestCallback;
import com.xdja.aircert.net.WeakReferenceHandler;
import com.xdja.https.module.bean.HttpsParam;
import java.io.IOException;
import java.util.concurrent.Callable;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class CertRequest {
    private String url;
    private String cardNo;
    private RequestBody body;
    private RequestCallback certCallback;
    private static final int CARD_EXCEPTION = -3;
    private static final int OTHER_EXCEPTION = -2;
    private static final int IOE_EXCEPTION = -1;
    private static final int RESPONSE_OK = 0;
    private static final int SEND_HTTPSPARAM = 1;
    private MyHandler myHandler = new MyHandler(this);
    private ChipExecutorService chipExecutorService = new ChipExecutorService();

    public CertRequest(String url, String cardNo, RequestBody body, RequestCallback callback) {
        this.url = url;
        this.cardNo = cardNo;
        this.body = body;
        this.certCallback = callback;
    }

    private Request initRequest(String url, String cardNo, RequestBody body) {
        if (cardNo == null) {
            return null;
        }
        Request.Builder builder = new Request.Builder();
        builder.addHeader("Content-Type", "application/json").addHeader("cardNo", cardNo).addHeader("clientTime", String.valueOf(System.currentTimeMillis())).url(url);
        if (body != null) {
            MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
            String jsonStr = JSON.toJSONString((Object)body);
            body = RequestBody.create((MediaType)mediaType, (String)jsonStr);
            builder.post(body);
        }
        return builder.build();
    }

    public void request() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Request request = CertRequest.this.initRequest(CertRequest.this.url, CertRequest.this.cardNo, CertRequest.this.body);
                if (request == null) {
                    CertRequest.this.chipExecutorService.sendMessage(CertRequest.this.myHandler, -3, null);
                    return;
                }
                OkHttpClient client = HttpClientHelper.getOkHttpClient();
                Call call = client.newCall(request);
                try {
                    Response response = call.execute();
                    ResponseInner responseInner = new ResponseInner();
                    responseInner.call = call;
                    responseInner.isSuccessful = response.isSuccessful();
                    responseInner.response = response.body().string();
                    CertRequest.this.chipExecutorService.sendMessage(CertRequest.this.myHandler, 0, responseInner);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    e.printStackTrace();
                    Failure failure = new Failure();
                    failure.call = call;
                    failure.e = e;
                    CertRequest.this.chipExecutorService.sendMessage(CertRequest.this.myHandler, -1, failure);
                }
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private int testRequest() throws Exception {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return 0;
            }
        };
        return (Integer)callable.call();
    }

    private int test() {
        Request request = this.initRequest(this.url, this.cardNo, this.body);
        OkHttpClient client = HttpClientHelper.getOkHttpClient();
        Call call = client.newCall(request);
        try {
            Response response = call.execute();
            ResponseInner responseInner = new ResponseInner();
            responseInner.call = call;
            responseInner.isSuccessful = response.isSuccessful();
            responseInner.response = response.body().string();
            this.chipExecutorService.sendMessage(this.myHandler, 0, responseInner);
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace();
            Failure failure = new Failure();
            failure.call = call;
            failure.e = e;
            this.chipExecutorService.sendMessage(this.myHandler, -1, failure);
            return 1;
        }
    }

    private void doRequest(Request request, HttpsParam httpsParam) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private HttpsParam generateHttpsParam() {
        HttpsParam httpsParam = new HttpsParam();
        httpsParam.setSupportHttps(true);
        httpsParam.setServerCertAccessPwd(AppConfig.getInstance().getBksVerifyCode().toCharArray());
        httpsParam.setServerCertInputStream(AppConfig.getInstance().getContext().getResources().openRawResource(R.raw.truststore));
        return httpsParam;
    }

    private class ResponseInner {
        Call call;
        String response;
        boolean isSuccessful;

        private ResponseInner() {
        }
    }

    private class Failure {
        Call call;
        IOException e;

        private Failure() {
        }
    }

    private static class MyHandler
    extends WeakReferenceHandler<CertRequest> {
        public MyHandler(CertRequest reference) {
            super(reference);
        }

        @Override
        protected void handleMessage(CertRequest reference, Message msg) {
            int what = msg.what;
            if (what == 0) {
                ResponseInner responseInner = (ResponseInner)msg.obj;
                reference.certCallback.onResponse(responseInner.call, responseInner.isSuccessful, responseInner.response);
            } else if (what == -1) {
                Failure failure = (Failure)msg.obj;
                reference.certCallback.onFailure(failure.call, failure.e);
            } else if (what == -3) {
                reference.certCallback.onException(new CardNotExistException());
            } else {
                Exception e = (Exception)msg.obj;
                reference.certCallback.onException(e);
            }
        }
    }
}

