/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.net;

import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.aircert.net.CertRequest;
import com.xdja.aircert.net.HttpResponseCallBack;
import com.xdja.aircert.net.RequestCallback;
import com.xdja.aircert.net_bean.BaseErrorResponse;
import com.xdja.aircert.request.ApplyCertRequest;
import com.xdja.aircert.request.GetDNRequest;
import com.xdja.aircert.request.QueryStateRequest;
import com.xdja.aircert.request.UploadErrorRequest;
import com.xdja.aircert.response.ApplyCertResponse;
import com.xdja.aircert.response.GetDNResponse;
import com.xdja.aircert.response.QueryStateResponse;
import com.xdja.aircert.response.UploadErrorReponse;
import java.io.IOException;
import okhttp3.Call;

public class CertService {
    private static String CLOUD_HOST;

    public CertService() {
        String ip = "11.12.86.59";
        String port = "8443";
        CLOUD_HOST = "https://" + ip + ":" + port + "/airIssue";
    }

    public void getDN(GetDNRequest body, String cardNum, final HttpResponseCallBack<GetDNResponse> callBack) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoException(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    GetDNResponse result = (GetDNResponse)JSONObject.parseObject((String)response, GetDNResponse.class);
                    callBack.onSuccessfulResponse(call, result);
                } else {
                    BaseErrorResponse error = (BaseErrorResponse)JSONObject.parseObject((String)response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, error);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/cert/getDn";
        CertRequest certRequest = new CertRequest(url, cardNum, body, certCallback);
        certRequest.request();
    }

    public void applyCert(ApplyCertRequest body, String cardNum, final HttpResponseCallBack<ApplyCertResponse> callBack) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoException(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                Log.e((String)"jff", (String)("105 CertService applyCert success : " + response));
                if (isSuccessful) {
                    ApplyCertResponse result = (ApplyCertResponse)JSONObject.parseObject((String)response, ApplyCertResponse.class);
                    callBack.onSuccessfulResponse(call, result);
                } else {
                    BaseErrorResponse error = (BaseErrorResponse)JSONObject.parseObject((String)response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, error);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/cert/application";
        CertRequest certRequest = new CertRequest(url, cardNum, body, certCallback);
        certRequest.request();
    }

    public void uploadError(UploadErrorRequest body, String cardNum, final HttpResponseCallBack<UploadErrorReponse> callBack) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoException(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    UploadErrorReponse result = (UploadErrorReponse)JSON.parseObject((String)response, UploadErrorReponse.class);
                    callBack.onSuccessfulResponse(call, result);
                } else {
                    BaseErrorResponse error = (BaseErrorResponse)JSONObject.parseObject((String)response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, error);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/cert/write";
        CertRequest certRequest = new CertRequest(url, cardNum, body, certCallback);
        certRequest.request();
    }

    public void queryState(QueryStateRequest body, String cardNum, final HttpResponseCallBack<QueryStateResponse> callBack) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoException(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    QueryStateResponse result = (QueryStateResponse)JSONObject.parseObject((String)response, QueryStateResponse.class);
                    callBack.onSuccessfulResponse(call, result);
                } else {
                    BaseErrorResponse error = (BaseErrorResponse)JSONObject.parseObject((String)response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, error);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/cert/status";
        CertRequest certRequest = new CertRequest(url, cardNum, body, certCallback);
        certRequest.request();
    }

    public void cancelAll() {
    }
}

