package com.xdja.aircert;

import android.content.Context;

import com.xdja.aircert.net.HttpClientHelper;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;

/**
 * Created by Administrator on 2019/11/14 0014.
 */

public class ApplicationInit {

    public static void start(Context context) {

        // 初始化Http模块
        HttpClientHelper.initOkHttpClient(context);

        initCrytoDev(context);

    }

    /**
     * 初始化芯片管家和加密模块
     *
     * @param context
     */
    private static void initCrytoDev(Context context) {
        //独立模块使用卡模块需要注册，一个app只注册一次
        // 加密设备模块初始化
        final CryptoDevManager cryptoDevManager = CryptoDevManager.getInstance();
        cryptoDevManager.setContext(context);
        // 注册芯片管家设备
        try {
            cryptoDevManager.registerDriver(new ChipManagerDriver());
        } catch (Exception e) {
            e.printStackTrace();
        }

        cryptoDevManager.setDisableSoft(true);
    }


}
