package com.xdja.aircert.activity;

import android.app.Activity;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.aircert.bean.CertState;
import com.xdja.aircert.bean.UploadErrorInfo;
import com.xdja.aircert.common.R;
import com.xdja.aircert.device.CertDetailInfo;
import com.xdja.aircert.device.DeviceWrapper;
import com.xdja.aircert.device.PKCS10ForSM2Utils;
import com.xdja.aircert.invoke.Apply;
import com.xdja.aircert.invoke.ApplyErrorCode;
import com.xdja.aircert.net.CertService;
import com.xdja.aircert.net.ChipExecutorService;
import com.xdja.aircert.net.HttpResponseCallBack;
import com.xdja.aircert.net_bean.BaseErrorResponse;
import com.xdja.aircert.request.ApplyCertRequest;
import com.xdja.aircert.request.GetDNRequest;
import com.xdja.aircert.request.QueryStateRequest;
import com.xdja.aircert.request.UploadErrorRequest;
import com.xdja.aircert.response.ApplyCertResponse;
import com.xdja.aircert.response.GetDNResponse;
import com.xdja.aircert.response.QueryStateResponse;
import com.xdja.aircert.response.UploadErrorReponse;
import com.xdja.aircert.util.CryptoDevTypeUtil;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevType;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import okhttp3.Call;


/**
 * Created by Administrator on 2019/9/23 0023.
 */

public class MainActivity extends Activity implements View.OnClickListener {

    static CryptoDevType cardType = null;

    Button apply;

    Button btSync;

    TextView cardSN;

    TextView btState;

    TextView certContent;

    Button queryState;

    TextView btApplySuccess;

    TextView btSN;

    ChipExecutorService chipExecutorService = new ChipExecutorService();

    CertService service = new CertService("", "");

    static String cardNum;

//    private FastBleOperate fastBleOperate;

    boolean enableBT;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main);

        initView();

        showCurrentSN();

        initBTIfNeeded();

//        EventBus.register(this);


    }

    private void initBTIfNeeded() {

        if (enableBT) {
//            fastBleOperate = new FastBleOperate(getApplication());
//            if (FastBleOperate.enableBlue(this)) {
//                fastBleOperate.scanBleDevices();
//            }
        }
    }


    private void initView() {

        apply = findViewById(R.id.apply);
        apply.setOnClickListener(this);

        btSync = findViewById(R.id.bt_sync);
        btSync.setOnClickListener(this);

        cardSN = findViewById(R.id.card_sn);

        btState = findViewById(R.id.bt_state);

        certContent = findViewById(R.id.cert_content);

        queryState = findViewById(R.id.query_state);
        queryState.setOnClickListener(this);

        btApplySuccess = findViewById(R.id.bt_apply_success);

        btSN = findViewById(R.id.bt_sn);

    }


    @Override
    public void onClick(View view) {

        int id = view.getId();

        if (id == R.id.apply) {

          /*  if (valid()) {
                getDN(0);
            }
*/
            Apply.start("", "" , new Apply.ApplyResultCallback() {
                @Override
                public void result(String errorCode) {
                    if (errorCode.equals(ApplyErrorCode.SUCCESS)) {
                        /*runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                Toast.makeText(MainActivity.this, "发证成功", Toast.LENGTH_SHORT).show();

                                showCurrentSN();
                            }
                        });*/
                    } else {
//                        Toast.makeText(MainActivity.this, errorCode, Toast.LENGTH_SHORT).show();
                    }
                }
            });

         /*   Apply.start(new Apply.ApplyResultCallback() {
                @Override
                public void result(String errorCode) {

                }
            });*/


        } else if (id == R.id.bt_sync) {

            sync();

        } else if (id == R.id.query_state) {
            queryCertState();
        }

    }

    private boolean valid() {
        if (cardType == null || TextUtils.isEmpty(cardNum)) {
            return false;
        } else {
            return true;
        }
    }


    private List<CryptoDevInfo> getDeviceList() {
        List<CryptoDevInfo> beans = new ArrayList<>();

        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getDevInfo();
        if (devInfoMap == null || devInfoMap.size() == 0) {
            return beans;
        }

        for (Map.Entry<Integer, CryptoDevInfo> cryptoDevInfoEntry : devInfoMap.entrySet()) {
            beans.add(cryptoDevInfoEntry.getValue());
        }

        return beans;

    }

    public void showToast(String infName, String msg) {
        //        Toast.makeText(this, infName + "：" + msg, Toast.LENGTH_SHORT).show();
    }

    /**
     * @param bleType 是否是蓝牙设备， 0不是   1蓝牙
     */
    private void getDN(final int bleType) {

        final GetDNRequest request = new GetDNRequest();
        request.setCardType(String.valueOf(CryptoDevTypeUtil.convertCardType(cardType.getType())));

        service.getDN(request, cardNum, new HttpResponseCallBack<GetDNResponse>() {
            @Override
            public void onOtherException(Exception e) {
                showToast("getDN", "other");
            }

            @Override
            public void onIoException(Call call, IOException e) {
                showToast("getDN", "IO E");
            }

            @Override
            public void onSuccessfulResponse(Call call, GetDNResponse getDNResponse) {

                String result = getDNResponse.getResult();

                if (result.equals("0")) {
                    //                    成功
                    String dn = getDNResponse.getMessage();
                    Log.e("jff", "190 MainActivity onSuccessfulResponse 是否是蓝牙设备: " + bleType);
                    Log.e("jff", "163 MainActivity onSuccessfulResponse : dn success");

                    if (bleType == 1) {
                        getBleSignData(dn);
                    } else {
                        apply(dn, bleType, "");
                    }
                } else if (result.equals("1")) {
                    //                    失败
                    showToast("getDN", "dn获取失败");
                }

            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                showToast("getDN", "fail");
            }


        });

    }

    /**
     * 展示当前贴膜卡内的SN
     */
    private void showCurrentSN() {

        List<CryptoDevInfo> list = getDeviceList();

        for (CryptoDevInfo info : list) {
            Log.e("jff", String.valueOf(info.getType().getType()));
            if (info.getType().getType() == CryptoDevType.DEV_TYPE_SimKey.getType()) {

                cardNum = info.getCardId();
                cardType = CryptoDevType.DEV_TYPE_SimKey;

                CertDetailInfo certDetailInfo =
                        DeviceWrapper.readCertFromContainer(cardType, 0);

                if (certDetailInfo == null) {
                    cardSN.setText("卡内无证书");
                    break;
                }

                String sn = certDetailInfo.sn;

                StringBuilder sb = new StringBuilder();
                sb.append("加密设备签名证书sn：");
                sb.append("\n");
                sb.append(sn);

                cardSN.setText(sb.toString());

                Log.e("jff", sn);

            }
        }

    }


    private String bleP10;

    private void getBleSignData(String dn) {
        PKCS10ForSM2Utils.getInstance().sendBleWaitSignData(dn);
    }


    /**
     * 申请证书
     *
     * @param dn      从服务端获取的dn
     * @param bleType 是否是蓝牙设备， 0不是   1蓝牙
     * @param p10     bleType == 0可以直接从芯片获取相关数据，封装P10，有传P10
     *                bleType == 1蓝牙设备，封装P10需要分多步，在这里区分,传入“”即可
     */
    private void apply(String dn, final int bleType, String p10) {
        if (bleType == 0) {
            p10 = PKCS10ForSM2Utils.getInstance().getP10RequestBC(cardType, dn, true);
        }

        ApplyCertRequest request = new ApplyCertRequest();
        request.setCardType("" + CryptoDevTypeUtil.convertCardType(cardType.getType()));
        request.setP10(p10);

        Log.e("jff", "219 MainActivity apply cardNum : " + cardNum);
        service.applyCert(request, cardNum, new HttpResponseCallBack<ApplyCertResponse>() {
            @Override
            public void onOtherException(Exception e) {
                showToast("apply", "other");
            }

            @Override
            public void onIoException(Call call, IOException e) {
                showToast("apply", "io E");
            }

            @Override
            public void onSuccessfulResponse(Call call, ApplyCertResponse applyCertResponse) {
                Toast.makeText(MainActivity.this, "申请成功", Toast.LENGTH_SHORT).show();
                String cert = applyCertResponse.getCert();
                Log.e("jff", "235 MainActivity onSuccessfulResponse : " + cert);
                if (bleType == 0) {
                    writeCert(cert);

                } else {
//                    sendCertToBle(cert);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                showToast("apply", "fail");
                Log.e("jff", "239 MainActivity onFailResponse : " + baseErrorResponse.getMessage());
            }


        });

    }

    /**
     * 拿到服务器返回的cert，开始写卡，并展示
     *
     * @param cert
     */
    private void writeCert(final String cert) {
        if (TextUtils.isEmpty(cert)) {
            return;
        }

        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                final int result = DeviceWrapper.importCert(cardType, cert);

                if (result == 0) {
                    showToast("写卡成功", "");
                    Log.e("jff", "269 MainActivity run 写卡成功");

                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            showCurrentSN();
                        }
                    });

                } else {
                    //                    写卡失败，上报
                    if (result == -4) {
                        //                        importErrorCode = CLIENT_SERVER_CERTRULE_DIFFERENT;
                    }

                    writeCertToServer(cert, "1");

                }


            }
        };
        chipExecutorService.exe(runnable);
    }

    //写卡状态上报
    private void writeCertToServer(final String cert, final String status) {

        Runnable runnable = new Runnable() {
            @Override
            public void run() {

                Looper.prepare();

                String sn = DeviceWrapper.getSn(cardType, cert);

                UploadErrorInfo info = new UploadErrorInfo();
                info.setSn(sn);
                info.setStatus(status);
                info.setTime(System.currentTimeMillis());

                String sign = DeviceWrapper.signData(cardType, info.toString());

                // TODO: 2019/9/25 0025 toast提示

                UploadErrorRequest request = new UploadErrorRequest();
                request.setCardType(String.valueOf(CryptoDevTypeUtil.convertCardType(cardType.getType())));
                request.setSign(sign);
                request.setInfo(info);


                uploadError(request);

            }
        };
        chipExecutorService.exe(runnable);
    }

    private void uploadError(UploadErrorRequest request) {

        service.uploadError(request, cardNum, new HttpResponseCallBack<UploadErrorReponse>() {
            @Override
            public void onOtherException(Exception e) {
                showToast("upload", "other");
            }

            @Override
            public void onIoException(Call call, IOException e) {
                showToast("upload", "io E");

            }

            @Override
            public void onSuccessfulResponse(Call call, UploadErrorReponse uploadErrorReponse) {
                showToast("upload", "上报成功");

            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                showToast("upload", "fail");
            }

        });

    }

    private void queryCertState() {

        if (cardType == null) {
            cardType = getDeviceList().get(0).getType();
        }

        if (TextUtils.isEmpty(cardNum)) {
            cardNum = DeviceWrapper.getCardNum(cardType);
        }

        CertDetailInfo info = DeviceWrapper.readCertFromContainer(cardType, 0);

        if (info == null) {
            return;
        }

        String sn = info.sn;

        final QueryStateRequest request = new QueryStateRequest();
        request.setSn(sn);

        service.queryState(request, cardNum, new HttpResponseCallBack<QueryStateResponse>() {
            @Override
            public void onOtherException(Exception e) {

            }

            @Override
            public void onIoException(Call call, IOException e) {

            }

            @Override
            public void onSuccessfulResponse(Call call, QueryStateResponse queryStateResponse) {
                String state = queryStateResponse.getResult();
                if (state.equals(CertState.REVOKE_SUCCESS)) {
                    deleteLocalCert();
                } else {
                    Toast.makeText(MainActivity.this, state, Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {

            }


        });


    }

    private void deleteLocalCert() {
        int result = DeviceWrapper.clearContainer(cardType);
        if (result == 0) {
            //            Toast.makeText(MainActivity.this, "删除本地证书成功", Toast.LENGTH_SHORT).show();
            showCurrentSN();
        }
    }


    /**
     * 通过蓝牙同步状态
     */
    private void sync() {

        //连接蓝牙设备，设备mac由配置项写死
//        fastBleOperate.connectKey(Configs.textKeyMac);
    }

    private String getCardNum(CryptoDevType type) {

        return DeviceWrapper.getCardNum(type);

    }


    /**
     * 请求蓝牙设备生成公私钥对并获取蓝牙模块芯片的卡号
     */
    public void sendFirstCmd() {
        cardType = CryptoDevType.DEV_TYPE_Chip;
//        fastBleOperate.bleWrite(Command.First_CMD);
    }

    /**
     * 将申请的签名证书发送给蓝牙模块
     */
    public void sendSecondCmd() {
//        fastBleOperate.bleWrite(new Command().getSecondCmd(Command.cmd_index));
    }

    /**
     * 封装P10需要将封装的数据由蓝牙设备加密并返回加密后的数据
     *
     * @param waitSignData 需要蓝牙芯片加密的数据
     */
    public void sendThirdCmd(byte[] waitSignData) {
//        fastBleOperate.bleWrite(new Command().getThirdCmd(waitSignData));
    }


   /* @Subscribe
    public void onReceiveBleConnectResultEvent(BleConnectResultEvent event) {

        if (event.isSuccess()) {
            sendFirstCmd();
            //            connectStatusText.setText("连接成功");
            btState.setText("");
            btState.setText("蓝牙连接状态: 连接成功，开始申请发证");
        } else {
            //            connectStatusText.setText("连接失败");
            btState.setText("");
            btState.setText("蓝牙连接状态: 连接失败，请重试");
        }
    }*/

   /* @Subscribe
    public void onReceiveBleSetNotifyResultEvent(BleSetNotifyResultEvent event) {
        if (event.isSuccess()) {
            sendFirstCmd();
            btState.setText("");
            btState.setText("蓝牙连接状态: 连接成功，开始申请发证");
        } else {
            btState.setText("");
            btState.setText("蓝牙连接状态: 连接失败，请重试");
        }
    }
*/
    /**
     * 解析蓝牙设备返回的加密数据
     *
     * @param event
     */
  /*  @Subscribe
    public void onReceiveBleSignDataEvent(BleSignData event) {
        Log.e("jff", "443 MainActivity onReceiveBleSignDataEvent 手机收到待签名数据: " + StringUtils.printHexString(event.getWaitSignData()));
        byte[] waitSignData = event.getWaitSignData();
        sendThirdCmd(waitSignData);
    }
*/

    /*@Subscribe
    public void onReceiveDisConnectBleEvent(BleDisConnectEvent event) {
        //        connectStatusText.setText("已经断开连接");
    }
*/

    /*@Subscribe
    public void onReceiveLiXinDataEvent(LiXinDataEvent event) {


        byte[] receiveData = event.getData();
        //尝试次数计数
        int tryTimes = 0;
        if (receiveData[7] == 0x01) { // 接收到数据内层协议命令字是0x01，代表接收到的数据是对命令字00的回应
            // jff 第一包请求公钥及芯片ID的结果
            //消息命令字是01，数据长度是60
            if ((receiveData[8] & 0xFF) == 0x60) {//接收到的数据内层协议数据长度是96字节，公钥X-32,Y-32,cardID-32
                //此处需要将xy封装成SM2公钥格式
                byte[] data = new byte[96];
                System.arraycopy(receiveData, 9, data, 0, data.length);

                final byte pub[] = new byte[65];
                pub[0] = 4;
                System.arraycopy(data, 0, pub, 1, 64);
                final byte cardNo[] = new byte[32];
                System.arraycopy(data, 64, cardNo, 0, cardNo.length);

                String cardID = new String(cardNo);
                //将pub作为蓝牙模组生成的SM2公钥发送给腕表====pub为公钥
                PKCS10ForSM2Utils.getInstance().setBlePubKey(pub);

                // TODO: 2019/9/26 jff 需要处理卡号 to zjc
                cardNum = cardID;
                //向服务器发请求获取蓝牙模块的dn
                getDN(1);

                Log.e("jff", "149 TestBleActivity onReceiveLiXinDataEvent pub : " + StringUtils.printHexString(pub));
                Log.e("jff", "151 TestBleActivity onReceiveLiXinDataEvent cardNO: " + StringUtils.printHexString(cardNo));
            } else {
                //重新发送第一包数据
                tryTimes++;
                if (tryTimes == 3) {
                    tryTimes = 0;
                    Toast.makeText(this, "获取设备ID失败", Toast.LENGTH_LONG).show();
                    return;
                }
                sendFirstCmd();
            }
        } else if (receiveData[7] == 0x03) {// 接收到数据内层协议命令字是0x03，代表接收到的数据是对命令字02的回应
            //发送证书数据
            int len = receiveData.length;
            //发送证书过程中如果返回是ACK，表示成功 后两位是校验
            if ((receiveData[11] & 0xFF) == 0X4b && (receiveData[10] & 0xFF) == 0X43 && (receiveData[9] & 0xFF) == 0X41) {//返回的数据是ACK，则继续发包
                //如果成功继续发送下一包证书数据
                Command.cmd_index++;
                if (Command.cmd_index == 3) {
                    byte[] snLen = new byte[4];
                    System.arraycopy(receiveData, 12, snLen, 2, 2);
                    int snLenInt = StringUtils.byteArrayToInt(snLen);
                    byte[] snData = new byte[snLenInt];
                    System.arraycopy(receiveData, 14, snData, 0, snLenInt);
                    String bleSnStr = StringUtils.printHexNoTempString(snData);
                    StringBuilder sb = new StringBuilder();
                    sb.append(btSN.getText());
                    sb.append(": ");
                    sb.append("\n");
                    sb.append(bleSnStr.substring(1));
                    btSN.setText(sb);
                    new Command().resetData();
                    return;
                }
            } else {
                //如果发送失败从第一包数据开始发送
                new Command().resetData();
                tryTimes++;
                if (tryTimes == 3) {
                    return;
                }
            }
            sendSecondCmd();
        } else if (receiveData[7] == 0x07) {// 接收到数据内层协议命令字是0x07，代表接收到的数据是对命令字06的回应，具体代表是收到签名结果的信息

            //消息命令字是07，数据长度是64
            if ((receiveData[8] & 0xFF) == 0x40) {//接收到的数据内层协议数据长度是64字节，签名后的数据长度
                //此处需要将xy封装成SM2公钥格式
                byte[] data = new byte[64];
                System.arraycopy(receiveData, 9, data, 0, data.length);
                Log.e("jff", "532 MainActivity onReceiveLiXinDataEvent 收到蓝牙发送签名数据: " + StringUtils.printHexString(data));
                //将签名数据发出去可以获得ble的p10
                bleP10 = PKCS10ForSM2Utils.getInstance().getBlePkcs10(data);
                //ble开始申请证书
                apply("", 1, bleP10);
            } else {
                //重新发送第一包数据
                //                tryTimes++;
                //                if (tryTimes == 3) {
                //                    tryTimes = 0;
                //                    Toast.makeText(this, "获取设备ID失败", Toast.LENGTH_LONG).show();
                //                    return;
                //                }
                Log.e("jff", "527 MainActivity onReceiveLiXinDataEvent : 数据签名信息发送失败 ");
            }
        }
    }


    *//**
     * 将从服务端获取的ble的证书从腕表（手机端）分包发送给ble
     *
     * @param certStr
     *//*
    private void sendCertToBle(String certStr) {
        //将获取的ble签名证书进行分包处理
        new Command().getCertDer(certStr);

        //发送证书内容
        sendSecondCmd();
    }*/


}
