package com.xdja.aircert.device;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class CertDetailInfo implements Serializable {
    public String subjectCn = "";//拥有者CN
    public String issuerCn = "";//颁发者CN
    public String subjectOrg = "";//拥有者组织
    public String issuerOrg = ""; //颁发者组织
    public String sn = "";      //证书SN
    public String indate = "";    //证书有效期 2013-10-9 / 2013-10-10
    private final int ctnNo = 0;       //容器编号
    public String alg = "";
    public byte[] certId = new byte[2];//证书ID
    public int[] certLen = new int[1];//证书长度
    public int ver = 0;
    public Date notBefore = null;//起始时间
    public Date notAfter = null;//终止时间

    @Override
    public String toString() {
        return "{" +
                "subjectCn='" + subjectCn + '\'' +
                ",issuerCn='" + issuerCn + '\'' +
                ",subjectOrg='" + subjectOrg + '\'' +
                ",issuerOrg='" + issuerOrg + '\'' +
                ",sn='" + sn + '\'' +
                ",indate='" + indate + '\'' +
                ",notBefore='" + notBefore + '\'' +
                ",notAfter='" + notAfter + '\'' +
                ",ctnNo=" + ctnNo +
                ",alg='" + alg + '\'' +
                ",ver='" + ver + '\'' +
                ",certId=" + Arrays.toString(certId) +
                ",certLen=" + Arrays.toString(certLen) +
                '}';
    }

    public String getNotBefore() {
        SimpleDateFormat formatterValid = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        return formatterValid.format(notBefore);
    }

    public String getNotAfter() {
        SimpleDateFormat formatterValid = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        return formatterValid.format(notAfter);
    }

}
