package com.xdja.aircert.device;

/**
 * Created by jff on 2019/4/30.
 */

public class FidUtil {

    public static byte[][] getCertFid(int container) {
        byte[][] certFid = new byte[2][2];
        byte[] signCertFid;
        byte[] exchangeCertFid;

        if (container == 0) {
            signCertFid = new byte[]{0x00, 0x2c};  //默认签名证书
            exchangeCertFid = new byte[]{0x00, 0x29};  //交换证书
            certFid[0] = signCertFid;
            certFid[1] = exchangeCertFid;
            return certFid;
        }

        return null;
    }

    public static byte[][] getKeyPairFid(int container) {
        byte[][] keyPairFid = new byte[2][2];
        byte[] pubKeyFid;
        byte[] priKeyFid;

        if (container == 0) {

//            只留下双证的

            pubKeyFid = new byte[]{0x00, 0x2d};  //签名公钥
            priKeyFid = new byte[]{0x00, 0x2e};  //签名私钥

            keyPairFid[0] = pubKeyFid;
            keyPairFid[1] = priKeyFid;
            return keyPairFid;
        }


        return null;
    }


}
