package com.xdja.aircert.invoke;

import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.aircert.bean.UploadErrorInfo;
import com.xdja.aircert.device.CertDetailInfo;
import com.xdja.aircert.device.DeviceWrapper;
import com.xdja.aircert.device.PKCS10ForSM2Utils;
import com.xdja.aircert.net.CertService;
import com.xdja.aircert.net.ChipExecutorService;
import com.xdja.aircert.net.HttpResponseCallBack;
import com.xdja.aircert.net_bean.BaseErrorResponse;
import com.xdja.aircert.request.ApplyCertRequest;
import com.xdja.aircert.request.GetDNRequest;
import com.xdja.aircert.request.UploadErrorRequest;
import com.xdja.aircert.response.ApplyCertResponse;
import com.xdja.aircert.response.GetDNResponse;
import com.xdja.aircert.response.UploadErrorReponse;
import com.xdja.aircert.util.CryptoDevTypeUtil;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevType;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import okhttp3.Call;

/**
 * Created by Administrator on 2019/11/5 0005.
 */

public class Apply {

    static CryptoDevType cardType = CryptoDevType.DEV_TYPE_Chip;

    public interface ApplyResultCallback {

        void result(String errorCode);

    }

    public static void start(
            String ip,
            String port,
            final ApplyResultCallback callback) {

        final String cardNum = getCardNum();

        if (TextUtils.isEmpty(cardNum)) {
            callback.result(ApplyErrorCode.CARD_NOT_EXIST_EXCEPTION);
            return;
        }

        if (cardNum.equals(ApplyErrorCode.MORE_THAN_ONE_CARD_ERROR)) {
            callback.result(ApplyErrorCode.MORE_THAN_ONE_CARD_ERROR);
            return;
        }

        if (cardNum.equals(ApplyErrorCode.CERT_ALREADY_EXIST_ERROR)) {
            callback.result(ApplyErrorCode.CERT_ALREADY_EXIST_ERROR);
            return;
        }

        final CertService service = new CertService(ip, port);

        final GetDNRequest request = new GetDNRequest();

        request.setCardType(
                String.valueOf(CryptoDevTypeUtil.convertCardType(
                        CryptoDevType.DEV_TYPE_SimKey.getType())));

        service.getDN(request, cardNum, new HttpResponseCallBack<GetDNResponse>() {
            @Override
            public void onOtherException(Exception e) {
                callback.result(ApplyErrorCode.UNKNOWN_EXCEPTION);
            }

            @Override
            public void onIoException(Call call, IOException e) {
                callback.result(ApplyErrorCode.GET_DN_IO_EXCEPTION);
            }

            @Override
            public void onSuccessfulResponse(final Call call, GetDNResponse getDNResponse) {

                String result = getDNResponse.getResult();

                if (result.equals("0")) {
                    //成功
                    String dn = getDNResponse.getMessage();

                    String p10 = PKCS10ForSM2Utils.getInstance().getP10RequestBC(cardType, dn, true);

                    ApplyCertRequest request = new ApplyCertRequest();
                    request.setCardType("" + CryptoDevTypeUtil.convertCardType(cardType.getType()));
                    request.setP10(p10);

                    Log.e("jff", "219 MainActivity apply cardNum : " + cardNum);

                    service.applyCert(request, cardNum, new HttpResponseCallBack<ApplyCertResponse>() {
                        @Override
                        public void onOtherException(Exception e) {
                            callback.result(ApplyErrorCode.UNKNOWN_EXCEPTION);
                        }

                        @Override
                        public void onIoException(Call call, IOException e) {
                            callback.result(ApplyErrorCode.APPLY_CERT_IO_EXCEPTION);
                        }

                        @Override
                        public void onSuccessfulResponse(Call call, ApplyCertResponse applyCertResponse) {
                            final String cert = applyCertResponse.getCert();
                            Log.e("jff", "235 MainActivity onSuccessfulResponse : " + cert);

                            if (TextUtils.isEmpty(cert)) {
                                return;
                            }

                            Runnable runnable = new Runnable() {
                                @Override
                                public void run() {
                                    final int result = DeviceWrapper.importCert(cardType, cert);

                                    if (result == 0) {

                                        callback.result(ApplyErrorCode.SUCCESS);

                                        Log.e("jff", "269 MainActivity run 写卡成功");

                                    } else {
                                        //                    写卡失败，上报
                                        if (result == -4) {
                                            // importErrorCode = CLIENT_SERVER_CERTRULE_DIFFERENT;
                                        }

                                        Runnable runnable = new Runnable() {
                                            @Override
                                            public void run() {

                                                Looper.prepare();

                                                String sn = DeviceWrapper.getSn(cardType, cert);

                                                UploadErrorInfo info = new UploadErrorInfo();
                                                info.setSn(sn);
                                                info.setStatus("1");
                                                info.setTime(System.currentTimeMillis());

                                                String sign = DeviceWrapper.signData(cardType, info.toString());

                                                // TODO: 2019/9/25 0025 toast提示

                                                final UploadErrorRequest request = new UploadErrorRequest();
                                                request.setCardType(String.valueOf(CryptoDevTypeUtil.convertCardType(cardType.getType())));
                                                request.setSign(sign);
                                                request.setInfo(info);


                                                service.uploadError(request, cardNum, new HttpResponseCallBack<UploadErrorReponse>() {
                                                    @Override
                                                    public void onOtherException(Exception e) {
                                                        callback.result(ApplyErrorCode.UNKNOWN_EXCEPTION);
                                                    }

                                                    @Override
                                                    public void onIoException(Call call, IOException e) {
                                                        callback.result(ApplyErrorCode.UPLOAD_IO_EXCEPTION);
                                                    }

                                                    @Override
                                                    public void onSuccessfulResponse(Call call, UploadErrorReponse uploadErrorReponse) {
                                                        String result = uploadErrorReponse.getResult();
                                                        if (result.equals("0")) {
                                                            callback.result(ApplyErrorCode.UPLOAD_SUCCESS);
                                                        } else if (request.equals("1")) {
                                                            callback.result(ApplyErrorCode.UPLOAD_FAIL);
                                                        }
                                                    }

                                                    @Override
                                                    public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                                                        callback.result(ApplyErrorCode.UPLOAD_FAIL_RESPONSE);
                                                    }
                                                });

                                            }
                                        };

                                        ChipExecutorService chipExecutorService = new ChipExecutorService();
                                        chipExecutorService.exe(runnable);


                                    }


                                }
                            };

                            ChipExecutorService service = new ChipExecutorService();

                            service.exe(runnable);


                        }

                        @Override
                        public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
//                            callback.result(ApplyErrorCode.APPLY_CERT_FAIL_RESPONSE);

                            String errorCode = baseErrorResponse.getErrCode();
                            callback.result(errorCode);


                        }

                    });


                } else if (result.equals("1")) {
                    callback.result(ApplyErrorCode.GET_DN_FAIL);
                }

            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
//                callback.result(ApplyErrorCode.GET_DN_FAIL_RESPONSE);
            }

        });

    }

    private static String getCardNum() {

        List<CryptoDevInfo> list = getDeviceList();

        if (list == null || list.size() == 0) {
            return null;
        }

        if (list.size() > 1) {
            return ApplyErrorCode.MORE_THAN_ONE_CARD_ERROR;
        }

        for (CryptoDevInfo info : list) {
            Log.e("jff", String.valueOf(info.getType().getType()));
            if (info.getType().getType() == cardType.getType()) {

                String cardNum = info.getCardId();

           /*     CertDetailInfo certDetailInfo =
                        DeviceWrapper.readCertFromContainer(cardType, 0);

                if (certDetailInfo != null) {
                    String certSN = certDetailInfo.sn;
                    Log.e("jff", certSN);

                    cardNum = ApplyErrorCode.CERT_ALREADY_EXIST_ERROR;*/

                return cardNum;
            }

        }


        return null;


    }

    private static List<CryptoDevInfo> getDeviceList() {
        List<CryptoDevInfo> beans = new ArrayList<>();

        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getDevInfo();
        if (devInfoMap == null || devInfoMap.size() == 0) {
            return beans;
        }

        for (Map.Entry<Integer, CryptoDevInfo> cryptoDevInfoEntry : devInfoMap.entrySet()) {
            beans.add(cryptoDevInfoEntry.getValue());
        }

        return beans;

    }


}
