package com.xdja.aircert.net;

import android.util.Log;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.aircert.net_bean.BaseErrorResponse;
import com.xdja.aircert.request.ApplyCertRequest;
import com.xdja.aircert.request.GetDNRequest;
import com.xdja.aircert.request.QueryStateRequest;
import com.xdja.aircert.request.UploadErrorRequest;
import com.xdja.aircert.response.ApplyCertResponse;
import com.xdja.aircert.response.GetDNResponse;
import com.xdja.aircert.response.QueryStateResponse;
import com.xdja.aircert.response.UploadErrorReponse;

import java.io.IOException;

import okhttp3.Call;

/**
 * Created by Administrator on 2019/9/23 0023.
 */
public class CertService {

    private static String CLOUD_HOST;


    private String ip;

    private String port;

    public CertService(String ip, String port) {
        this.ip = ip;
        this.port = port;

        CLOUD_HOST = "https://" + ip + ":" + port + "/airIssue";
    }

   /* private CertService() {

        String ip = "11.12.86.59";

        String port = "8443";


    }*/

    /**
     * 1	获取设备信息对应的DN
     *
     * @param body
     * @param cardNum
     * @param callBack
     */
    public void getDN(GetDNRequest body, String cardNum,
                      final HttpResponseCallBack<GetDNResponse> callBack) {

        RequestCallback certCallback = new RequestCallback() {


            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoException(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {

                if (isSuccessful) {
                    final GetDNResponse result = JSONObject.parseObject(response, GetDNResponse.class);
                    callBack.onSuccessfulResponse(call, result);
                } else {
                    final BaseErrorResponse error = JSONObject.parseObject(response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, error);
                }

            }


        };

        String url = CLOUD_HOST + "/v1/cert/getDn";
        CertRequest certRequest = new CertRequest(url, cardNum, body, certCallback);
        certRequest.request();


    }

    /**
     * 2	证书申请
     *
     * @param body
     * @param cardNum
     * @param callBack
     */
    public void applyCert(ApplyCertRequest body, String cardNum,
                          final HttpResponseCallBack<ApplyCertResponse> callBack) {

        RequestCallback certCallback = new RequestCallback() {


            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoException(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                Log.e("jff", "105 CertService applyCert success : " + response);
                if (isSuccessful) {
                    final ApplyCertResponse result = JSONObject.parseObject(response, ApplyCertResponse.class);
                    callBack.onSuccessfulResponse(call, result);
                } else {
                    final BaseErrorResponse error = JSONObject.parseObject(response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, error);
                }

            }
        };

        String url = CLOUD_HOST + "/v1/cert/application";
        CertRequest certRequest = new CertRequest(url, cardNum, body, certCallback);
        certRequest.request();

    }


    /**
     * 3	上报写卡失败
     *
     * @param body
     * @param cardNum
     * @param callBack
     */
    public void uploadError(UploadErrorRequest body, String cardNum,
                            final HttpResponseCallBack<UploadErrorReponse> callBack) {

        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoException(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final UploadErrorReponse result = JSON.parseObject(response, UploadErrorReponse.class);
                    callBack.onSuccessfulResponse(call, result);
                } else {
                    final BaseErrorResponse error = JSONObject.parseObject(response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, error);
                }
            }
        };

        String url = CLOUD_HOST + "/v1/cert/write";
        CertRequest certRequest = new CertRequest(url, cardNum, body, certCallback);
        certRequest.request();
    }

    public void queryState(QueryStateRequest body, String cardNum,
                           final HttpResponseCallBack<QueryStateResponse> callBack) {

        RequestCallback certCallback = new RequestCallback() {

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoException(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final QueryStateResponse result
                            = JSONObject.parseObject(response, QueryStateResponse.class);
                    callBack.onSuccessfulResponse(call, result);
                } else {
                    final BaseErrorResponse error
                            = JSONObject.parseObject(response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, error);
                }
            }
        };

        String url = CLOUD_HOST + "/v1/cert/status";
        CertRequest certRequest = new CertRequest(url, cardNum, body, certCallback);
        certRequest.request();

    }

    /**
     * 取消所有请求
     */
    public void cancelAll() {
//        try {
////            com.xdja.https.module.HttpClientManager.getInstance().createHttpClient(httpsParam)
////            HttpClientManager.getInstance().createHttpClient().dispatcher().cancelAll();
////            com.xdja.https.module.HttpClientManager.getInstance().createHttpClient().dispatcher().cancelAll();
//        } catch (Exception e) {
//            e.printStackTrace();

//        }
    }


}

