package com.xdja.aircert.net;

import android.os.Message;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by gyx on 2018/7/3.
 */
public class ChipExecutorService {

    private final static ExecutorService executorService = Executors.newFixedThreadPool(5);


    /**
     * 执行线程
     *
     * @param runnable
     */
    public void exe(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        executorService.execute(runnable);
    }

    /**
     * 线程执行完 ，切换到主线程
     *
     * @param handler
     * @param what
     * @param obj
     * @param <T>
     */
    public <T extends WeakReferenceHandler> void sendMessage(T handler, int what, Object obj) {
        Message msg = handler.obtainMessage(what);
        if (obj != null) {
            msg.obj = obj;
        }
        handler.sendMessage(msg);
    }
}
