package com.xdja.a3rdplugin.demo;

/**
 * 身份证识别有OCR、NFC的方式，每种方式有不同厂家提供服务<br><br>
 * 为了满足服务器接口的格式要求，需要对格式进行处理
 * Created by zjc on 2018/8/13 0013.
 */

public class IDUtil {

    /**
     * 转换出生日期的格式<br><br>
     *
     * @param birthDate 出生日期 格式19931226
     * @return 返回格式 1990-02-16
     */
    public static String formatBirthDate(String birthDate) {
        StringBuilder sb = new StringBuilder();
        sb.append(birthDate.substring(0, 4));
        sb.append("-");
        sb.append(birthDate.substring(4, 6));
        sb.append("-");
        sb.append(birthDate.substring(6, 8));
        return sb.toString();
    }


    /**
     * 转换身份证有效日期的格式<br><br>
     *
     * @param validDate 身份证有效期,格式20101126-20201126
     *                   西藏亿数有效期格式是2015082420250824
     * @return 转换后的格式“2009.09.04-2019.09.04”
     */
    public static String formatValidDate(String validDate) {
        validDate = validDate.replaceAll("-", "");

        String array[] = validDate.split("-");
//        // 将“-”前后的两个日期分开
//        String former = array[0];
//        String later = array[1];

        StringBuilder sb = new StringBuilder();
        sb.append(validDate.substring(0, 4));
        sb.append(".");
        sb.append(validDate.substring(4, 6));
        sb.append(".");
        sb.append(validDate.substring(6, 8));

        sb.append("-");

        sb.append(validDate.substring(8, 12));
        sb.append(".");
        sb.append(validDate.substring(12, 14));
        sb.append(".");
        sb.append(validDate.substring(14, 16));

        return sb.toString();
    }

}
