package com.xdja.a3rdplugin.demo;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntDef;

import com.megvii.livenesslib.LivenessActivity;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2018/7/5 0005.
 * 活体识别选择方式
 */

public class LiveCompany {

    public static final List<ConfigBean> list = new ArrayList<>();

    static {
        list.add(new ConfigBean("云从"));
        list.add(new ConfigBean("旷世"));
        list.add(new ConfigBean("自拍"));
        list.add(new ConfigBean("无活体检测"));
        list.add(new ConfigBean("百度"));
    }

    @IntDef({YUNCONG, KUANGSHI})
    @Retention(RetentionPolicy.SOURCE)
    public @interface RecognizeCompany {
    }

    /**
     * 云从
     */
    public static final int YUNCONG = 0;

    /**
     * 旷世
     */
    public static final int KUANGSHI = 1;

    /**
     * 自拍
     */
    public static final int SELFIE = 2;

    /**
     * 无活体检测
     */
    public static final int NO_LIVE = 3;

    public static final int BAIDU = 4;

    public static void kuangshi(Context context) {
        Intent intent = new Intent(context, LivenessActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }


}
