package com.xdja.a3rdplugin.demo;

import android.content.Context;
import android.content.Intent;

import com.xdja.a3rdplugin.demo.activity.ANRONGOCRActivity;
import com.xdja.a3rdplugin.demo.activity.XDJAOCRActivity;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2018/7/2 0002.
 */

public class OCR {

    public static final List<ConfigBean> list = new ArrayList<>();

    static {
        list.add(new ConfigBean("信大捷安"));
        list.add(new ConfigBean("云从"));
        list.add(new ConfigBean("安荣"));
        list.add(new ConfigBean("无"));
        list.add(new ConfigBean("百度"));
    }

    /**
     * 公司 - 李伟军提供
     */
    public static final int XDJA = 0;

    /**
     * 云从
     */
    public static final int YUNCONG = 1;

    /**
     * 安荣
     */
    public static final int ANRONG = 2;

    /**
     * 无OCR
     */
    public static final int NO_OCR = 3;

    /**
     * 百度
     */
    public static final int BAIDU = 4;


    /**
     * 信大捷安OCR
     *
     * @param context
     */
    public static void XDJA(Context context) {
        Intent intent = new Intent(context, XDJAOCRActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    /**
     * 正面
     */
    public static final int HEAD = 1;

    /**
     * 反面
     */
    public static final int TAIL = 2;

    /**
     * 安荣
     *
     * @param context
     * @param side    正面还是反面，正面是1，反面是2
     */
    public static void ANRONG(Context context, int side) {
        Intent intent = new Intent(context, ANRONGOCRActivity.class);
        intent.putExtra("recogType", side); // 参数1为正面 2为反面
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }


}
