package com.xdja.a3rdplugin.demo.activity;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;

import com.aircert.BusProvider;
import com.aircert.util.ModuleLog;
import com.xdja.a3rdplugin.R;
import com.xdja.a3rdplugin.demo.IDUtil;
import com.xdja.a3rdplugin.demo.ModuleToast;
import com.xdja.a3rdplugin.demo.OCR;
import com.xdja.a3rdplugin.demo.event.IDCardHeadResult;
import com.xdja.a3rdplugin.demo.event.IDCardTailResult;

import java.util.List;

public class ANRONGOCRActivity extends AppCompatActivity {

    Context context;

    public static final int REQUEST_CODE = 1032;

    /**
     * 安荣OCR的包名
     */
    public static final String AN_RONG_PACKAGE_NAME = "com.anrongtec.ocr";

    /**
     * 实际启动的OCR Activity名称
     */
    public static final String AN_RONG_ACTIVITY_NAME = "com.anrongtec.ocr.PersonActivity";

    /**
     * 安荣OCR的目标版本
     */
    public static final float TARGET_OCR_VERSION = 1.8f;

    /**
     * 应用商店的包名
     */
    public static final String MAM_APP_STORE_PACKAGE_NAME = "com.xdja.mam";


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        context = this;
        start(getIntent().getIntExtra("recogType", 1));
    }

    /**
     *
     */
    public static void installOCR() {
        // 有些地方是没有应用商店的，所以可能需要将APK打包到我们的应用内
    }

    /**
     * 根据包名判断手机是否安装某个应用
     *
     * @param context        context
     * @param appPackageName 应用包名
     * @return true：安装，false：未安装
     */
    public static boolean isApplicationInstalled(Context context, String appPackageName) {
        PackageManager packageManager = context.getPackageManager();// 获取packagemanager
        List<PackageInfo> info = packageManager.getInstalledPackages(0);// 获取所有已安装程序的包信息
        if (info != null) {
            for (int i = 0; i < info.size(); i++) {
                String pn = info.get(i).packageName;
                if (appPackageName.equals(pn)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 所安装的OCR版本是否符合预期
     *
     * @return 版本符合返回true
     */
    public static boolean isVersionOK(Context context) {
//        ModuleToast.show(this, "当前OCR版本" + getVersion(anrongPackageName));

        String version = getVersion(context, AN_RONG_PACKAGE_NAME);
        ModuleLog.d("当前安荣OCR的版本:" + version);
        if (TextUtils.isEmpty(version)) {
            // 为""代表版本号转换出错
            // TODO: 2018/8/2 0002 能不能到时候versionCode和versionName并用，或者versionCode优先
            return false;
        }

        try {
            Float versionCode = Float.parseFloat(version);
            return versionCode >= TARGET_OCR_VERSION;
        } catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }

    }

    /**
     * 根据包名获取应用版本号（versionName) <br><br>
     * 这里用versionName而不用versionCode <br><br>
     * 是因为现场手机的应用商店是公司的应用商店MAM(包名是com.xdja.mam)<br><br>
     * 其中在应用详情页显示的版本是versionName<br><br>
     * 为了之后万一出问题排查和沟通问题的方便，所以使用versionName
     *
     * @param packageName 包名
     * @return 版本号（versionName）
     */
    public static String getVersion(Context context, String packageName) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(packageName, 0);
//            ModuleToast.show(this, info.versionName + ":" + info.version);
            return info.versionName;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    /**
     * 跳转到应用商店进行下载
     */
    public static void goToAppStore(Context context) {

        if (!isApplicationInstalled(context, MAM_APP_STORE_PACKAGE_NAME)) {
//            天津现场是都安装应用商店的，所以出现未安装的可能性很小
            ModuleToast.show(context, R.string.app_store_uninstall);
            installOCR();
            return;
        }

        Intent intent = context.getPackageManager().getLaunchIntentForPackage(MAM_APP_STORE_PACKAGE_NAME);
        if (intent != null) {
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        }
        // intent为null代表应用商店未安装，只不过前面已经判断过，所以不会走到这个分支里
    }

    /**
     * 开始扫描身份证
     *
     * @param side 正面是1，反面是2
     */
    private void start(int side) {
        try {
            ComponentName componentName = new ComponentName(AN_RONG_PACKAGE_NAME, AN_RONG_ACTIVITY_NAME);
            Intent intent = new Intent();
            intent.putExtra("recogType", side); // 参数1为正面 2为反面
            intent.setComponent(componentName);
            startActivityForResult(intent, REQUEST_CODE);
        } catch (ActivityNotFoundException e) {
            ModuleToast.show(context, R.string.not_install_anrong_ocr);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);

        if (resultCode == Activity.RESULT_OK && requestCode == REQUEST_CODE) {

            int side = intent.getIntExtra("recogType", 1);

            //正面
            if (side == OCR.HEAD) {
                if (intent.getStringExtra("recogResult") != null) {

                    IDCardHeadResult id = new IDCardHeadResult();
                    id.setSfzh(intent.getStringExtra("recogResult"));//身份证号
                    id.setXm(intent.getStringExtra("recogName"));//姓名
                    id.setXb(intent.getStringExtra("recogSex"));//性别
                    // 原始数据格式19931226
                    String birthDate = intent.getStringExtra("recogBorn");
                    String formatValue = IDUtil.formatBirthDate(birthDate);
                    id.setCsrq(formatValue);//出生日期
                    //注意，address的拼写错误不要改掉！！
                    id.setCsdz(intent.getStringExtra("recogAdress"));//地址
                    id.setMz(intent.getStringExtra("recogNation"));//民族

//                    ModuleLog.d(id);

                    BusProvider.getMainProvider().post(id);

                    finish();
                }


            } else if (side == OCR.TAIL) {
                //反面
                //注意，address的拼写错误不要改掉！！！
                String department = intent.getStringExtra("recogAdress");
                String validDate = intent.getStringExtra("recogTime");

                IDCardTailResult result = new IDCardTailResult();
                result.setDepartment(department);
                // 安荣的日期格式20101126-20201126
                String formatValue = IDUtil.formatValidDate(validDate);
                result.setValidDate(formatValue);

                BusProvider.getMainProvider().post(result);

                finish();

            }

        } else {
            // 按返回会走到这里，直接结束，否则会出现白屏
            finish();
        }


    }
}
