/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.a3rdplugin.demo.activity;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.aircert.BusProvider;
import com.aircert.util.ModuleLog;
import com.xdja.a3rdplugin.R;
import com.xdja.a3rdplugin.demo.IDUtil;
import com.xdja.a3rdplugin.demo.ModuleToast;
import com.xdja.a3rdplugin.demo.event.IDCardHeadResult;
import com.xdja.a3rdplugin.demo.event.IDCardTailResult;
import java.util.List;

public class ANRONGOCRActivity
extends AppCompatActivity {
    Context context;
    public static final int REQUEST_CODE = 1032;
    public static final String AN_RONG_PACKAGE_NAME = "com.anrongtec.ocr";
    public static final String AN_RONG_ACTIVITY_NAME = "com.anrongtec.ocr.PersonActivity";
    public static final float TARGET_OCR_VERSION = 1.8f;
    public static final String MAM_APP_STORE_PACKAGE_NAME = "com.xdja.mam";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.context = this;
        this.start(this.getIntent().getIntExtra("recogType", 1));
    }

    public static void installOCR() {
    }

    public static boolean isApplicationInstalled(Context context, String appPackageName) {
        PackageManager packageManager = context.getPackageManager();
        List info = packageManager.getInstalledPackages(0);
        if (info != null) {
            for (int i = 0; i < info.size(); ++i) {
                String pn = ((PackageInfo)info.get((int)i)).packageName;
                if (!appPackageName.equals(pn)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isVersionOK(Context context) {
        String version = ANRONGOCRActivity.getVersion(context, AN_RONG_PACKAGE_NAME);
        ModuleLog.d((Object)("\u5f53\u524d\u5b89\u8363OCR\u7684\u7248\u672c:" + version));
        if (TextUtils.isEmpty((CharSequence)version)) {
            return false;
        }
        try {
            Float versionCode = Float.valueOf(Float.parseFloat(version));
            return versionCode.floatValue() >= 1.8f;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getVersion(Context context, String packageName) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(packageName, 0);
            return info.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void goToAppStore(Context context) {
        if (!ANRONGOCRActivity.isApplicationInstalled(context, MAM_APP_STORE_PACKAGE_NAME)) {
            ModuleToast.show(context, R.string.app_store_uninstall);
            ANRONGOCRActivity.installOCR();
            return;
        }
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(MAM_APP_STORE_PACKAGE_NAME);
        if (intent != null) {
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    private void start(int side) {
        try {
            ComponentName componentName = new ComponentName(AN_RONG_PACKAGE_NAME, AN_RONG_ACTIVITY_NAME);
            Intent intent = new Intent();
            intent.putExtra("recogType", side);
            intent.setComponent(componentName);
            this.startActivityForResult(intent, 1032);
        }
        catch (ActivityNotFoundException e) {
            ModuleToast.show(this.context, R.string.not_install_anrong_ocr);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if (resultCode == -1 && requestCode == 1032) {
            int side = intent.getIntExtra("recogType", 1);
            if (side == 1) {
                if (intent.getStringExtra("recogResult") != null) {
                    IDCardHeadResult id = new IDCardHeadResult();
                    id.setSfzh(intent.getStringExtra("recogResult"));
                    id.setXm(intent.getStringExtra("recogName"));
                    id.setXb(intent.getStringExtra("recogSex"));
                    String birthDate = intent.getStringExtra("recogBorn");
                    String formatValue = IDUtil.formatBirthDate(birthDate);
                    id.setCsrq(formatValue);
                    id.setCsdz(intent.getStringExtra("recogAdress"));
                    id.setMz(intent.getStringExtra("recogNation"));
                    BusProvider.getMainProvider().post((Object)id);
                    this.finish();
                }
            } else if (side == 2) {
                String department = intent.getStringExtra("recogAdress");
                String validDate = intent.getStringExtra("recogTime");
                IDCardTailResult result = new IDCardTailResult();
                result.setDepartment(department);
                String formatValue = IDUtil.formatValidDate(validDate);
                result.setValidDate(formatValue);
                BusProvider.getMainProvider().post((Object)result);
                this.finish();
            }
        } else {
            this.finish();
        }
    }
}

