/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.cache;

import android.content.Context;
import android.os.Environment;
import android.util.Base64;
import cn.cloudwalk.libproject.util.Util;
import com.xdja.safeclient.certcreation.Selfie;
import com.xdja.safeclient.certcreation.util.Base64Util;
import com.xdja.safeclient.certcreation.util.ModuleLog;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callback.FileCallback;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;

public class ImageCache {
    public static final String PATH_SELFIE = Environment.getExternalStorageDirectory().getPath() + File.separator + "selfie.jpg";
    public static final String PATH_ID_IMG = Environment.getExternalStorageDirectory().getPath() + File.separator + "id_img.jpg";
    private int idType;
    private String id;
    private String selfie;
    private int selfieType;
    private static ImageCache cache;

    public String getSelfie() {
        return this.selfie;
    }

    public static void compressSelfie() {
        ImageCache.compressFile(PATH_SELFIE);
        ImageCache.getInstance().setSelfie(Selfie.CAMERA, Base64Util.fromFile(PATH_SELFIE), true);
    }

    public static void compressIDImage() {
        ImageCache.compressFile(PATH_ID_IMG);
        ImageCache.getInstance().setId(Selfie.CAMERA, URLEncoder.encode(Base64Util.fromFile(PATH_ID_IMG)));
    }

    private static void compressFile(String filePath) {
        Tiny.FileCompressOptions options = new Tiny.FileCompressOptions();
        options.outfile = filePath;
        Tiny.getInstance().source(filePath).asFile().withOptions(options).compress(new FileCallback(){

            public void callback(boolean isSuccess, String outfile) {
                if (isSuccess) {
                    ModuleLog.e(outfile);
                } else {
                    ModuleLog.e("\u538b\u7f29\u5931\u8d25   ");
                }
            }
        });
    }

    public void setSelfie(int selfieType, String selfie, boolean encode) {
        this.selfie = encode ? URLEncoder.encode(selfie) : selfie;
        this.selfieType = selfieType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(int idType, String id2) {
        this.id = id2;
        this.idType = idType;
    }

    private ImageCache() {
    }

    public static ImageCache getInstance() {
        if (cache == null) {
            cache = new ImageCache();
        }
        return cache;
    }

    public void clear() {
        cache = null;
    }

    public void clearID(Context context) {
        File yishu = new File(Environment.getExternalStorageDirectory() + File.separator + "yishu");
        ImageCache.deleteDir(yishu);
        ImageCache.deleteYuncongCache(context);
        File delete = new File(Environment.getExternalStorageDirectory() + File.separator + "alpha" + File.separator + "SIDCard");
        ImageCache.deleteDir(delete);
        File ID_IMG = new File(PATH_ID_IMG);
        ID_IMG.delete();
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = ImageCache.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static void deleteYuncongCache(Context context) {
        try {
            String frontPath = Util.getDiskCacheDir((Context)context) + "/frontphoto.jpg";
            String backPath = Util.getDiskCacheDir((Context)context) + "/backphoto.jpg";
            File frontFile = new File(frontPath);
            File backFile = new File(backPath);
            if (frontFile.exists()) {
                frontFile.delete();
            }
            if (backFile.exists()) {
                backFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBase64ToFile(String base64, File dstFile) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dstFile);
            ((OutputStream)out).write(Base64.decode((String)base64, (int)0));
            out.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

