/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.util;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import java.io.File;

public class CamUtil {
    private static final int RESULT_OK = -1;
    public static final int PHOTO_REQUEST_TAKEPHOTO = 1;
    public static final int PHOTO_REQUEST_GALLERY = 2;
    public static final int PHOTO_REQUEST_CUT = 3;
    public static final Uri URI_SELFIE = Uri.fromFile((File)new File(ImageCache.PATH_SELFIE));
    public static final Uri URI_ID_IMG = Uri.fromFile((File)new File(ImageCache.PATH_ID_IMG));

    public static Bitmap getBitmapFromCG(Activity activity, int requestCode, int resultCode, Intent data) {
        Bitmap bitmap = null;
        switch (requestCode) {
            case 1: {
                if (resultCode != -1) break;
                if (data != null) {
                    if (data.getData() == null) break;
                    CamUtil.startPhotoZoom(activity, data.getData());
                    break;
                }
                CamUtil.startPhotoZoom(activity, URI_SELFIE);
                break;
            }
            case 2: {
                if (data == null || data.getData() == null) break;
                CamUtil.startPhotoZoom(activity, data.getData());
                break;
            }
            case 3: {
                Bundle bundle;
                if (data == null || (bundle = data.getExtras()) == null) break;
                bitmap = (Bitmap)bundle.getParcelable("data");
            }
        }
        return bitmap;
    }

    private static void startPhotoZoom(Activity activity, Uri uri) {
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(uri, "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", 300);
        intent.putExtra("aspectY", 400);
        intent.putExtra("outputX", 300);
        intent.putExtra("outputY", 400);
        intent.putExtra("return-data", true);
        activity.startActivityForResult(intent, 3);
    }
}

