/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.util;

import android.app.AlertDialog;
import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Window;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.DepartmentListAdapter;
import com.xdja.safeclient.certcreation.adapter.ListAdapter;
import com.xdja.safeclient.certcreation.bean.ProfessionBean;
import com.xdja.safeclient.certcreation.event.ProfessionDepartment;
import com.xdja.safeclient.certcreation.event.ProfessionJobTitle;
import com.xdja.safeclient.certcreation.event.ProfessionPerson;
import com.xdja.safeclient.certcreation.event.ProfessionRank;
import com.xdja.safeclient.certcreation.event.ProfessionType;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class DialogUtil {
    public static final int PERSON = 0;
    public static final int RANK = 1;
    public static final int TYPE = 2;
    public static final int JOB_TITLE = 3;

    public static void popSpinnerList(Context context, List<? extends ProfessionBean> dataSource, final int TAG) {
        final AlertDialog dialog = new AlertDialog.Builder(context).create();
        dialog.requestWindowFeature(1);
        dialog.show();
        dialog.setContentView(R.layout.common_dialog_list);
        Window window = dialog.getWindow();
        RecyclerView recyclerView = (RecyclerView)window.findViewById(R.id.gateway_list);
        LinearLayoutManager layoutManager = new LinearLayoutManager(context);
        layoutManager.setAutoMeasureEnabled(true);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        ListAdapter adapter = new ListAdapter(context);
        adapter.setOnItemClickListener(new ListAdapter.OnItemClickListener(){

            @Override
            public void onItemSelected(int position) {
                if (TAG == 2) {
                    OttoUtil.chooseProfession(new ProfessionType(position));
                } else if (TAG == 3) {
                    OttoUtil.chooseProfession(new ProfessionJobTitle(position));
                } else if (TAG == 0) {
                    OttoUtil.chooseProfession(new ProfessionPerson(position));
                } else if (TAG == 1) {
                    OttoUtil.chooseProfession(new ProfessionRank(position));
                }
                dialog.cancel();
            }
        });
        adapter.setDataSource(dataSource);
        recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        dialog.setCancelable(true);
    }

    public static void popSpinnerList(Context context, final List<ProfessionDepartment> all, final List<ProfessionDepartment> dataSource) {
        final AlertDialog dialog = new AlertDialog.Builder(context).create();
        dialog.requestWindowFeature(1);
        dialog.show();
        dialog.setContentView(R.layout.common_dialog_list);
        Window window = dialog.getWindow();
        RecyclerView recyclerView = (RecyclerView)window.findViewById(R.id.gateway_list);
        LinearLayoutManager layoutManager = new LinearLayoutManager(context);
        layoutManager.setAutoMeasureEnabled(true);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        DepartmentListAdapter adapter = new DepartmentListAdapter(context);
        adapter.setOnItemClickListener(new DepartmentListAdapter.OnItemClickListener(){

            @Override
            public void onItemSelected(int position) {
                List rest = (List)CollectionUtils.subtract((Iterable)all, (Iterable)dataSource);
                OttoUtil.chooseDepartment((ProfessionDepartment)dataSource.get(position), rest);
                dialog.cancel();
            }
        });
        adapter.setDataSource(dataSource);
        recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        dialog.setCancelable(true);
    }

    public static void install(Context context, String message, DialogInterface result) {
    }

    public static interface DialogInterface {
        public void onSuccess(Object ... var1);
    }
}

