/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.aircert.util.ActivityController;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.SelfieActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.util.ModuleLog;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.ShareperencesUtil;
import com.xdja.safeclient.certcreation.util.Util;
import java.io.IOException;
import ocr.bean.IDCardInfo;
import okhttp3.Call;

@Route(path="/cert/auth_fail", name="\u5b9e\u4f53\u8ba4\u8bc1\u5931\u8d25")
public class AuthenticationFailActivity
extends BaseActivity {
    private TextView fail_reason;
    private Button retry;
    @Autowired(name="result")
    public CompareResult compareResult;
    @Autowired(name="devType")
    public CryptoDevType currentChipBeanType;
    @Autowired(name="identify_info")
    public IDCardInfo info;
    @Autowired(name="faceImg")
    public String faceImg;
    private final int ERROR_RETRY = 1;
    private final int ERROR_REAPPLY = 2;
    private int error = 1;
    private String errorMsg;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.compare_fail);
        ARouter.getInstance().inject((Object)this);
        this.getErrorCode();
        this.initView();
    }

    private void initView() {
        this.fail_reason = (TextView)this.findViewById(R.id.tv_fail);
        if (this.errorMsg.equals(this.context.getString(R.string.unknown_error)) && this.compareResult.getMessage().equals(this.context.getString(R.string.get_imsi_failed)) || this.compareResult.getMessage().equals(this.context.getString(R.string.net_disconnected_text))) {
            this.fail_reason.setText((CharSequence)this.compareResult.getMessage());
        } else {
            this.fail_reason.setText((CharSequence)this.errorMsg);
        }
        this.retry = (Button)this.findViewById(R.id.retry);
        if (this.error == 1) {
            this.retry.setText((CharSequence)this.getResources().getString(R.string.identify_again));
        } else {
            this.retry.setText((CharSequence)this.getResources().getString(R.string.apply_again));
        }
        this.retry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AuthenticationFailActivity.this.error == 1) {
                    AuthenticationFailActivity.this.request();
                } else {
                    OttoUtil.post((Object)new SpecificActivity(SelfieActivity.class));
                    ActivityController.getInstance().finishOcrActivities();
                    OttoUtil.postFinishActivity();
                }
            }
        });
    }

    private void initView(CryptoDevType currentChipBeanType, CompareResult compareResult) {
        this.currentChipBeanType = currentChipBeanType;
        this.compareResult = compareResult;
        this.initView();
    }

    private void getErrorCode() {
        String errorCode = this.compareResult.getResult();
        this.errorMsg = OkNetError.handleErrorCodeToMsg((Context)this, errorCode);
        this.error = errorCode.matches(OkNetError.CAALG_ERROR_CODE) || this.compareResult.getMessage().equals(this.context.getString(R.string.net_disconnected_text)) ? 1 : 2;
    }

    private void getErrorCode(CompareResult compareResult) {
        this.compareResult = compareResult;
        this.getErrorCode();
    }

    protected boolean isOCRActivity() {
        return true;
    }

    protected int getTitleRes() {
        return R.string.identify_failed;
    }

    private void request() {
        final int devType = ShareperencesUtil.getCurrentDevType((Context)this);
        final CryptoDevType currentChipBeanType = Util.getChipBeanType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);
        if (TextUtils.isEmpty((CharSequence)cardID)) {
            ModuleToast.show(this.context, R.string.card_device_error);
            return;
        }
        final CompareResult compareResult = new CompareResult();
        CompareCardInfoAndFaceInfoRequest request = this.buildRequest();
        if (request == null) {
            ModuleToast.show(this.context, R.string.get_imsi_failed);
            compareResult.setResult("");
            compareResult.setMessage(this.getResources().getString(R.string.get_imsi_failed));
            compareResult.setSuccess(false);
            compareResult.setIdentity(this.info.getIdNum());
            this.getErrorCode(compareResult);
            this.initView(currentChipBeanType, compareResult);
            return;
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                AuthenticationFailActivity.this.showLoading();
            }
        }, 100L);
        this.service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                ModuleLog.e("other exception");
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e("io exception");
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                ShareperencesUtil.saveIDCardNo(AuthenticationFailActivity.this.context, devType, AuthenticationFailActivity.this.info.getIdNum());
                compareResult.setResult(commonResponse.getResult());
                compareResult.setMessage(commonResponse.getMessage());
                compareResult.setIdentity(AuthenticationFailActivity.this.info.getIdNum());
                compareResult.setSuccess(true);
                if (commonResponse.getResult().equals("2")) {
                    AuthenticationFailActivity.this.getErrorCode(compareResult);
                    AuthenticationFailActivity.this.initView(currentChipBeanType, compareResult);
                } else {
                    AuthResult auth = new AuthResult(currentChipBeanType, compareResult);
                    OttoUtil.postAuthResult(auth);
                    ActivityController.getInstance().finishOcrActivities();
                    OttoUtil.postFinishActivity();
                }
                AuthenticationFailActivity.this.finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                compareResult.setResult(baseErrorResponse.getErrCode());
                compareResult.setMessage(baseErrorResponse.getMessage());
                compareResult.setIdentity(AuthenticationFailActivity.this.info.getIdNum());
                compareResult.setSuccess(false);
                AuthenticationFailActivity.this.getErrorCode(compareResult);
                AuthenticationFailActivity.this.initView(currentChipBeanType, compareResult);
            }

            @Override
            public void dismissDialog() {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        AuthenticationFailActivity.this.dismissLoading();
                    }
                }, 500L);
            }
        });
    }

    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + Util.convertCardType(ShareperencesUtil.getCurrentDevType((Context)this)));
        chipInfo.setImei(deviceWrapper.getIMEI());
        String imsi = deviceWrapper.getIMSI();
        if (TextUtils.isEmpty((CharSequence)imsi)) {
            return null;
        }
        chipInfo.setImsi(deviceWrapper.getIMSI());
        chipInfo.setPhone(ShareperencesUtil.getPhoneNum((Context)this));
        request.setIdCardInfo(this.info);
        request.setChipInfo(chipInfo);
        request.setFaceImg(this.faceImg);
        request.setCaAlg(AppConfig.getInstance().getCaAlg());
        return request;
    }
}

