/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.content.Intent;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.CertDetailInfoActivity;
import com.xdja.safeclient.certcreation.adapter.Unregister;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.view.CertItemView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RecyclerViewAdapter
extends RecyclerView.Adapter<ViewHold>
implements Unregister,
View.OnClickListener {
    private Context context;
    private List<CertItemBean> certItemBeans = new ArrayList<CertItemBean>();
    private ViewHold hold;
    private AuthResult tempValue = null;
    private boolean isRefresh = true;

    public RecyclerViewAdapter(Context context) {
        this.context = context;
    }

    public ViewHold onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_list_layout, null);
        this.hold = new ViewHold(view);
        return this.hold;
    }

    public void onBindViewHolder(ViewHold holder, int position) {
        holder.certItemView.setData(this.context, this, this.certItemBeans.get(position));
        holder.certItemView.setTag(position);
        holder.certItemView.setOnClickListener(this);
    }

    public int getItemCount() {
        return this.certItemBeans == null ? 0 : this.certItemBeans.size();
    }

    @Override
    public void destroy() {
        if (this.hold != null) {
            this.hold.destroy();
        }
    }

    public void onClick(View view) {
        if (FeatureConfig.getInstance().isOnlyShowCertList()) {
            return;
        }
        CertItemView certItemView = (CertItemView)view;
        if (certItemView.isCertOK()) {
            this.setIsRefresh(false);
            ChipBean chipBean = certItemView.getChipBean();
            Intent intent = new Intent(this.context, CertDetailInfoActivity.class);
            intent.putExtra("chipBean", (Serializable)chipBean);
            this.context.startActivity(intent);
        }
    }

    public void setIsRefresh(boolean isRefresh) {
        this.isRefresh = isRefresh;
        Log.e((String)"setIsRefresh", (String)(isRefresh + ""));
    }

    public boolean getIsRefresh() {
        return this.isRefresh;
    }

    public void update(AuthResult result) {
        this.tempValue = result;
        this.notifyDataSetChanged();
    }

    public void addAll(List<CertItemBean> certItemBeans) {
        if (certItemBeans == null || certItemBeans.size() == 0) {
            return;
        }
        this.certItemBeans.clear();
        this.certItemBeans.addAll(certItemBeans);
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.certItemBeans.clear();
        this.notifyDataSetChanged();
    }

    public void refresh() {
        this.notifyDataSetChanged();
    }

    public static class ViewHold
    extends RecyclerView.ViewHolder
    implements Unregister {
        CertItemView certItemView;

        public ViewHold(View itemView) {
            super(itemView);
            this.certItemView = (CertItemView)itemView.findViewById(R.id.cert_item_view);
        }

        @Override
        public void destroy() {
            this.certItemView.onDestory();
        }
    }
}

