/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.device;

import android.os.Build;
import android.text.TextUtils;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;

public class DeviceUtil {
    private static DeviceUtil deviceUtil = new DeviceUtil();

    public static DeviceUtil getInstance() {
        return deviceUtil;
    }

    public String getModel() {
        return Build.MODEL;
    }

    public String getBrand() {
        return Build.BRAND;
    }

    public int getOperator() {
        String imsi = DeviceWrapper.getInstance().getIMSI();
        if (TextUtils.isEmpty((CharSequence)imsi)) {
            return -1;
        }
        return this.getOperatorFromIMSI(imsi);
    }

    private int getOperatorFromIMSI(String imsi) {
        if (imsi.startsWith("46000") || imsi.startsWith("46002") || imsi.equals("46007")) {
            return 1;
        }
        if (imsi.startsWith("46001") || imsi.startsWith("46006")) {
            return 2;
        }
        if (imsi.startsWith("46003") || imsi.startsWith("46005")) {
            return 3;
        }
        return 0;
    }
}

