/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.device;

import android.text.TextUtils;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.devapi.RSAPubkey;
import com.xdja.cryptodev.devapi.SM2Pubkey;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;

public class PKCS10ForRSAUtils
extends PKCS10Utils {
    public static PKCS10ForRSAUtils pkcs10ForRSAUtils = new PKCS10ForRSAUtils();

    public static PKCS10ForRSAUtils getInstance() {
        if (pkcs10ForRSAUtils == null) {
            pkcs10ForRSAUtils = new PKCS10ForRSAUtils();
        }
        return pkcs10ForRSAUtils;
    }

    @Override
    public String getP10RequestBC(CryptoDevType type, String dn, boolean isApplyCert) {
        int keyResult;
        if (TextUtils.isEmpty((CharSequence)dn)) {
            return "";
        }
        if (isApplyCert && (keyResult = this.generateRSAKeys(type)) != 0 && keyResult != -1) {
            return "errorCode" + CryptoDevManager.getInstance().getErrorText(keyResult);
        }
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return "";
        }
        byte[] pubFid = new byte[]{0, 45};
        byte[] priFid = new byte[]{0, 46};
        RSAPubkey pubkey = new RSAPubkey();
        int result = cryptoInstance.readRSAPubKey(pubFid, pubkey);
        if (result != 0) {
            return CryptoDevManager.getInstance().getErrorText(result);
        }
        try {
            byte[] pub = new byte[128];
            System.arraycopy(pubkey.getM(), 0, pub, 0, 128);
            ASN1ObjectIdentifier rsaOID = new ASN1ObjectIdentifier("1.2.840.113549.1.1.1");
            SubjectPublicKeyInfo spi = new SubjectPublicKeyInfo(new AlgorithmIdentifier(rsaOID), pub);
            X500Name x500Name = new X500Name(dn);
            CertificationRequestInfo cf1 = new CertificationRequestInfo(x500Name, spi, null);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DEROutputStream derOutStream = new DEROutputStream((OutputStream)outStream);
            try {
                derOutStream.writeObject((ASN1Encodable)cf1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] certInfoBytes = outStream.toByteArray();
            byte[] signData = new byte[128];
            int[] signDataLen = new int[1];
            int encodeRequestInfo = cryptoInstance.RSASign(1024, priFid, 1, certInfoBytes, certInfoBytes.length, signData, signDataLen);
            if (encodeRequestInfo != 0) {
                return null;
            }
            DERBitString dbs = new DERBitString(signData);
            String signAlg = "SHA1WITHRSA";
            AlgorithmIdentifier signIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find(signAlg);
            CertificationRequest cr = new CertificationRequest(cf1, signIdentifier, dbs);
            PKCS10CertificationRequest request = new PKCS10CertificationRequest(cr);
            byte[] buffer = request.getEncoded();
            String p10 = new String(Base64.encode((byte[])buffer));
            return p10;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private int generateRSAKeys(CryptoDevType type) {
        int genRsaKeysPairResult = -1;
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return genRsaKeysPairResult;
        }
        AppConfig module = AppConfig.getInstance();
        int containerId = module.getContainerID();
        int pinResult = DeviceWrapper.verifyPin(type, "");
        if (pinResult != 0) {
            return pinResult;
        }
        genRsaKeysPairResult = cryptoInstance.genSignRSAKeyPair(containerId, 1024);
        if (genRsaKeysPairResult == 2030 || genRsaKeysPairResult == 2041) {
            if (cryptoInstance.createContainer(module.getRole(), module.getPin(), containerId, "") == 0) {
                genRsaKeysPairResult = cryptoInstance.genSignRSAKeyPair(containerId, 1024);
            } else {
                return genRsaKeysPairResult;
            }
        }
        cryptoInstance.close();
        return genRsaKeysPairResult;
    }

    private void checkP10(CryptoDevType type, String p10) {
        if (p10 == null || p10.equals("")) {
            return;
        }
        try {
            byte[] bs = Base64.decode((String)p10);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(bs);
            CertificationRequest request = re.toASN1Structure();
            CertificationRequestInfo cerReqInfo = request.getCertificationRequestInfo();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DEROutputStream derOutStream = new DEROutputStream((OutputStream)outStream);
            try {
                derOutStream.writeObject((ASN1Encodable)cerReqInfo);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] certInfoBytes = outStream.toByteArray();
            byte[] signature = re.getSignature();
            SubjectPublicKeyInfo info = re.getSubjectPublicKeyInfo();
            DERBitString keyInfo = info.getPublicKeyData();
            byte[] bytes = keyInfo.getBytes();
            byte[] x = new byte[32];
            byte[] y = new byte[32];
            System.arraycopy(bytes, 1, x, 0, x.length);
            System.arraycopy(bytes, x.length + 1, y, 0, y.length);
            SM2Pubkey pubkey = new SM2Pubkey();
            pubkey.setX(x);
            pubkey.setY(y);
            byte[] pubFid = new byte[]{0, 0};
            CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
            int ret = -1;
            if (cryptoInstance != null) {
                ret = cryptoInstance.SM2SignVerify(pubFid, 1, pubkey, certInfoBytes, certInfoBytes.length, signature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

