/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.OCR;
import com.xdja.a3rdplugin.demo.activity.ANRONGOCRActivity;
import com.xdja.a3rdplugin.demo.event.IDCardHeadResult;
import com.xdja.a3rdplugin.demo.event.IDCardTailResult;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.event.ChooseBindwayEvent;
import com.xdja.safeclient.certcreation.event.ClearIDEvent;
import com.xdja.safeclient.certcreation.event.FinishChooseEvent;
import com.xdja.safeclient.certcreation.util.DialogUtil;
import ocr.activity.AnrongOCRIDActivity;
import ocr.activity.OcrActivity;
import ocr.activity.XDJANFCActivity;
import ocr.bean.IDCardInfo;

public class ChooseBindWayActivity
extends BaseActivity {
    View anotherWay;
    private String faceImg = "";
    private final int NFC_STYLE = 1;
    private final int OCR_STYLE = 2;
    private int read_card_way = 1;
    private IDCardInfo id = new IDCardInfo();

    protected boolean hasActionBar() {
        return true;
    }

    protected int getToolbarType() {
        return 0;
    }

    protected int getTitleRes() {
        return R.string.choose_way;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.choose_idenfity_way);
        this.init();
        this.onBindView();
    }

    private void init() {
        final RelativeLayout iv_ocr = (RelativeLayout)this.findViewById(R.id.iv_ocr);
        final RelativeLayout iv_nfc = (RelativeLayout)this.findViewById(R.id.iv_nfc);
        Button nfc = (Button)this.findViewById(R.id.txt_nfc);
        nfc.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseBindWayActivity.this.gotoNFC();
            }
        });
        Button ocr = (Button)this.findViewById(R.id.txt_ocr);
        ocr.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseBindWayActivity.this.gotoOCR();
            }
        });
        TextView ocr2nfc = (TextView)this.findViewById(R.id.ocr2nfc);
        if (AppConfig.getInstance().getOcrCompany() == 3) {
            iv_ocr.setVisibility(8);
            iv_nfc.setVisibility(0);
            ocr2nfc.setVisibility(8);
        }
        iv_ocr.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseBindWayActivity.this.gotoOCR();
            }
        });
        if (AppConfig.getInstance().getNfcCompany() == 2) {
            iv_nfc.setVisibility(8);
            ocr2nfc.setVisibility(8);
            iv_ocr.setVisibility(0);
        }
        iv_nfc.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseBindWayActivity.this.gotoNFC();
            }
        });
        this.anotherWay = this.findViewById(R.id.another_way);
        this.anotherWay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChooseBindWayActivity.this.read_card_way == 1) {
                    ChooseBindWayActivity.this.read_card_way = 2;
                    iv_nfc.setVisibility(8);
                    iv_ocr.setVisibility(0);
                } else {
                    ChooseBindWayActivity.this.read_card_way = 1;
                    iv_ocr.setVisibility(8);
                    iv_nfc.setVisibility(0);
                }
            }
        });
    }

    private void gotoOCR() {
        this.doIdentify(false);
    }

    private void onBindView() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null && bundle.containsKey("faceImg")) {
            this.faceImg = bundle.getString("faceImg");
        }
    }

    private void gotoNFC() {
        this.doIdentify(true);
    }

    @SuppressLint(value={"StringFormatMatches"})
    private void doIdentify(boolean isNFC) {
        if (isNFC) {
            switch (AppConfig.getInstance().getNfcCompany()) {
                case 0: {
                    Intent intentXdja = new Intent((Context)this, XDJANFCActivity.class);
                    Bundle othersXdja = new Bundle();
                    othersXdja.putString("faceImg", this.faceImg);
                    intentXdja.putExtras(othersXdja);
                    this.startActivity(intentXdja);
                    break;
                }
            }
        } else {
            switch (AppConfig.getInstance().getOcrCompany()) {
                case 2: {
                    if (!ANRONGOCRActivity.isApplicationInstalled((Context)this.context, (String)"com.anrongtec.ocr")) {
                        this.showAnrongDialog(this.getString(R.string.not_install_anrong_ocr));
                        return;
                    }
                    if (!ANRONGOCRActivity.isVersionOK((Context)this.context)) {
                        String targetVersion = "1.8";
                        String currentVersion = ANRONGOCRActivity.getVersion((Context)this.context, (String)"com.anrongtec.ocr");
                        this.showAnrongDialog(String.format(this.getString(R.string.wrong_ocr_version_1), targetVersion, currentVersion));
                        return;
                    }
                    OCR.ANRONG((Context)this, (int)1);
                    break;
                }
                case 0: {
                    OCR.XDJA((Context)this);
                    break;
                }
                case 1: {
                    Intent intent = new Intent((Context)this, OcrActivity.class);
                    Bundle others = new Bundle();
                    others.putString("faceImg", this.faceImg);
                    intent.putExtras(others);
                    this.startActivity(intent);
                }
            }
        }
    }

    private void showAnrongDialog(String text) {
        DialogUtil.install((Context)this, text, new DialogUtil.DialogInterface(){

            @Override
            public void onSuccess(Object ... objects) {
                ANRONGOCRActivity.goToAppStore((Context)ChooseBindWayActivity.this.context);
            }
        });
    }

    public static Intent buildIntent(Context context, String faceImg) {
        Intent intent = new Intent(context, ChooseBindWayActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString("faceImg", faceImg);
        intent.putExtras(bundle);
        return intent;
    }

    @Override
    protected boolean setDialogCancelable() {
        return false;
    }

    @Subscribe
    public void handleIDCardHeadResult(IDCardHeadResult result) {
        this.id.setName(result.getXm());
        this.id.setSex(result.getXb().equals("\u7537") ? 1 : 2);
        this.id.setBirthDate(result.getCsrq());
        this.id.setNation(result.getMz());
        this.id.setAddr(result.getCsdz());
        this.id.setIdNum(result.getSfzh());
        this.id.setPhoto("");
        this.next();
    }

    @Subscribe
    public void handleIDCardTailResult(IDCardTailResult result) {
        this.id.setIssueOffice(result.getDepartment());
        this.id.setValidDate(result.getValidDate());
        this.next();
    }

    @Subscribe
    public void handleFinishChooseEvent(FinishChooseEvent event) {
        this.finish();
    }

    private void scan(final int side) {
        this.showLoading();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ChooseBindWayActivity.this.dismissLoading();
                OCR.ANRONG((Context)ChooseBindWayActivity.this.context, (int)side);
            }
        }, 2000L);
    }

    @Override
    public void next() {
        if (!TextUtils.isEmpty((CharSequence)this.faceImg) && this.id != null) {
            if (TextUtils.isEmpty((CharSequence)this.id.getName())) {
                this.scan(1);
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.id.getIssueOffice())) {
                this.scan(2);
                return;
            }
            Bundle others = new Bundle();
            others.putString("faceImg", this.faceImg);
            others.putParcelable("identify_info", (Parcelable)this.id);
            Intent intent = new Intent((Context)this, AnrongOCRIDActivity.class);
            intent.putExtras(others);
            this.startActivity(intent);
        }
    }

    @Subscribe
    public void handleClearID(ClearIDEvent event) {
        this.id = null;
        this.id = new IDCardInfo();
    }

    protected boolean isOCRActivity() {
        return true;
    }

    @Subscribe
    public void handleFinish(ChooseBindwayEvent event) {
        this.finish();
    }
}

