/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation;

import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import cn.cloudwalk.CloudwalkSDK;
import cn.cloudwalk.libproject.util.FileUtil;
import com.aircert.ApplicationContext;
import com.alibaba.android.arouter.launcher.ARouter;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.cert_creationGeneratedDatabaseHolder;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.databases.DatabaseManager;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.service.HttpClientHelper;
import com.xdja.safeclient.certcreation.util.Util;
import com.zxy.tiny.Tiny;
import java.io.File;
import java.io.IOException;

public class ApplicationInit {
    public static void start(Application context) {
        ApplicationContext.setContext((Context)context);
        FlowManager.init((FlowConfig)new FlowConfig.Builder((Context)context).addDatabaseHolder(cert_creationGeneratedDatabaseHolder.class).build());
        Tiny.getInstance().init(context);
        ARouter.init((Application)context);
        ImageCache.init((Context)context);
        ApplicationInit.initCrytoDev((Context)context);
        ApplicationInit.initFaceSDK((Context)context);
        ApplicationInit.initConfig((Context)context);
        HttpClientHelper.initOkHttpClient();
    }

    private static void initCrytoDev(Context context) {
        CryptoDevManager cryptoDevManager = CryptoDevManager.getInstance();
        cryptoDevManager.setContext(context);
        cryptoDevManager.registerDriver((IDevDriver)new ChipManagerDriver());
        cryptoDevManager.setDisableSoft(false);
    }

    private static void initFaceSDK(final Context context) {
        File installation = new File(context.getFilesDir(), "modules");
        String storagePath = installation.getAbsolutePath();
        StringBuilder pFaceDetectFile = new StringBuilder(storagePath + File.separator + "faceDetector_2_4.mdl");
        StringBuilder pFaceKeyPtFile = new StringBuilder(storagePath + File.separator + "keypt_detect_model_sdm_9pts.bin");
        StringBuilder pFaceKeyPtTrackFile = new StringBuilder(storagePath + File.separator + "keypt_track_model_sdm_9pts.bin");
        StringBuilder pFaceQualityFile = new StringBuilder(storagePath + File.separator + "facequality_4_1.bin");
        StringBuilder pFaceLivenessFile = new StringBuilder(storagePath + File.separator + "liveness171120.bin");
        boolean allModulesExist = false;
        if (installation.exists() && new File(pFaceDetectFile.toString()).exists() && new File(pFaceKeyPtFile.toString()).exists() && new File(pFaceKeyPtTrackFile.toString()).exists() && new File(pFaceQualityFile.toString()).exists() && new File(pFaceLivenessFile.toString()).exists()) {
            allModulesExist = true;
        }
        if (!allModulesExist) {
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean initStage = false;
                    String dataDirPath = context.getFilesDir().getAbsolutePath();
                    try {
                        FileUtil.assetsDataToDest((Context)context, (String)"modules.zip", (String)(dataDirPath + File.separator + "modules.zip"));
                        FileUtil.unZipFolder((String)(dataDirPath + File.separator + "modules.zip"), (String)dataDirPath);
                        CloudwalkSDK.getInstance().setModulePath(dataDirPath + File.separator + "modules");
                        initStage = true;
                    }
                    catch (IOException ex) {
                        initStage = false;
                    }
                    catch (RuntimeException e) {
                        initStage = false;
                    }
                    catch (Exception e) {
                        initStage = false;
                    }
                    finally {
                        File modelsDir;
                        File modelsZip = new File(dataDirPath + File.separator + "modules.zip");
                        if (modelsZip.exists()) {
                            FileUtil.deleteFile((File)modelsZip);
                        }
                        if (!initStage && (modelsDir = new File(dataDirPath + File.separator + "modules")).exists()) {
                            FileUtil.deleteFile((File)modelsDir);
                        }
                    }
                }
            });
        } else {
            try {
                CloudwalkSDK.getInstance().setModulePath(context.getFilesDir().getAbsolutePath() + File.separator + "modules");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void initUpdate(Context context) {
    }

    private static void initConfig(Context context) {
        AppConfig module = AppConfig.getInstance();
        module.setContext(context);
        module.setContainerID(0);
        module.setCertType(0);
        module.setPin("111111");
        module.setBksVerifyCode("111111");
        module.setRole(1);
        if (Util.assetFileIsExist(context, "certDataBase.db")) {
            DatabaseManager.getInstance().copyAssetDatabase2PriPath(AppConfig.getInstance().getContext());
            ServerSettingConfig config = (ServerSettingConfig)SQLite.select((IProperty[])new IProperty[0]).from(ServerSettingConfig.class).querySingle();
            module.setServerIP(config.ip);
            module.setServerPort(config.port);
            module.setLiveCompany(config.liveCompany);
            module.setNfcCompany(config.nfcCompany);
            module.setOcrCompany(config.ocrCompany);
            module.setNfcServerIp(config.nfcServerIP);
            module.setNfcServerPort(config.nfcServerPort);
            module.setIsSupportCertContentUpdate(config.isSupportCertContentUpdate);
            module.setProject(config.cityName);
            module.setCaAlg(config.cert_alg == 0 ? "1.0" : "2.0");
            module.setCertNum(config.certNum);
        }
    }
}

