/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;
import com.aircert.SPermission;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.dialog.SinglePermissionDialog;
import com.aircert.listener.OnPermissionListener;
import com.aircert.util.HTMLText;
import com.alibaba.android.arouter.launcher.ARouter;
import com.squareup.otto.Subscribe;
import com.xdja.aspectjmodule.advise.AdvisePermission;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.AboutActivity;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.CertViewActivity$AjcClosure1;
import com.xdja.safeclient.certcreation.adapter.RecyclerViewAdapter;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.PhonePermissionResult;
import com.xdja.safeclient.certcreation.event.QueryFinishEvent;
import com.xdja.safeclient.certcreation.event.RequestPhonePermission;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleLog;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.ShareperencesUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class CertViewActivity
extends BaseActivity
implements View.OnClickListener {
    private RecyclerView recyclerView;
    private RecyclerViewAdapter recyclerViewAdapter;
    private RecyclerView.LayoutManager layoutManager;
    private LinearLayout noChip;
    private SwipeRefreshLayout swipe;
    private boolean isFirstStart = true;
    private String[] permissions = new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE"};
    private int type = -1;
    private String cardID;
    long last;
    private List<CertItemBean> certItemBeans = null;
    private boolean isResumeExe = true;
    SinglePermissionDialog dialog;
    public static long lastClickTime;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_cert_view);
        this.setToolbarRightBtn(R.drawable.settings, this);
        this.initView();
    }

    protected int getToolbarType() {
        return 1;
    }

    protected int getTitleRes() {
        return R.string.cert_view;
    }

    protected void onResume() {
        super.onResume();
        if (!this.isResumeExe) {
            return;
        }
        if (this.isFirstStart) {
            this.isFirstStart = false;
            if (this.checkValidPermission(this.permissions)) {
                this.getCertAndShow();
            } else {
                this.showInvalidPermissionDialog();
            }
        } else {
            this.getCertAndShow();
        }
    }

    private boolean checkValidPermission(String ... permissions) {
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    private void getCertAndShow() {
        if (this.recyclerViewAdapter != null && !this.recyclerViewAdapter.getIsRefresh()) {
            this.recyclerViewAdapter.setIsRefresh(true);
            return;
        }
        this.noChip = (LinearLayout)this.findViewById(R.id.no_chip);
        this.recyclerViewAdapter.clear();
        this.certItemBeans = this.getCertItemBeans();
        if (this.certItemBeans == null || this.certItemBeans.size() == 0) {
            this.swipe.setVisibility(8);
            this.noChip.setVisibility(0);
        } else {
            this.swipe.setVisibility(0);
            this.noChip.setVisibility(8);
            this.recyclerViewAdapter.addAll(this.certItemBeans);
        }
    }

    @XdjaPermission(permissions={"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE"})
    private void checkoutPermission() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        AdvisePermission advisePermission = AdvisePermission.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CertViewActivity$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = CertViewActivity.class.getDeclaredMethod("checkoutPermission", new Class[0]).getAnnotation(XdjaPermission.class);
        }
        advisePermission.weavePermission(proceedingJoinPoint, (XdjaPermission)annotation);
    }

    private void showInvalidPermissionDialog() {
        ArrayList<String> list = new ArrayList<String>();
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item1));
        }
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item2));
        }
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_PHONE_STATE") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item3));
        }
        String permission2 = HTMLText.formatPermissionText((Context)this, list);
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this.context);
        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission2);
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText(R.string.cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                CertViewActivity.this.checkoutPermission();
            }

            public void doCancel() {
                bindIdentifyDialog.dismiss();
                CertViewActivity.this.finish();
            }
        });
    }

    @Subscribe
    public void requestPhonePermission(RequestPhonePermission requestPhonePermission) {
        this.type = requestPhonePermission.type;
        this.cardID = requestPhonePermission.cardID;
        this.requestPhonePermission();
    }

    private void requestPhonePermission() {
        if (Build.VERSION.SDK_INT < 23) {
            this.sendPhonePermissionResult();
        } else {
            SPermission.with((Context)this.context).setMOUDLE(2).setmRequestCode(1).setPermissions(new String[]{"android.permission.READ_PHONE_STATE"}).setmOnPermissionListener(new OnPermissionListener(){

                public void onPermissionGranted() {
                    CertViewActivity.this.sendPhonePermissionResult();
                }

                public void onPermissionDenied(String[] deniedPermissions) {
                    CertViewActivity.this.showNoPhonePermissionDialog();
                }

                public void onPermissionDeniedAlways(String[] deniedPermissions) {
                    CertViewActivity.this.sendPhonePermissionResult();
                }
            }).requestPermissions();
        }
    }

    private void sendPhonePermissionResult() {
        OttoUtil.postPhonePermissionResult(this.type);
        this.type = -1;
    }

    @Subscribe
    public void onPhonePermission(PhonePermissionResult phonePermissionResult) {
        long current = System.currentTimeMillis();
        ModuleLog.e("current=" + current + "\nlast=" + this.last + "\n\u7ed3\u679c=" + String.valueOf(current - this.last));
        if (current - this.last > 1500L) {
            this.applyCert(phonePermissionResult.type);
        } else {
            ModuleLog.e("\u95f4\u9694\u592a\u77ed");
        }
        this.last = current;
    }

    private void applyCert(int cardType) {
        String imsi = DeviceWrapper.getInstance().getIMSI();
        if (imsi == null || imsi.equals("")) {
            ModuleToast.show(this.context, R.string.get_imsi_failed);
            return;
        }
        ShareperencesUtil.saveCurrentDevType(this.context, cardType);
        ShareperencesUtil.saveDevCardID(this.context, this.cardID);
        if (this.recyclerViewAdapter != null) {
            this.recyclerViewAdapter.setIsRefresh(false);
        }
        ARouter.getInstance().build("/cert/phone_info").withSerializable("cardType", (Serializable)CryptoDevTypeUtil.formatType(cardType)).withString("cardNum", this.cardID).navigation(this.context);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.recyclerViewAdapter != null) {
            this.recyclerViewAdapter.destroy();
        }
    }

    private List<CertItemBean> getCertItemBeans() {
        ArrayList<CertItemBean> certItemBeans = new ArrayList<CertItemBean>();
        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getInstance().getDevInfo();
        if (devInfoMap == null || devInfoMap.size() == 0) {
            return certItemBeans;
        }
        for (Map.Entry<Integer, CryptoDevInfo> cryptoDevInfoEntry : devInfoMap.entrySet()) {
            CertItemBean certItemBean = new CertItemBean();
            if (cryptoDevInfoEntry.getKey().intValue() == CryptoDevType.DEV_TYPE_SdCard.getType()) {
                certItemBean.setType(CryptoDevType.DEV_TYPE_SdCard);
            } else if (cryptoDevInfoEntry.getKey().intValue() == CryptoDevType.DEV_TYPE_SimKey.getType()) {
                certItemBean.setType(CryptoDevType.DEV_TYPE_SimKey);
            } else if (cryptoDevInfoEntry.getKey().intValue() == CryptoDevType.DEV_TYPE_Soft.getType()) {
                certItemBean.setType(CryptoDevType.DEV_TYPE_Soft);
            } else if (cryptoDevInfoEntry.getKey().intValue() == CryptoDevType.DEV_TYPE_Chip.getType()) {
                certItemBean.setType(CryptoDevType.DEV_TYPE_Chip);
            }
            certItemBean.setCryptoDevInfo(cryptoDevInfoEntry.getValue());
            certItemBeans.add(certItemBean);
        }
        return certItemBeans;
    }

    private void initView() {
        this.swipe = (SwipeRefreshLayout)this.findViewById(R.id.swipe);
        this.swipe.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                CertViewActivity.this.pullToRefresh();
            }
        });
        this.swipe.setEnabled(!FeatureConfig.getInstance().isDisablePullToRefresh());
        this.layoutManager = new LinearLayoutManager((Context)this, 1, false);
        this.recyclerViewAdapter = new RecyclerViewAdapter((Context)this);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerview);
        this.recyclerView.setLayoutManager(this.layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerViewAdapter);
        if (this.hideSettings()) {
            this.rightBtn.setVisibility(8);
        } else {
            this.rightBtn.setVisibility(0);
        }
    }

    private void pullToRefresh() {
        this.recyclerViewAdapter.refresh();
    }

    boolean hideSettings() {
        return FeatureConfig.getInstance().isHideSetting();
    }

    public void onClick(View view) {
        if (view.getId() == R.id.title_right_btn) {
            if (FeatureConfig.getInstance().isHideSetting()) {
                return;
            }
            Intent intent = new Intent();
            intent.setClass((Context)this, AboutActivity.class);
            this.startActivity(intent);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        SPermission.onRequestPermissionsResult((int)requestCode, (String[])permissions, (int[])grantResults);
    }

    public void showNoPhonePermissionDialog() {
        if (this.dialog == null) {
            this.initNoPermissionDialog();
        }
        this.dialog.show();
    }

    private void initNoPermissionDialog() {
        this.dialog = new SinglePermissionDialog();
        this.dialog.build((Context)this, 0);
    }

    private void gotoSetting() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.getPackageName(), null);
        intent.setData(uri);
        this.startActivity(intent);
    }

    public void finish() {
        super.finish();
        new CertService().cancelAll();
    }

    @Override
    public void onBackPressed() {
        if (FeatureConfig.getInstance().isDisableDoubleClickToExit()) {
            super.onBackPressed();
        } else if (lastClickTime == 0L) {
            lastClickTime = System.currentTimeMillis();
            ModuleToast.show((Context)this, R.string.click_one_more);
        } else {
            long current = System.currentTimeMillis();
            if (current - lastClickTime < 1000L) {
                super.onBackPressed();
            } else {
                ModuleToast.show((Context)this, R.string.click_one_more);
            }
            lastClickTime = current;
        }
    }

    @Subscribe
    public void handleQueryFinished(QueryFinishEvent event) {
        this.swipe.setRefreshing(false);
    }

    static {
        CertViewActivity.ajc$preClinit();
    }

    static final /* synthetic */ void checkoutPermission_aroundBody0(CertViewActivity ajc$this, JoinPoint joinPoint) {
        if (Build.VERSION.SDK_INT < 23) {
            ajc$this.getCertAndShow();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CertViewActivity.java", CertViewActivity.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkoutPermission", "com.xdja.safeclient.certcreation.activity.CertViewActivity", "", "", "", "void"), 157);
    }
}

