/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.view;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aircert.BusProvider;
import com.aircert.dialog.SinglePermissionDialog;
import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.aircert.util.WeakReferenceHandler;
import com.alibaba.android.arouter.launcher.ARouter;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.RecyclerViewAdapter;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.MobileInfo;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.CertApplyRequest;
import com.xdja.safeclient.certcreation.bean.request.CertStateRequest;
import com.xdja.safeclient.certcreation.bean.request.WriteFailInfo;
import com.xdja.safeclient.certcreation.bean.request.WriteFailRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceUtil;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.service.ChipExecutorService;
import com.xdja.safeclient.certcreation.util.AnimUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.Util;
import java.io.IOException;
import java.io.Serializable;
import okhttp3.Call;
import okhttp3.RequestBody;

public class CertItemView
extends RelativeLayout {
    private FrameLayout container_child;
    private View marginView;
    private ImageView inUse;
    private ChipBean chipBean;
    private Context context;
    private static final int QUERY_CERTINFO_FROM_SERVER = 0;
    private static final int APPLY_CERT_REQUEST = 1;
    private static final int QUERY_AUTHENTIATION_RESULT = 2;
    private static final int IMPORT_CERT_FAIL = 3;
    private String object;
    private String cardID;
    private CryptoDevType chipBeanType;
    private RecyclerViewAdapter recyclerViewAdapter;
    private boolean isCertOK = false;
    private CertItemBean certItemBean;
    private ChipExecutorService chipExecutorService = new ChipExecutorService();
    private static final int TAG_QUERY_CERT_STATE = 0;
    private MyHandler myHandler = new MyHandler(this);
    private CertService certService = new CertService();

    public CertItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.cert_item_layout, (ViewGroup)this);
        BusProvider.register((Object)((Object)this));
    }

    public boolean isCertOK() {
        return this.isCertOK;
    }

    public void setData(Context context, RecyclerViewAdapter recyclerViewAdapter, CertItemBean certItemBean, String object) {
        this.object = object;
        this.context = context;
        this.certItemBean = certItemBean;
        this.isCertOK = false;
        this.chipBeanType = this.certItemBean.getType();
        this.cardID = DeviceWrapper.getInstance().getCardID(this.chipBeanType);
        this.recyclerViewAdapter = recyclerViewAdapter;
        this.initView();
        if (TextUtils.isEmpty((CharSequence)this.cardID)) {
            this.showErrorResponseLayout(context.getString(R.string.card_not_exist));
            return;
        }
        RequestCache.getInstance().putType(this.cardID, this.chipBeanType.getType());
        this.queryCertInfo();
    }

    private void queryCertInfo() {
        this.showChecking();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int type = CertItemView.this.chipBeanType.getType();
                ChipBean bean = new ChipBean();
                bean.setType(type);
                CertDetailInfo info = DeviceWrapper.getInstance().readCertFromContainer(CertItemView.this.chipBeanType, AppConfig.getInstance().getContainerID(), AppConfig.getInstance().getCertType());
                if (info != null) {
                    ModuleLog.d((String)"CertItemView", (Object)info);
                }
                bean.setCertDetailInfo(info);
                if (info == null) {
                    bean.setState(CertState.NO_CERT);
                } else if (!Util.certIsValid(bean.getCertBean())) {
                    bean.setState(CertState.CERT_OUT_OF_DATE);
                } else {
                    bean.setState(CertState.SUCCESS);
                }
                CertItemView.this.chipExecutorService.sendMessage(CertItemView.this.myHandler, 0, bean);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    public ChipBean getChipBean() {
        return this.chipBean;
    }

    private void initView() {
        TextView name = (TextView)this.findViewById(R.id.name);
        this.container_child = (FrameLayout)this.findViewById(R.id.container_child);
        this.marginView = this.findViewById(R.id.margin);
        if (this.certItemBean.getType() == CryptoDevType.DEV_TYPE_SdCard) {
            name.setText(R.string.tf_cert);
        } else if (this.certItemBean.getType() == CryptoDevType.DEV_TYPE_Chip) {
            name.setText(R.string.chip_cert);
        } else if (this.certItemBean.getType() == CryptoDevType.DEV_TYPE_SimKey) {
            name.setText(R.string.tiemo_cert);
        } else if (this.certItemBean.getType() == CryptoDevType.DEV_TYPE_Soft) {
            name.setText(R.string.soft_cert);
        }
        TextView cardNo = (TextView)this.findViewById(R.id.card_num);
        cardNo.setText((CharSequence)this.certItemBean.getCryptoDevInfo().getCardId());
        this.inUse = (ImageView)this.findViewById(R.id.in_use);
        if (this.chipBean != null || DeviceWrapper.getInstance().getInUse() == null) {
            if (this.chipBean.getCertBean() != null) {
                if (DeviceWrapper.getInstance().getInUse().equals(this.chipBean.getCertBean().sn)) {
                    this.inUse.setVisibility(0);
                } else {
                    this.inUse.setVisibility(8);
                }
            } else {
                this.inUse.setVisibility(8);
            }
        } else {
            this.inUse.setVisibility(8);
        }
        this.container_child.setVisibility(0);
    }

    public boolean inUse() {
        return this.inUse.getVisibility() == 0;
    }

    private void showChecking() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_loading, null, true);
        ImageView imageView = (ImageView)view.findViewById(R.id.iv_icon);
        AnimUtil.rotate(this.context, (View)imageView);
        this.showView(view);
        this.marginView.setVisibility(0);
    }

    private void showErrorResponseLayout(String title, String message, boolean isReapply) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        TextView fail_reason = (TextView)view.findViewById(R.id.fail_reason);
        View bottom_button_layout = view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button)view.findViewById(R.id.tv_apply);
        fail_reason.setText((CharSequence)message);
        if (isReapply) {
            bottom_button_layout.setVisibility(0);
            tv_apply.setText(R.string.reapply);
            bottom_button_layout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ModuleLog.d((Object)"0showErrorResponseLayout,\u8bf7\u6c42\u6743\u9650");
                    CertItemView.this.requestPhonePermission();
                }
            });
        } else {
            bottom_button_layout.setVisibility(8);
        }
        if (FeatureConfig.getInstance().isDisableMakeNewCert()) {
            bottom_button_layout.setVisibility(8);
        }
        if (message.contains(this.context.getString(R.string.server_error_short))) {
            tv_apply.setText(R.string.retry);
            tv_apply.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.queryCertStateFromServer();
                }
            });
        }
        this.showView(view);
    }

    private void showErrorResponseLayout(String message) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        view.findViewById(R.id.fail_reason).setVisibility(0);
        Button button = (Button)view.findViewById(R.id.tv_apply);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ModuleLog.d((String)"0showErrorResponseLayout", (Object)"\u8bf7\u6c42\u6743\u9650");
                CertItemView.this.requestPhonePermission();
            }
        });
        if (message.contains(this.context.getString(R.string.server_error_short)) || message.contains(this.context.getString(R.string.app_time_exception_user))) {
            button.setText(R.string.retry);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.queryCertStateFromServer();
                }
            });
        }
        if (message.contains("\u5b89\u5168\u8bbe\u5907\u5931\u8d25")) {
            button.setText(R.string.retry);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.cardID = DeviceWrapper.getInstance().getCardID(CertItemView.this.chipBeanType);
                    if (TextUtils.isEmpty((CharSequence)CertItemView.this.cardID)) {
                        CertItemView.this.showErrorResponseLayout(CertItemView.this.context.getString(R.string.card_not_exist));
                        return;
                    }
                    CertItemView.this.queryCertStateFromServer();
                }
            });
        }
        TextView content = (TextView)view.findViewById(R.id.fail_reason);
        content.setText((CharSequence)message);
        this.showView(view);
    }

    private void show(String message, int click) {
    }

    private void showNoCert() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_no_cert, null);
        view.findViewById(R.id.apply_cert_layout).setVisibility(FeatureConfig.getInstance().isDisableMakeNewCert() ? 8 : 0);
        view.findViewById(R.id.apply_cert_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ModuleLog.d((Object)"0showNoCert, \u8bf7\u6c42\u6743\u9650");
                CertItemView.this.requestPhonePermission();
            }
        });
        this.showView(view);
    }

    private void requestPhonePermission() {
        ModuleLog.d((Object)"1\u70b9\u51fb\u51c6\u5907\u7533\u8bf7\u8bc1\u4e66");
        this.applyCert(this.chipBeanType.getType());
    }

    private void applyCert(int cardType) {
        String imsi = DeviceWrapper.getInstance().getIMSI();
        if (imsi == null || imsi.equals("")) {
            SinglePermissionDialog dialog = new SinglePermissionDialog();
            dialog.build(this.context, this.context.getString(R.string.get_imsi_failed));
            dialog.show();
            return;
        }
        SharePreferencesUtil.saveCurrentDevType(this.context, cardType);
        SharePreferencesUtil.saveDevCardID(this.context, this.cardID);
        if (this.recyclerViewAdapter != null) {
            this.recyclerViewAdapter.setIsRefresh(false);
        }
        SharePreferencesUtil.saveActivityObjectName(this.context, this.object);
        RequestCache.getInstance().setObject(this.object);
        ARouter.getInstance().build("/cert/phone_info").withSerializable("cardType", (Serializable)CryptoDevTypeUtil.formatType(cardType)).withString("cardNum", this.cardID).navigation(this.context);
        ModuleLog.time((String[])new String[]{"\u51c6\u5907\u542f\u52a8"});
    }

    private void showOtherFailLayout(final int requestType, final String p10) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        TextView reason = (TextView)view.findViewById(R.id.fail_reason);
        RelativeLayout reApply = (RelativeLayout)view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button)view.findViewById(R.id.tv_apply);
        int netRes = -1;
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            netRes = R.string.net_disconnected_text;
            this.chipBean.setState(CertState.NET_ERROR);
        } else {
            netRes = R.string.net_timeout;
            this.chipBean.setState(CertState.NET_TIMEOUT);
        }
        switch (requestType) {
            case 0: {
                if (this.chipBean.getCertBean() != null) {
                    this.showCertDetail(netRes, this.chipBean);
                    view.setVisibility(8);
                    return;
                }
                if (netRes != -1) break;
                netRes = R.string.cert_state_query_fail;
                break;
            }
            case 1: {
                netRes = R.string.register_fail_reapply;
                break;
            }
            case 2: {
                netRes = R.string.authentiation_result_fail;
                break;
            }
            case 3: {
                netRes = R.string.write_authentiation_fail;
            }
        }
        reason.setText(netRes);
        tv_apply.setText(R.string.retry);
        reApply.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean isNetOK = CommonUtil.isNetworkConnected((Context)CertItemView.this.context);
                switch (requestType) {
                    case 0: {
                        if (isNetOK) {
                            CertItemView.this.showChecking();
                            CertItemView.this.queryCertStateFromServer();
                            break;
                        }
                        ModuleToast.show(CertItemView.this.context, R.string.net_disconnected_text);
                        break;
                    }
                    case 1: {
                        if (isNetOK) {
                            CertItemView.this.showChecking();
                            CertItemView.this.applyCertRequest(p10);
                            ModuleLog.e((Object)"\u7533\u8bf7\u8bc1\u4e66 CertItemView showOtherFailLayout line 409");
                            break;
                        }
                        ModuleToast.show(CertItemView.this.context, R.string.net_disconnected_text);
                        break;
                    }
                    case 2: {
                        if (isNetOK) {
                            CertItemView.this.showChecking();
                            CertItemView.this.queryAuthenticationResult();
                            break;
                        }
                        ModuleToast.show(CertItemView.this.context, R.string.net_disconnected_text);
                        break;
                    }
                    case 3: {
                        ModuleLog.d((Object)"0IMPORT_CERT_FAIL, \u8bf7\u6c42\u6743\u9650");
                        CertItemView.this.requestPhonePermission();
                    }
                }
            }
        });
        this.showView(view);
    }

    private void showRegisterFail() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_no_cert, null);
        TextView cert_item_top_one_content = (TextView)view.findViewById(R.id.cert_item_top_one_content);
        View reApply = view.findViewById(R.id.apply_cert_layout);
        cert_item_top_one_content.setText(R.string.register_fail_reapply);
        reApply.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ModuleLog.d((Object)"0showRegisterFail, \u8bf7\u6c42\u6743\u9650");
                CertItemView.this.requestPhonePermission();
            }
        });
        this.showView(view);
    }

    private void showWaiteVerity() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_wait, null);
        view.findViewById(R.id.refresh).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CertItemView.this.showChecking();
                CertItemView.this.queryAuthenticationResult();
            }
        });
        this.showView(view);
    }

    private void showCertDetail(final @StringRes int strRes, final ChipBean chipBean) {
        this.chipBean = chipBean;
        this.isCertOK = true;
        final View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_detail, null);
        this.myHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                RelativeLayout forward = (RelativeLayout)view.findViewById(R.id.cert_status);
                if (FeatureConfig.getInstance().isOnlyShowCertList()) {
                    forward.setVisibility(8);
                } else {
                    forward.setVisibility(0);
                }
                TextView tv_cert_state = (TextView)view.findViewById(R.id.tv_cert_state);
                TextView tv_container = (TextView)view.findViewById(R.id.tv_container);
                TextView tv_sn = (TextView)view.findViewById(R.id.tv_sn);
                TextView tv_user = (TextView)view.findViewById(R.id.tv_user);
                TextView tv_peroid = (TextView)view.findViewById(R.id.tv_peroid);
                tv_container.setText((CharSequence)(CertItemView.this.context.getString(R.string.cert_container) + "                #" + AppConfig.getInstance().getContainerID()));
                if (strRes == R.string.normal_state_item) {
                    tv_cert_state.setTextColor(CertItemView.this.getResources().getColor(R.color.cert_normal_success));
                } else if (strRes == R.string.be_frozen || strRes == R.string.thaw_reject || strRes == R.string.update_reject || strRes == R.string.server_nocert || strRes == R.string.cert_out_of_date || strRes == R.string.revoke_success || strRes == R.string.revoke_reject || strRes == R.string.cert_not_in_system || strRes == R.string.net_disconnected_text || strRes == R.string.net_timeout) {
                    tv_cert_state.setTextColor(CertItemView.this.getResources().getColor(R.color.cert_fail_error));
                } else if (strRes == R.string.revoke_ing || strRes == R.string.thaw_ing || strRes == R.string.update_ing) {
                    tv_cert_state.setTextColor(CertItemView.this.getResources().getColor(R.color.cert_ing));
                }
                tv_cert_state.setText(strRes);
                CertDetailInfo certDetailInfo = chipBean.getCertBean();
                if (certDetailInfo == null) {
                    return;
                }
                String sn = CertItemView.this.context.getString(R.string.cert_sn) + "                " + certDetailInfo.sn;
                tv_sn.setText((CharSequence)sn);
                String owner = CertItemView.this.context.getString(R.string.cert_owner) + "                " + CertItemView.this.getCertHolder(certDetailInfo.subjectCn);
                tv_user.setText((CharSequence)owner);
                String peroid = CertItemView.this.context.getString(R.string.cert_period) + "            " + certDetailInfo.indate;
                tv_peroid.setText((CharSequence)peroid);
                CertItemView.this.showView(view);
                CertItemView.this.marginView.setVisibility(0);
            }
        }, 10L);
    }

    private void showView(View view) {
        this.marginView.setVisibility(8);
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    private String getCertHolder(String sn) {
        String[] split = sn.split(",");
        for (int i = 0; i < split.length; ++i) {
            String cnStr = split[i];
            if (!cnStr.contains("CN=")) continue;
            int beginIndex = 3;
            int length = cnStr.length();
            return split[i].substring(beginIndex, length);
        }
        return "";
    }

    private void queryCertStateFromServer() {
        this.showChecking();
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            this.showOtherFailLayout(0, null);
            OttoUtil.postQueryFishied();
            return;
        }
        CertStateRequest certStateRequest = new CertStateRequest();
        if (this.chipBean.getCertBean() != null) {
            String sn = this.chipBean.getCertBean().sn;
            certStateRequest.setSn(sn);
        } else {
            certStateRequest.setSn("");
        }
        certStateRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(this.chipBeanType.getType()));
        this.certService.certStateQuery(certStateRequest, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                CertItemView.this.showOtherFailLayout(0, null);
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertItemView.this.showOtherFailLayout(0, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                if (result.equals("0")) {
                    CertItemView.this.showCertDetail(R.string.revoke_ing, CertItemView.this.chipBean);
                    CertItemView.this.chipBean.setState(CertState.WAITING_AGREE_REVOKE);
                    CertItemView.this.isCertOK = true;
                } else if (result.equals("1")) {
                    CertItemView.this.showCertDetail(R.string.revoke_success, CertItemView.this.chipBean);
                    CertItemView.this.chipBean.setState(CertState.AGREE_REVOKE);
                    CertItemView.this.isCertOK = true;
                } else if (result.equals("2")) {
                    CertItemView.this.showCertDetail(R.string.revoke_reject, CertItemView.this.chipBean);
                    CertItemView.this.chipBean.setState(CertState.REJECT_REVOKE);
                    CertItemView.this.chipBean.setReason(commonResponse.getMessage());
                    CertItemView.this.isCertOK = true;
                } else if (result.equals("3")) {
                    if (CertItemView.this.isChipBeanSizeIsZero()) {
                        CertItemView.this.showErrorResponseLayout(CertItemView.this.context.getString(R.string.cert_query_fail), CertItemView.this.context.getString(R.string.cert_not_incard), false);
                    } else {
                        CertItemView.this.isCertOK = true;
                        if (CertItemView.this.chipBean.getState() == CertState.CERT_OUT_OF_DATE) {
                            CertItemView.this.chipBean.setState(CertState.CERT_OUT_OF_DATE);
                            CertItemView.this.showCertDetail(R.string.cert_out_of_date, CertItemView.this.chipBean);
                        } else {
                            CertItemView.this.chipBean.setState(CertState.SUCCESS);
                            CertItemView.this.showCertDetail(R.string.normal_state_item, CertItemView.this.chipBean);
                        }
                    }
                } else if (result.equals("4")) {
                    if (CertItemView.this.isChipBeanSizeIsZero()) {
                        CertItemView.this.queryAuthenticationResult();
                    } else {
                        CertItemView.this.showCertDetail(R.string.server_nocert, CertItemView.this.chipBean);
                        CertItemView.this.chipBean.setState(CertState.SERVER_NOCERT);
                    }
                } else if (result.equals("5")) {
                    CertItemView.this.showCertDetail(R.string.be_frozen, CertItemView.this.chipBean);
                } else if (result.equals("6")) {
                    CertItemView.this.showCertDetail(R.string.thaw_ing, CertItemView.this.chipBean);
                } else if (result.equals("7")) {
                    CertItemView.this.showCertDetail(R.string.thaw_reject, CertItemView.this.chipBean);
                } else if (result.equals("8")) {
                    CertItemView.this.showCertDetail(R.string.delay_ing, CertItemView.this.chipBean);
                } else if (result.equals("9")) {
                    CertItemView.this.showCertDetail(R.string.normal_state_item, CertItemView.this.chipBean);
                } else if (result.equals("10")) {
                    CertItemView.this.showCertDetail(R.string.delay_reject, CertItemView.this.chipBean);
                } else if (result.equals("11")) {
                    CertItemView.this.showCertDetail(R.string.update_ing, CertItemView.this.chipBean);
                } else if (result.equals("12")) {
                    CertItemView.this.chipBean.setState(CertState.AGREE_UPDATE);
                    CertItemView.this.showCertDetail(R.string.normal_state_item, CertItemView.this.chipBean);
                } else if (result.equals("13")) {
                    CertItemView.this.showCertDetail(R.string.update_reject, CertItemView.this.chipBean);
                } else if (result.equals("14")) {
                    CertItemView.this.chipBean.setState(CertState.CERT_OUT_OF_DATE);
                    CertItemView.this.showCertDetail(R.string.cert_out_of_date, CertItemView.this.chipBean);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    @Subscribe
    public void updateCertState(ChipBean chipBean) {
        if (chipBean.getType() != this.chipBeanType.getType()) {
            return;
        }
        CertState state = chipBean.getState();
        if (state == CertState.AGREE_UPDATE) {
            this.isCertOK = true;
            chipBean.setState(CertState.SUCCESS);
            this.showCertDetail(R.string.normal_state_item, chipBean);
        } else if (state == CertState.WAITING_AGREE_REVOKE) {
            this.showCertDetail(R.string.revoke_ing, chipBean);
            chipBean.setState(CertState.WAITING_AGREE_REVOKE);
            this.isCertOK = true;
        } else if (state == CertState.AGREE_REVOKE) {
            this.showCertDetail(R.string.revoke_success, chipBean);
            chipBean.setState(CertState.AGREE_REVOKE);
            this.isCertOK = true;
        } else if (state == CertState.RECOVERY_PROGRESS) {
            this.showCertDetail(R.string.recovery_progress, chipBean);
            chipBean.setState(CertState.RECOVERY_PROGRESS);
            this.isCertOK = true;
        } else if (state == CertState.RECOVERY_SUCCESS) {
            this.isCertOK = true;
            chipBean.setState(CertState.SUCCESS);
            this.showCertDetail(R.string.normal_state_item, chipBean);
        } else if (state == CertState.REJECT_REVOKE) {
            this.showCertDetail(R.string.revoke_reject, chipBean);
            chipBean.setState(CertState.REJECT_REVOKE);
            this.isCertOK = true;
        } else {
            this.isCertOK = false;
            this.showNoCert();
        }
    }

    private void writeCert(final String cert2) {
        if (TextUtils.isEmpty((CharSequence)cert2)) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final int result = DeviceWrapper.getInstance().importCert(CertItemView.this.chipBeanType, cert2);
                CertItemView.this.myHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (result == 0) {
                            CertItemView.this.showCertDetail(CertItemView.this.chipBeanType);
                            CertItemView.this.notifySafeAccess(CertItemView.this.context);
                        } else {
                            CertItemView.this.writeCertToServer(cert2, "1");
                        }
                    }
                }, 10L);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private void notifySafeAccess(Context context) {
        Intent intent = new Intent("com.xdja.aircert.write.success");
        context.sendBroadcast(intent);
    }

    private void showCertDetail(final CryptoDevType cryptoDevType) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final CertDetailInfo certDetailInfo = DeviceWrapper.getInstance().readCertFromContainer(cryptoDevType, AppConfig.getInstance().getContainerID(), AppConfig.getInstance().getCertType());
                CertItemView.this.myHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ChipBean chipBean = new ChipBean();
                        chipBean.setType(CertItemView.this.chipBean.getType());
                        chipBean.setCertDetailInfo(certDetailInfo);
                        if (!Util.certIsValid(chipBean.getCertBean())) {
                            chipBean.setState(CertState.CERT_OUT_OF_DATE);
                            CertItemView.this.showCertDetail(R.string.cert_out_of_date, chipBean);
                        } else {
                            chipBean.setState(CertState.SUCCESS);
                            if (chipBean.getState() == CertState.SUCCESS && !chipBean.getIsVerify()) {
                                CertItemView.this.showCertDetail(R.string.cert_not_in_system, chipBean);
                            } else {
                                CertItemView.this.showCertDetail(R.string.normal_state_item, chipBean);
                            }
                        }
                        chipBean.setName(CertItemView.this.getBeanName(CertItemView.this.chipBeanType));
                    }
                }, 10L);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private void writeCertToServer(final String cert2, final String status) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String sn = DeviceWrapper.getInstance().getSn(CertItemView.this.chipBeanType, cert2);
                Looper.prepare();
                ModuleToast.show(CertItemView.this.context, R.string.import_cert_fail);
                final WriteFailRequest request = new WriteFailRequest();
                WriteFailInfo info = new WriteFailInfo();
                info.setSn(sn);
                info.setStatus(status);
                info.setTime(System.currentTimeMillis());
                request.setInfo(info);
                final String sign = DeviceWrapper.getInstance().signData(CertItemView.this.chipBeanType, info.toString());
                CertItemView.this.myHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (sign.startsWith("errorCode")) {
                            CertItemView.this.showErrorResponseLayout(sign.substring(9));
                        } else {
                            request.setSign(sign);
                            request.setCardType("" + CryptoDevTypeUtil.convertCardType(CertItemView.this.chipBeanType.getType()));
                            CertItemView.this.uploadWriteCertResult(request);
                        }
                    }
                });
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private void uploadWriteCertResult(RequestBody request) {
        this.certService.uploadWriteCertResult(request, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertItemView.this.showOtherFailLayout(0, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                ModuleLog.e((Object)"\u4e0a\u62a5\u5199\u5361\u5931\u8d25\u6210\u529f\uff1a ");
                CertItemView.this.showOtherFailLayout(3, "");
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private int getBeanName(CryptoDevType type) {
        switch (type) {
            case DEV_TYPE_SdCard: {
                return R.string.tf_cert;
            }
            case DEV_TYPE_Chip: {
                return R.string.chip_cert;
            }
            case DEV_TYPE_SimKey: {
                return R.string.tiemo_cert;
            }
            case DEV_TYPE_Soft: {
                return R.string.soft_cert;
            }
        }
        return R.string.chip_cert;
    }

    private boolean isChipBeanSizeIsZero() {
        return this.chipBean.getState() == CertState.NO_CERT;
    }

    private void queryAuthenticationResult() {
        int company = AppConfig.getInstance().getLiveCompany();
        if (company == 3) {
            this.showNoCert();
            return;
        }
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            this.showOtherFailLayout(2, null);
            return;
        }
        int checkResult = SharePreferencesUtil.getCheckResult(this.context, this.chipBeanType.getType());
        if (checkResult != 0) {
            this.showNoCert();
            return;
        }
        String identityNum = SharePreferencesUtil.getIDCardNo(this.context, this.chipBean.getType());
        if (TextUtils.isEmpty((CharSequence)identityNum)) {
            return;
        }
        this.certService.queryAuthenticationResult(identityNum, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                if (e instanceof CardNotExistException) {
                    CertItemView.this.showErrorResponseLayout("\u8bbe\u5907\u4e0d\u5b58\u5728", "\u8bf7\u91cd\u65b0\u7533\u8bf7", true);
                } else {
                    e.printStackTrace();
                }
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertItemView.this.showOtherFailLayout(2, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                CertItemView.this.handleAuthResult(commonResponse);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void handleErrorResponse(String errorCode) {
        if (errorCode.equals(OkNetError.NOT_FOUND_CHECK_INFO_CODE)) {
            this.showNoCert();
        } else if (errorCode.equals(OkNetError.NOT_EXIST_INFO_CODE)) {
            if (this.isChipBeanSizeIsZero()) {
                this.queryAuthenticationResult();
            } else {
                this.chipBean.setState(CertState.SERVER_NOCERT);
                this.showCertDetail(R.string.server_nocert, this.chipBean);
            }
        } else {
            String msg = OkNetError.handleErrorCodeToMsg(this.context, errorCode);
            this.showErrorResponseLayout(msg);
        }
    }

    private void applyCertRequest(final String p10) {
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            ModuleToast.show(this.context, R.string.net_disconnected_text);
            return;
        }
        if (p10.startsWith("errorCode")) {
            if (p10.contains("^[0-6]*$")) {
                // empty if block
            }
            this.handleErrorResponse(p10.substring(9));
            return;
        }
        if (p10.isEmpty()) {
            // empty if block
        }
        CertApplyRequest certApplyRequest = new CertApplyRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(this.chipBean.getType()));
        chipInfo.setImei(deviceWrapper.getIMEI());
        String imsi = deviceWrapper.getIMSI();
        if (imsi == null || imsi.equals("")) {
            this.showErrorResponseLayout(this.context.getString(R.string.register_fail_reapply), this.context.getString(R.string.get_imsi_failed), true);
            return;
        }
        chipInfo.setImsi(deviceWrapper.getIMSI());
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum(this.context));
        certApplyRequest.setChipInfo(chipInfo);
        MobileInfo mobileInfo = new MobileInfo();
        mobileInfo.setCommType(DeviceUtil.getInstance().getOperator() + "");
        mobileInfo.setTerminalBand(DeviceUtil.getInstance().getBrand());
        mobileInfo.setTerminalType("1");
        certApplyRequest.setMobileInfo(mobileInfo);
        int liveCompany = AppConfig.getInstance().getLiveCompany();
        if (liveCompany != 3) {
            certApplyRequest.setIdentityNo(SharePreferencesUtil.getIDCardNo(this.context, this.chipBean.getType()));
        } else {
            certApplyRequest.setIdentityNo(SharePreferencesUtil.getPhoneNum(this.context));
        }
        certApplyRequest.setP10(p10);
        this.certService.applyCert(certApplyRequest, this.cardID, new HttpResponseCallBack<CertApplyResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertItemView.this.showOtherFailLayout(1, p10);
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyResponse certApplyResponse) {
                String cert2 = certApplyResponse.getCert();
                CertItemView.this.writeCert(cert2);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    @Subscribe
    public void onPhoneResult(PhoneResult result) {
        if (result != null) {
            this.handlePhoneResult(result);
        }
    }

    private void handlePhoneResult(PhoneResult auth) {
        CryptoDevType type = auth.getType();
        CompareResult result = auth.getResult();
        if (this.chipBeanType == null || type == null) {
            return;
        }
        if (type.getType() != this.chipBeanType.getType()) {
            return;
        }
        if (result.isSuccess()) {
            String ret = result.getResult();
            SharePreferencesUtil.saveCheckResult(this.context, this.chipBeanType.getType(), Integer.parseInt(ret));
            switch (ret) {
                case "0": {
                    break;
                }
                case "1": 
                case "2": {
                    this.showErrorResponseLayout(this.context.getString(R.string.register_fail_reapply), this.context.getString(R.string.phone_number_wrong), true);
                }
            }
        }
    }

    @Subscribe
    public void onAuthResult(AuthResult result) {
        if (result == null) {
            return;
        }
        if (result.getObject() == null) {
            return;
        }
        if (!result.getObject().equals(this.object)) {
            return;
        }
        ModuleLog.e((Object)("\u8bf7\u6c42\uff1a" + result.getObject() + "\n\u5f53\u524d\uff1a" + this.object));
        this.handleAuthResult(result);
    }

    private void handleAuthResult(AuthResult auth) {
        CryptoDevType type = auth.getType();
        CompareResult result = auth.getResult();
        if (this.chipBeanType == null || type == null) {
            return;
        }
        if (type.getType() != this.chipBeanType.getType()) {
            return;
        }
        if (result.isSuccess()) {
            this.handleAuthResult(result);
        } else {
            String message = result.getMessage();
            if (TextUtils.isEmpty((CharSequence)message)) {
                this.showRegisterFail();
            } else {
                this.showErrorResponseLayout(this.context.getString(R.string.register_fail_reapply), OkNetError.handleErrorCodeToMsg(this.context, result.getErrCode()), true);
            }
        }
    }

    private void handleAuthResult(CommonResponse result) {
        this.showChecking();
        String ret = result.getResult();
        SharePreferencesUtil.saveCheckResult(this.context, this.chipBeanType.getType(), Integer.parseInt(ret));
        switch (ret) {
            case "0": {
                this.showWaiteVerity();
                break;
            }
            case "1": {
                String message = result.getMessage();
                this.getP10ReqestBCAndApplyCert(message);
                break;
            }
            case "2": {
                String message = result.getMessage();
                if (TextUtils.isEmpty((CharSequence)message)) {
                    this.showRegisterFail();
                    break;
                }
                this.showErrorResponseLayout(this.context.getString(R.string.register_fail_reapply), message, true);
            }
        }
    }

    private void getP10ReqestBCAndApplyCert(final String dn) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final String p10ReqestBC = PKCS10Utils.getInstance().getP10RequestBC(CertItemView.this.chipBeanType, dn, true);
                if (TextUtils.isEmpty((CharSequence)p10ReqestBC)) {
                    CertItemView.this.myHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            CertItemView.this.showErrorResponseLayout(CertItemView.this.context.getString(R.string.register_fail_reapply), CertItemView.this.context.getString(R.string.device_not_exist), true);
                        }
                    }, 10L);
                    return;
                }
                CertItemView.this.myHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        CertItemView.this.applyCertRequest(p10ReqestBC);
                    }
                }, 10L);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    public void onDestory() {
        BusProvider.unRegister((Object)((Object)this));
    }

    private static class MyHandler
    extends WeakReferenceHandler<CertItemView> {
        public MyHandler(CertItemView reference) {
            super((Object)reference);
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void handleMessage(CertItemView reference, Message msg) {
            reference.chipBean = (ChipBean)msg.obj;
            if (msg.what == 0) {
                if (reference.chipBean.getState() == CertState.SUCCESS && !reference.chipBean.getIsVerify()) {
                    reference.showCertDetail(R.string.cert_not_in_system, reference.chipBean);
                    return;
                }
                if (reference.chipBean.getState() == CertState.NO_CERT) {
                    reference.showNoCert();
                    return;
                }
                reference.showCertDetail(R.string.normal_state_item, reference.chipBean);
                return;
            }
            if (reference.chipBean.getState() == CertState.NO_CERT) {
                reference.showNoCert();
                return;
            }
            reference.showCertDetail(R.string.normal_state_item, reference.chipBean);
        }
    }
}

