/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.view;

import android.content.Context;
import android.text.TextUtils;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;

public class PinDialog {
    Context context;
    BindIdentifyDialog dialog;
    CryptoDevType cardType;
    HandlePinResult handlePinResult;

    public PinDialog(Context context, CryptoDevType cardType, HandlePinResult pinResult) {
        this(context, cardType);
        this.handlePinResult = pinResult;
    }

    public PinDialog(Context context, CryptoDevType cardType) {
        this.context = context;
        this.cardType = cardType;
        if (this.dialog == null) {
            this.dialog = new BindIdentifyDialog(context);
            this.dialog.setTitle(R.string.input_PIN);
            this.dialog.setNegativeButtonText(R.string.cancel);
            this.dialog.setPositiveButtonText(R.string.confirm);
            this.dialog.setModel(3);
            this.dialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

                public void doConfirm() {
                    PinDialog.this.verifyPinCode(PinDialog.this.dialog.getPinCode());
                }

                public void doCancel() {
                    PinDialog.this.dialog.dismiss();
                    PinDialog.this.dialog.clearPin();
                }
            });
        }
    }

    public void show() {
        if (this.dialog != null) {
            this.dialog.show();
        }
    }

    private void verifyPinCode(String code) {
        ModuleLog.e((Object)("pinCode = " + code));
        if (TextUtils.isEmpty((CharSequence)code)) {
            return;
        }
        if (code.length() < 6 || code.length() > 16) {
            this.dialog.showPinTips(this.context.getString(R.string.pin_length_short));
            return;
        }
        DeviceWrapper.getInstance();
        int pinResult = DeviceWrapper.verifyPin(this.cardType, code);
        if (pinResult == 0) {
            if (this.dialog.isShowing()) {
                this.dialog.dismiss();
                this.dialog.clearPin();
            }
            if (!AppConfig.getInstance().getPin().equals(code)) {
                AppConfig.getInstance().setPin(code);
            }
            if (this.handlePinResult != null) {
                this.handlePinResult.onSuccess();
            }
        } else if (this.pinErrorOrLocked(pinResult)) {
            this.show();
            ModuleLog.e((Object)("handlePinResult = " + pinResult));
            this.dialog.showPinTips(CryptoDevManager.getInstance().getErrorText(pinResult));
        } else {
            this.dialog.dismiss();
            this.dialog.clearPin();
            if (this.handlePinResult != null) {
                this.handlePinResult.onFail(pinResult);
            }
        }
    }

    private boolean pinErrorOrLocked(int pinResult) {
        return pinResult > 2000 && pinResult < 2010 || pinResult == 2026 || pinResult == 2020;
    }

    public static interface HandlePinResult {
        public void onSuccess();

        public void onFail(int var1);
    }
}

