/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.cloudwalk.IDCardSDK;
import cn.cloudwalk.callback.IDCardImgCallback;
import cn.cloudwalk.jni.IDCardImg;
import cn.cloudwalk.libproject.camera.AutoFocusCameraPreview;
import cn.cloudwalk.libproject.camera.Delegate;
import cn.cloudwalk.libproject.util.Base64Util;
import cn.cloudwalk.libproject.util.ImgUtil;
import cn.cloudwalk.libproject.util.Util;
import com.aircert.SPermission;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.listener.OnPermissionListener;
import com.aircert.util.CommonUtil;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.ResolveIdentifyRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import ocr.bean.IDCardInfo;
import ocr.view.OcrMaskView;
import okhttp3.Call;

public class OcrActivity
extends BaseActivity
implements IDCardImgCallback,
Delegate {
    private static final int OCR_FRONT = 1;
    private static final int OCR_BACK = 0;
    public static String FRONT_FILEPATH_KEY = "front_filepath_key";
    public static String BACK_FILEPATH_KEY = "back_filepath_key";
    private int ocr_type = -1;
    private String frontFilePath;
    private String backFilePath;
    private IDCardSDK iDCardSDK;
    private int initRet = -1;
    private MyHandler myHandler = null;
    SPermission sPermission;
    private BindIdentifyDialog commonDialog;
    private static final int CANCEL_FOCUS = 0;
    private static final int DRAW_LINE = 1;
    private static final int DELAY_RESULT = 2;
    private IDCardImg idCardImg;
    private static final int FIRST_TIME = 1;
    private static final int SECOND_TIME = 2;
    private int time = 0;
    private AutoFocusCameraPreview mAutoFocusCameraPreview;
    private OcrMaskView ocrMaskView;
    private ImageView mIv_idrect;
    private Bitmap bmpCanLine;
    private Bitmap bmpfocus;
    private Bitmap bmpfocused;
    private RelativeLayout take_picture_success;
    private TextView bottom_text;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                OcrActivity.this.ocrMaskView.clearFocus();
            }
            super.handleMessage(msg);
        }
    };
    public String faceImg = "";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.activity_rect_ocr);
        this.sPermission = new SPermission(this.getApplicationContext());
        this.init();
        this.ocr_type = 1;
        this.myHandler = new MyHandler(this);
        this.initSDK();
        this.initCallback();
        this.setDelegate();
        this.deleteCachedJpg();
    }

    protected boolean hasActionBar() {
        return false;
    }

    private void init() {
        this.bmpCanLine = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.scan_line);
        this.bmpfocus = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.focus);
        this.bmpfocused = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.focused);
        this.mAutoFocusCameraPreview = (AutoFocusCameraPreview)this.findViewById(R.id.preview);
        this.ocrMaskView = (OcrMaskView)this.findViewById(R.id.ocrMaskView);
        this.take_picture_success = (RelativeLayout)this.findViewById(R.id.take_success);
        this.take_picture_success.setVisibility(8);
        this.mIv_idrect = (ImageView)this.findViewById(R.id.iv_idrect);
        this.mIv_idrect.setImageResource(R.drawable.take_photo_front);
        this.bottom_text = (TextView)this.findViewById(R.id.bottom_text);
        this.bottom_text.setText(R.string.ocr_front_tip);
    }

    private void initSDK() {
        this.iDCardSDK = IDCardSDK.getInstance((Context)this.getApplicationContext());
        if (this.initRet != 0) {
            this.initRet = this.iDCardSDK.cwCreateIdCardRecog("NDI|zMTExbm9kZXZpY2Vjd2F1dGhvcml6Zb7n5efi5+Xq3+bg5efm5Of/5efi4Obg5Yjm5uvl5ubrkeXm5uvl5uai6+Xm5uvl5uTm6+Xm5ufl/+bm5OY=");
        }
        if (this.initRet != 0) {
            this.showDialog();
        }
    }

    private void initCallback() {
        this.iDCardSDK.cwIDCardImgCallback((IDCardImgCallback)this);
    }

    private void deleteCachedJpg() {
        try {
            String frontPath = Util.getDiskCacheDir((Context)this) + "/frontphoto.jpg";
            String backPath = Util.getDiskCacheDir((Context)this) + "/backphoto.jpg";
            File frontFile = new File(frontPath);
            File backFile = new File(backPath);
            if (frontFile.exists()) {
                frontFile.delete();
            }
            if (backFile.exists()) {
                backFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onResume() {
        super.onResume();
        int ocrType = this.getOcrType();
        this.mAutoFocusCameraPreview.setFlag(ocrType);
        this.mAutoFocusCameraPreview.cwStartCamera();
        this.requestCameraPermission();
    }

    private void requestCameraPermission() {
        this.sPermission.setMOUDLE(2).setmRequestCode(1).setPermissions(new String[]{"android.permission.CAMERA"}).setmOnPermissionListener(new OnPermissionListener(){

            public void onPermissionGranted() {
                OcrActivity.this.stopCamera();
                OcrActivity.this.startCamera();
            }

            public void onPermissionDenied(String[] strings) {
                OcrActivity.this.createCommonDialog(R.string.ocr_some_powers_has_forbid, R.string.ocr_some_powers_has_forbid_content, R.string.cancel, R.string.open_power);
                OcrActivity.this.commonDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

                    public void doConfirm() {
                        OcrActivity.this.commonDialog.dismiss();
                        OcrActivity.this.requestCameraPermission();
                    }

                    public void doCancel() {
                        OcrActivity.this.commonDialog.dismiss();
                        OcrActivity.this.finish();
                    }
                });
            }

            public void onPermissionDeniedAlways(String[] strings) {
                OcrActivity.this.createCommonDialog(R.string.acu_can_not_open_power_title, R.string.acu_can_not_open_power_content, R.string.text_cancel, R.string.acu_can_not_open_power_right_button);
                OcrActivity.this.commonDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

                    public void doConfirm() {
                        OcrActivity.this.commonDialog.dismiss();
                        CommonUtil.getAppDetailSettingIntent((Context)OcrActivity.this.getApplicationContext());
                    }

                    public void doCancel() {
                        OcrActivity.this.commonDialog.dismiss();
                    }
                });
            }
        }).requestPermissions();
    }

    private void createCommonDialog(int titleRes, int contentRes, int leftButtonRes, int rightButtonRes) {
        this.commonDialog = new BindIdentifyDialog(this.getApplicationContext());
        this.commonDialog.setTitle(titleRes);
        this.commonDialog.setMessage(contentRes);
        this.commonDialog.setPositiveButtonText(rightButtonRes);
        this.commonDialog.setNegativeButtonText(leftButtonRes);
        this.commonDialog.setModel(1);
        this.commonDialog.setCanceledOnTouchOutside(false);
        this.commonDialog.show();
    }

    private void showDialog() {
        new AlertDialog.Builder((Context)this).setMessage(R.string.facedectfail_appid).setNegativeButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                arg0.dismiss();
            }
        }).show();
    }

    private int getOcrType() {
        return this.ocr_type;
    }

    private void doRecog(IDCardImg idCardImg, int typeFlag) {
        String filePath = "";
        if (typeFlag == 1) {
            this.frontFilePath = filePath = Util.getDiskCacheDir((Context)this) + "/frontphoto.jpg";
        } else if (typeFlag == 0) {
            this.backFilePath = filePath = Util.getDiskCacheDir((Context)this) + "/backphoto.jpg";
        }
        Bitmap bitmap = ImgUtil.byteArrayBGRToBitmap((byte[])idCardImg.ImgData, (int)idCardImg.detect_width, (int)idCardImg.detect_height);
        ImgUtil.saveJPGE_After((Bitmap)bitmap, (String)filePath, (int)95);
        if (this.ocr_type == 0) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    OcrActivity.this.resolveIdentifyInfo();
                }
            });
        }
        if (this.ocr_type == 1) {
            this.wait2Seconds();
        }
    }

    private void wait2Seconds() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                OcrActivity.this.stopCamera();
                OcrActivity.this.showSuccessTip();
            }
        });
        if (this.myHandler != null) {
            this.myHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    OcrActivity.this.dissmissSuccessTip();
                    OcrActivity.this.startCamera();
                    OcrActivity.this.ocr_type = 0;
                    OcrActivity.this.setDelegate();
                    OcrActivity.this.setIdRectBackground(R.drawable.take_photo_reverse);
                }
            }, 2000L);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.ocr_type = -1;
        if (null != this.iDCardSDK) {
            this.iDCardSDK.cwDestroyIdCardRecog();
        }
        this.destroyView();
        if (this.myHandler != null) {
            this.myHandler.removeCallbacksAndMessages(null);
        }
    }

    public void IDCardImg(IDCardImg idCardImg) {
    }

    public void IDCardDetectOk(IDCardImg idCardImg) {
        this.idCardImg = idCardImg;
        if (this.ocr_type == 0 && this.time == 1) {
            this.time = 2;
            this.doRecog(idCardImg, this.ocr_type);
        } else if (this.ocr_type == 1) {
            this.time = 1;
            this.doRecog(idCardImg, this.ocr_type);
        }
    }

    public void onOpenCameraError() {
    }

    public void onFocus(float x, float y) {
        this.ocrMaskView.setFocus(x, y);
    }

    public void onFocused() {
        this.ocrMaskView.setFocused();
        this.mHandler.sendEmptyMessageDelayed(0, 150L);
    }

    private void setIdRectBackground(int resId) {
        this.mIv_idrect.setImageResource(resId);
    }

    public void onStop() {
        this.mAutoFocusCameraPreview.cwStopCamera();
        this.mHandler.removeCallbacksAndMessages(null);
        super.onStop();
    }

    private void startCamera() {
        this.mAutoFocusCameraPreview.cwStartCamera();
    }

    private void stopCamera() {
        this.mAutoFocusCameraPreview.cwStopCamera();
    }

    private void destroyView() {
        if (this.bmpCanLine != null && !this.bmpCanLine.isRecycled()) {
            this.bmpCanLine.recycle();
        }
        if (this.bmpfocus != null && !this.bmpfocus.isRecycled()) {
            this.bmpfocus.recycle();
        }
        if (this.bmpfocused != null && !this.bmpfocused.isRecycled()) {
            this.bmpfocused.recycle();
        }
    }

    private void cwDrawLine(int left, int top, int right, int bottom) {
        this.ocrMaskView.setLine(left, top, right, bottom);
    }

    private void clearFocus() {
        this.ocrMaskView.clearFocus();
    }

    private void setDelegate() {
        if (this.getOcrType() == 0) {
            this.bottom_text.setText(R.string.ocr_back_tip);
        }
        this.mAutoFocusCameraPreview.setDelegate((Delegate)this);
        this.mAutoFocusCameraPreview.setFlag(this.getOcrType());
        this.mAutoFocusCameraPreview.setSizeCallback(new AutoFocusCameraPreview.SizeCallback(){

            public void onSizeChange(int width, int height, int ocrRectW, int ocrRectH) {
                OcrActivity.this.ocrMaskView.setOcr(width, height, ocrRectW, ocrRectH, OcrActivity.this.getOcrType(), OcrActivity.this.bmpCanLine, OcrActivity.this.bmpfocus, OcrActivity.this.bmpfocused);
            }
        });
        this.mAutoFocusCameraPreview.cwStartCamera();
    }

    private void showSuccessTip() {
        this.take_picture_success.setVisibility(0);
    }

    private void dissmissSuccessTip() {
        this.take_picture_success.setVisibility(8);
    }

    private ResolveIdentifyRequest buildResolveIdentifyRequest() {
        String frontBase64 = this.bitmap2Base64(this.frontFilePath);
        String backBase64 = this.bitmap2Base64(this.backFilePath);
        if (TextUtils.isEmpty((CharSequence)frontBase64) || TextUtils.isEmpty((CharSequence)backBase64)) {
            return null;
        }
        ResolveIdentifyRequest resolveIdentifyRequest = new ResolveIdentifyRequest();
        resolveIdentifyRequest.setFacadeImg(frontBase64);
        resolveIdentifyRequest.setContraryImg(backBase64);
        return resolveIdentifyRequest;
    }

    private void resolveIdentifyInfo() {
        ResolveIdentifyRequest resolveIdentifyRequest = this.buildResolveIdentifyRequest();
        if (resolveIdentifyRequest == null) {
            return;
        }
        int devType = SharePreferencesUtil.getCurrentDevType((Context)this);
        CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);
        if (TextUtils.isEmpty((CharSequence)cardID)) {
            ModuleToast.show((Context)this, R.string.card_device_error);
            this.finish();
            return;
        }
        this.showLoading();
        if (!CommonUtil.isNetworkConnected((Context)this)) {
            ModuleToast.show((Context)this, R.string.net_disconnected_text);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    OcrActivity.this.dismissLoading();
                }
            }, 1000L);
            return;
        }
        this.service.resoleIdentifyInfo(resolveIdentifyRequest, cardID, new HttpResponseCallBack<IDCardInfo>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            @Override
            public void onSuccessfulResponse(Call call, IDCardInfo idCardInfo) {
                if (idCardInfo != null) {
                    OcrActivity.this.finish();
                    OcrActivity.this.gotoResultActivity(idCardInfo);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String message = baseErrorResponse.getErrCode();
                String errorMsg = OkNetError.handleErrorCodeToMsg((Context)OcrActivity.this, message);
            }

            @Override
            public void dismissDialog() {
                OcrActivity.this.dismissLoading();
            }
        });
    }

    private void gotoResultActivity(IDCardInfo info) {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null && bundle.containsKey("faceImg")) {
            this.faceImg = bundle.getString("faceImg");
        }
        if (!TextUtils.isEmpty((CharSequence)this.faceImg) && info != null) {
            ARouter.getInstance().build("/cert/ocr_yuncong").withString("faceImg", this.faceImg).withParcelable("identify_info", (Parcelable)info).navigation((Context)this);
        }
    }

    private String bitmap2Base64(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        Bitmap bitmapByPath = ImgUtil.getBitmapByPath((String)path);
        if (bitmapByPath == null) {
            return null;
        }
        byte[] imgData = ImgUtil.bitmapToByte((Bitmap)bitmapByPath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG, (int)90);
        String imgBase64 = Base64Util.encode((byte[])imgData);
        imgData = null;
        return imgBase64;
    }

    static class MyHandler
    extends Handler {
        WeakReference<OcrActivity> ocrPresenterWeakReference;

        public MyHandler(OcrActivity ocrPresenter) {
            this.ocrPresenterWeakReference = new WeakReference<OcrActivity>(ocrPresenter);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (this.ocrPresenterWeakReference != null && this.ocrPresenterWeakReference.get() != null) {
                if (msg.what == 0) {
                    ((OcrActivity)((Object)this.ocrPresenterWeakReference.get())).clearFocus();
                } else if (msg.what == 1) {
                    Rect rect = (Rect)msg.obj;
                    ((OcrActivity)((Object)this.ocrPresenterWeakReference.get())).cwDrawLine(rect.left, rect.top, rect.right, rect.bottom);
                }
            }
        }
    }
}

