/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.driver.DriverDevChangedListener;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerError;
import com.xdja.cryptodev.driver.xdja.XdjaError;
import com.xdja.cryptodev.error.ErrorCallback;
import com.xdja.cryptodev.error.SysError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CryptoDevManager
implements DriverDevChangedListener {
    private static CryptoDevManager manager = null;
    private Context context = null;
    private static final String THIS_FILE = "CryptoDevManager";
    private ArrayList<IDevDriver> drivers = new ArrayList();
    private Vector<CryptoDevInfo> devList = new Vector();
    private HandlerThread handlerThread = new HandlerThread("cryptodev_thread");
    private Handler myHandler;
    private SysError errorManager = new SysError();
    private boolean scanning = false;

    public boolean isScanning() {
        return this.scanning;
    }

    private CryptoDevManager() {
        this.handlerThread.start();
        this.myHandler = new Handler(this.handlerThread.getLooper());
    }

    public static synchronized CryptoDevManager getInstance() {
        if (manager == null) {
            manager = new CryptoDevManager();
            manager.registerError(new XdjaError());
            manager.registerError(new ChipManagerError());
        }
        return manager;
    }

    private void registerError(ErrorCallback errorCallback) {
        this.errorManager.registerError(errorCallback);
    }

    public String getErrorText(int errCode) {
        return this.errorManager.getErrorText(errCode);
    }

    public void setContext(Context context) {
        this.context = context;
        this.errorManager.setContext(context);
    }

    public Context getContext() {
        return this.context;
    }

    public void registerDriver(final IDevDriver driver) {
        this.myHandler.post(new Runnable(){

            @Override
            public void run() {
                CryptoDevManager.this.scanning = true;
                for (IDevDriver drv : CryptoDevManager.this.drivers) {
                    if (!drv.getDriverName().equals(driver.getDriverName())) continue;
                    Log.d((String)CryptoDevManager.THIS_FILE, (String)("Driver " + drv.getDriverName() + " already registered"));
                    CryptoDevManager.this.scanning = false;
                    return;
                }
                int status = driver.init();
                if (status != 0) {
                    Log.e((String)CryptoDevManager.THIS_FILE, (String)("Driver " + driver.getDriverName() + " init error. ret " + status));
                    driver.destroy();
                    CryptoDevManager.this.scanning = false;
                    return;
                }
                driver.registerDevChangedListener(manager);
                CryptoDevManager.this.devList.addAll(driver.getDevList());
                CryptoDevManager.this.drivers.add(driver);
                CryptoDevManager.this.scanning = false;
            }
        });
    }

    public void unregisterDriver(final String driverName) {
        this.myHandler.post(new Runnable(){

            @Override
            public void run() {
                IDevDriver driver = null;
                for (IDevDriver drv : CryptoDevManager.this.drivers) {
                    if (!drv.getDriverName().equals(driverName)) continue;
                    driver = drv;
                }
                if (driver == null) {
                    Log.e((String)CryptoDevManager.THIS_FILE, (String)("Driver " + driverName + " not exist!"));
                    return;
                }
                Iterator devIterator = CryptoDevManager.this.devList.iterator();
                while (devIterator.hasNext()) {
                    CryptoDevInfo devInfo = (CryptoDevInfo)devIterator.next();
                    if (!devInfo.getDriver().equals(driver.getDriverName())) continue;
                    devIterator.remove();
                }
                driver.unregisterDevChangedListener(manager);
                driver.destroy();
                CryptoDevManager.this.drivers.remove(driver);
            }
        });
    }

    public int getDevCount() {
        return this.devList.size();
    }

    public List<CryptoDevInfo> getCryptoDevInfos() {
        return this.devList;
    }

    public CryptoInstance createInstance(String driver, CryptoDevType type) {
        for (CryptoDevInfo devInfo : this.devList) {
            if (devInfo == null || !devInfo.getDriver().equals(driver) || devInfo.getType() != type) continue;
            return this.createInstance(devInfo);
        }
        return null;
    }

    public CryptoInstance createInstance(CryptoDevInfo info) {
        for (IDevDriver driver : this.drivers) {
            if (!driver.getDriverName().equals(info.getDriver())) continue;
            return driver.getInstance(info);
        }
        return null;
    }

    public CryptoInstance createInstance(String cardId) {
        for (CryptoDevInfo devInfo : this.devList) {
            if (!devInfo.getCardId().equals(cardId)) continue;
            return this.createInstance(devInfo);
        }
        return null;
    }

    public static boolean inDevList(List<CryptoDevInfo> devInfos, String cardId) {
        if (devInfos != null) {
            for (CryptoDevInfo devInfo : devInfos) {
                if (!cardId.equals(devInfo.cardId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onDevChanged(IDevDriver driver) {
        Log.d((String)THIS_FILE, (String)("driver " + driver.getDriverName() + " device changed. Refresh dev list"));
        Iterator<CryptoDevInfo> devIter = this.devList.iterator();
        while (devIter.hasNext()) {
            CryptoDevInfo devInfo = devIter.next();
            if (!devInfo.getDriver().equals(driver.getDriverName())) continue;
            devIter.remove();
        }
        this.devList.addAll(driver.getDevList());
        Log.d((String)THIS_FILE, (String)("Current has " + this.devList.size() + " device in system"));
    }
}

