/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.devapi;

import android.util.Log;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.devapi.CommonInterface;
import com.xdja.cryptodev.devapi.GMInterface;
import com.xdja.cryptodev.devapi.IDevStateListener;
import com.xdja.cryptodev.devapi.XdjaCommonInterface;
import com.xdja.cryptodev.driver.IDevDriver;
import java.util.ArrayList;

public abstract class CryptoInstance
implements CommonInterface,
GMInterface,
XdjaCommonInterface {
    protected IDevDriver driver;
    protected CryptoDevInfo devInfo;
    private int refCnt = 0;
    protected ArrayList<IDevStateListener> listeners = new ArrayList();
    private static final String THIS_FILE = "CryptoDev";

    public CryptoInstance(IDevDriver driver, CryptoDevInfo devInfo) {
        this.driver = driver;
        this.devInfo = devInfo;
    }

    public CryptoDevInfo getDevInfo() {
        return this.devInfo;
    }

    public synchronized void addStateListener(IDevStateListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeStateListener(IDevStateListener listener) {
        this.listeners.remove(listener);
    }

    public String getCardId() {
        return this.devInfo.getCardId();
    }

    public void onError(int code) {
        for (IDevStateListener listener : this.listeners) {
            listener.onDevError(code);
        }
    }

    public void destroy() {
        if (--this.refCnt == 0) {
            Log.d((String)THIS_FILE, (String)"Refernce count is 0, destroy instance");
            this.listeners.clear();
            this.driver.getCryptoList().remove(this);
            return;
        }
        Log.d((String)THIS_FILE, (String)("Refernce count is " + this.refCnt));
    }

    public void addRef() {
        ++this.refCnt;
        Log.d((String)THIS_FILE, (String)("Refernce count is " + this.refCnt));
    }
}

