/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.driver.chipmanager;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Process;
import android.util.Log;
import android.util.Pair;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerKey;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.param.JniApiParam;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ChipManagerDriver
extends IDevDriver
implements JarMultiChipStatusManager.MultiChipStatusListener {
    public static final String DRIVER_NAME = "ChipManager-key";
    private static final String THIS_FILE = "ChipManagerDriver";
    private Context context = null;
    private BroadcastReceiver sdcardReceiver;
    private JarMultiJniApiManager jniApiManager = JarMultiJniApiManager.getInstance();

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public int init() {
        this.context = CryptoDevManager.getInstance().getContext();
        Log.d((String)THIS_FILE, (String)"Resiger chip status listener");
        JarMultiChipStatusManager.getInstance().registerListener(this.context, (JarMultiChipStatusManager.MultiChipStatusListener)this);
        this.sdcardReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action;
                switch (action = intent.getAction()) {
                    case "android.intent.action.MEDIA_EJECT": {
                        Log.d((String)ChipManagerDriver.THIS_FILE, (String)"Media disk eject");
                        Iterator devIterator = ChipManagerDriver.this.cryptoDevs.iterator();
                        while (devIterator.hasNext()) {
                            CryptoInstance dev = (CryptoInstance)devIterator.next();
                            if (dev.getDevInfo().getType() != CryptoDevType.DEV_TYPE_SdCard) continue;
                            int ret = dev.open();
                            if (ret == 0) {
                                dev.close();
                                continue;
                            }
                            dev.close();
                            dev.onError(1005);
                            devIterator.remove();
                        }
                        ChipManagerDriver.this.refresh();
                        break;
                    }
                    case "android.intent.action.MEDIA_MOUNTED": {
                        Log.d((String)ChipManagerDriver.THIS_FILE, (String)"Media disk mounted. Need to rescan tf device");
                        ChipManagerDriver.this.refresh();
                    }
                }
            }
        };
        IntentFilter sdcardFilter = new IntentFilter();
        sdcardFilter.addAction("android.intent.action.MEDIA_EJECT");
        sdcardFilter.addAction("android.intent.action.MEDIA_MOUNTED");
        sdcardFilter.addDataScheme("file");
        this.context.registerReceiver(this.sdcardReceiver, sdcardFilter);
        this.refresh();
        return 0;
    }

    @Override
    public int refresh() {
        CryptoDevInfo devInfo;
        this.devInfos.clear();
        Pair all = this.jniApiManager.getAll(this.context);
        if ((Integer)all.first != 0) {
            Log.e((String)THIS_FILE, (String)("Get devices error. ret " + all.first));
        } else {
            Log.e((String)"jff", (String)("all.second.size() = " + ((List)all.second).size()));
            for (JniApiParam param : (List)all.second) {
                devInfo = new CryptoDevInfo();
                devInfo.setType(this.typeCovert(param.chipType));
                devInfo.setCardId(param.cardId);
                devInfo.setDriver(DRIVER_NAME);
                this.jniApiManager.make(this.context, devInfo.getCardId());
                this.devInfos.add(devInfo);
            }
        }
        if (this.devInfos.size() == 0) {
            Pair vs = this.jniApiManager.make(this.context, 16);
            JarJniApiProxy jniApiProxy = (JarJniApiProxy)vs.second;
            if (jniApiProxy != null) {
                devInfo = new CryptoDevInfo();
                devInfo.setType(this.typeCovert(jniApiProxy.getCardType()));
                devInfo.setCardId((String)jniApiProxy.getCardId().second);
                devInfo.setDriver(DRIVER_NAME);
                this.jniApiManager.make(this.context, 16);
                this.devInfos.add(devInfo);
            }
        }
        return super.refresh();
    }

    @Override
    public CryptoInstance createInstance(CryptoDevInfo devInfo) {
        ChipManagerKey dev = new ChipManagerKey(this, devInfo);
        this.cryptoDevs.add(dev);
        return dev;
    }

    private CryptoDevType typeCovert(int cmType) {
        switch (cmType) {
            case 2: {
                return CryptoDevType.DEV_TYPE_SdCard;
            }
            case 1: {
                return CryptoDevType.DEV_TYPE_Chip;
            }
            case 4: {
                return CryptoDevType.DEV_TYPE_BlueTooth;
            }
            case 8: {
                return CryptoDevType.DEV_TYPE_SimKey;
            }
            case 16: {
                return CryptoDevType.DEV_TYPE_VHSM;
            }
        }
        return CryptoDevType.DEV_TYPE_Chip;
    }

    @Override
    public void destroy() {
        this.context.unregisterReceiver(this.sdcardReceiver);
        JarMultiChipStatusManager.getInstance().unregisterListener((JarMultiChipStatusManager.MultiChipStatusListener)this);
        this.killOtherProcess(this.context);
        super.destroy();
    }

    private void killOtherProcess(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List runingProcessInfo = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : runingProcessInfo) {
            if (info.pid == Process.myPid() || Arrays.binarySearch(info.pkgList, context.getPackageName()) < 0) continue;
            Process.killProcess((int)info.pid);
        }
    }

    public void chipAdd(String s, int i) {
        Log.d((String)THIS_FILE, (String)("Device id " + s + " added, type " + i));
        for (CryptoDevInfo devInfo : this.devInfos) {
            if (!devInfo.getCardId().equals(s)) continue;
            Log.d((String)THIS_FILE, (String)("Device id " + s + " already in devlist"));
            return;
        }
        this.refresh();
    }

    public void chipRemove(int i) {
        Log.d((String)THIS_FILE, (String)("Device type " + i + " removed"));
        this.refresh();
    }

    public void serviceDeath() {
        Log.d((String)THIS_FILE, (String)"Service died");
    }

    public void serviceStart() {
        Log.d((String)THIS_FILE, (String)"Service start");
    }
}

